/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.commands;

import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import us.eunoians.mcrpg.McRPG;
import us.eunoians.mcrpg.api.exceptions.McRPGPlayerNotFoundException;
import us.eunoians.mcrpg.api.util.Methods;
import us.eunoians.mcrpg.gui.GUI;
import us.eunoians.mcrpg.gui.GUITracker;
import us.eunoians.mcrpg.gui.RedeemStoredGUI;
import us.eunoians.mcrpg.players.McRPGPlayer;
import us.eunoians.mcrpg.players.PlayerManager;
import us.eunoians.mcrpg.types.Skills;

public class McRedeem
implements CommandExecutor {
    public boolean onCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        McRPG mcRPG = McRPG.getInstance();
        if (commandSender instanceof Player) {
            McRPGPlayer mcRPGPlayer;
            Player player = (Player)commandSender;
            if (PlayerManager.isPlayerFrozen(player.getUniqueId())) {
                return true;
            }
            String string2 = player.getWorld().getName();
            if (McRPG.getInstance().getConfig().contains("Configuration.DisabledWorlds") && McRPG.getInstance().getConfig().getStringList("Configuration.DisabledWorlds").contains(string2)) {
                return true;
            }
            if (mcRPG.getConfig().getBoolean("Configuration.UseRedeemPerm") && !player.hasPermission("mcrpg.*") && !player.hasPermission("mcrpg.redeem")) {
                player.sendMessage(Methods.color(mcRPG.getPluginPrefix() + mcRPG.getLangFile().getString("Messages.Commands.Utility.NoPerms")));
                return true;
            }
            if (stringArray.length < 1) {
                player.sendMessage(Methods.color(mcRPG.getPluginPrefix() + mcRPG.getLangFile().getString("Messages.Commands.Utility.HelpPrompt").replace("<command>", "mcredeem")));
                return true;
            }
            if (!Skills.isSkill(stringArray[0])) {
                player.sendMessage(Methods.color(mcRPG.getPluginPrefix() + mcRPG.getLangFile().getString("Messages.Commands.Utility.NotASkill")));
                return true;
            }
            Skills skills = Skills.fromString(stringArray[0]);
            try {
                mcRPGPlayer = PlayerManager.getPlayer(player.getUniqueId());
            }
            catch (McRPGPlayerNotFoundException mcRPGPlayerNotFoundException) {
                return true;
            }
            RedeemStoredGUI redeemStoredGUI = new RedeemStoredGUI(mcRPGPlayer, skills);
            player.openInventory(redeemStoredGUI.getGui().getInv());
            GUITracker.trackPlayer(player, (GUI)redeemStoredGUI);
            return true;
        }
        commandSender.sendMessage(Methods.color(mcRPG.getPluginPrefix() + mcRPG.getConfig().getString("Messages.Commands.Utility.OnlyPlayers")));
        return true;
    }
}

