/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.commands;

import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import us.eunoians.mcrpg.McRPG;
import us.eunoians.mcrpg.api.displays.DisplayManager;
import us.eunoians.mcrpg.api.displays.ExpActionBar;
import us.eunoians.mcrpg.api.displays.ExpBossbarDisplay;
import us.eunoians.mcrpg.api.displays.ExpScoreboardDisplay;
import us.eunoians.mcrpg.api.exceptions.McRPGPlayerNotFoundException;
import us.eunoians.mcrpg.api.util.Methods;
import us.eunoians.mcrpg.players.McRPGPlayer;
import us.eunoians.mcrpg.players.PlayerManager;
import us.eunoians.mcrpg.types.DisplayType;
import us.eunoians.mcrpg.types.Skills;

public class McDisplay
implements CommandExecutor {
    public boolean onCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        McRPG mcRPG = McRPG.getInstance();
        DisplayManager displayManager = mcRPG.getDisplayManager();
        FileConfiguration fileConfiguration = mcRPG.getLangFile();
        if (commandSender instanceof Player) {
            Player player = (Player)commandSender;
            if (PlayerManager.isPlayerFrozen(player.getUniqueId())) {
                return true;
            }
            String string2 = player.getWorld().getName();
            if (McRPG.getInstance().getConfig().contains("Configuration.DisabledWorlds") && McRPG.getInstance().getConfig().getStringList("Configuration.DisabledWorlds").contains(string2)) {
                return true;
            }
            if (player.hasPermission("mcrpg.*") || player.hasPermission("mcrpg.display")) {
                if (stringArray.length == 0) {
                    player.sendMessage(Methods.color(mcRPG.getPluginPrefix() + fileConfiguration.getString("Messages.Commands.Utility.HelpPrompt").replaceAll("<command>", "mcdisplay")));
                    return true;
                }
                if (stringArray.length == 1) {
                    if (stringArray[0].equalsIgnoreCase("clear")) {
                        if (displayManager.doesPlayerHaveDisplay(player)) {
                            displayManager.removePlayersDisplay(player);
                            return true;
                        }
                        player.sendMessage(Methods.color(mcRPG.getPluginPrefix() + fileConfiguration.getString("Messages.Commands.McDisplay.NothingToClear")));
                        return true;
                    }
                    if (stringArray[0].equalsIgnoreCase("keep")) {
                        return true;
                    }
                    if (Skills.isSkill(stringArray[0])) {
                        McRPGPlayer mcRPGPlayer;
                        try {
                            mcRPGPlayer = PlayerManager.getPlayer(player.getUniqueId());
                        }
                        catch (McRPGPlayerNotFoundException mcRPGPlayerNotFoundException) {
                            return true;
                        }
                        if (DisplayManager.getInstance().doesPlayerHaveDisplay(player)) {
                            DisplayManager.getInstance().getDisplay(player).cancel();
                            DisplayManager.getInstance().removePlayersDisplay(player);
                        }
                        DisplayType displayType = mcRPGPlayer.getDisplayType();
                        return this.setDisplay(stringArray, displayManager, player, mcRPGPlayer, displayType);
                    }
                    player.sendMessage(Methods.color(mcRPG.getPluginPrefix() + fileConfiguration.getString("Messages.Commands.McDisplay.InvalidInput").replaceAll("%String%", stringArray[0])));
                    return true;
                }
                if (stringArray[0].equalsIgnoreCase("set")) {
                    if (DisplayType.isDisplayType(stringArray[1])) {
                        McRPGPlayer mcRPGPlayer;
                        DisplayType displayType = DisplayType.fromString(stringArray[1]);
                        try {
                            mcRPGPlayer = PlayerManager.getPlayer(player.getUniqueId());
                        }
                        catch (McRPGPlayerNotFoundException mcRPGPlayerNotFoundException) {
                            return true;
                        }
                        mcRPGPlayer.setDisplayType(displayType);
                        player.sendMessage(Methods.color(mcRPG.getPluginPrefix() + fileConfiguration.getString("Messages.Commands.McDisplay.DisplayChanged").replaceAll("%DisplayType%", displayType.getName())));
                        return true;
                    }
                    player.sendMessage(Methods.color(mcRPG.getPluginPrefix() + fileConfiguration.getString("Commands.McDisplay.InvalidInput").replaceAll("%String%", stringArray[0])));
                    return true;
                }
                if (Skills.isSkill(stringArray[0])) {
                    if (DisplayType.isDisplayType(stringArray[1])) {
                        McRPGPlayer mcRPGPlayer;
                        try {
                            mcRPGPlayer = PlayerManager.getPlayer(player.getUniqueId());
                        }
                        catch (McRPGPlayerNotFoundException mcRPGPlayerNotFoundException) {
                            return true;
                        }
                        DisplayType displayType = DisplayType.fromString(stringArray[1]);
                        return this.setDisplay(stringArray, displayManager, player, mcRPGPlayer, displayType);
                    }
                    player.sendMessage(Methods.color(mcRPG.getPluginPrefix() + fileConfiguration.getString("Messages.Commands.McDisplay.InvalidInput").replaceAll("%String%", stringArray[0])));
                    return true;
                }
                player.sendMessage(Methods.color(mcRPG.getPluginPrefix() + fileConfiguration.getString("Messages.Commands.McDisplay.InvalidInput").replaceAll("%String%", stringArray[0])));
                return true;
            }
            player.sendMessage(Methods.color(mcRPG.getPluginPrefix() + fileConfiguration.getString("Messages.Commands.Utility.NoPerms")));
            return true;
        }
        commandSender.sendMessage(Methods.color(mcRPG.getPluginPrefix()) + "&cConsole can not run this command.");
        return true;
    }

    private boolean setDisplay(String[] stringArray, DisplayManager displayManager, Player player, McRPGPlayer mcRPGPlayer, DisplayType displayType) {
        if (displayType.equals((Object)DisplayType.SCOREBOARD)) {
            ExpScoreboardDisplay expScoreboardDisplay = new ExpScoreboardDisplay(mcRPGPlayer, Skills.fromString(stringArray[0]), player.getScoreboard());
            player.setScoreboard(expScoreboardDisplay.getBoard());
            displayManager.setGenericDisplay(expScoreboardDisplay);
            return true;
        }
        if (displayType.equals((Object)DisplayType.BOSS_BAR)) {
            ExpBossbarDisplay expBossbarDisplay = new ExpBossbarDisplay(mcRPGPlayer, Skills.fromString(stringArray[0]));
            displayManager.setGenericDisplay(expBossbarDisplay);
            return true;
        }
        ExpActionBar expActionBar = new ExpActionBar(mcRPGPlayer, Skills.fromString(stringArray[0]));
        displayManager.setGenericDisplay(expActionBar);
        return true;
    }
}

