/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.api.util.levelcmds;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import us.eunoians.mcrpg.McRPG;
import us.eunoians.mcrpg.api.util.FileManager;
import us.eunoians.mcrpg.api.util.Methods;
import us.eunoians.mcrpg.api.util.levelcmds.LevelCommand;
import us.eunoians.mcrpg.players.McRPGPlayer;
import us.eunoians.mcrpg.types.LevelCommandType;
import us.eunoians.mcrpg.types.Skills;

public class LevelCommandManager {
    private Map<LevelCommandType, List<LevelCommand>> levelCommandMap = new HashMap<LevelCommandType, List<LevelCommand>>();

    public LevelCommandManager() {
        this.init();
    }

    private void init() {
        FileConfiguration fileConfiguration = McRPG.getInstance().getFileManager().getFile(FileManager.Files.LEVEL_COMMAND);
        if (!fileConfiguration.contains("Commands")) {
            return;
        }
        for (String string : fileConfiguration.getStringList("Commands")) {
            String[] stringArray = string.split(":");
            if (stringArray.length != 3 || !LevelCommandType.isCommandType(stringArray[0]) || !Methods.isInt(stringArray[1])) {
                Bukkit.getLogger().log(Level.WARNING, "There is an invalid level command that is being skipped: " + string);
                continue;
            }
            LevelCommandType levelCommandType = LevelCommandType.fromString(stringArray[0]);
            int n = Integer.parseInt(stringArray[1]);
            String string2 = stringArray[2];
            LevelCommand levelCommand = new LevelCommand(string2, n, levelCommandType);
            if (this.levelCommandMap.containsKey((Object)levelCommandType)) {
                this.levelCommandMap.get((Object)levelCommandType).add(levelCommand);
                continue;
            }
            ArrayList<LevelCommand> arrayList = new ArrayList<LevelCommand>();
            arrayList.add(levelCommand);
            this.levelCommandMap.put(levelCommandType, arrayList);
        }
    }

    public void reload() {
        this.levelCommandMap.clear();
        this.init();
    }

    public void handleLevelUp(McRPGPlayer mcRPGPlayer, Skills skills, int n, int n2) {
        LevelCommandType levelCommandType = LevelCommandType.fromString(skills.getName());
        int n3 = mcRPGPlayer.getPowerLevel() + 1;
        ++n;
        if (this.levelCommandMap.containsKey((Object)levelCommandType) || this.levelCommandMap.containsKey((Object)LevelCommandType.POWER)) {
            HashMap<Integer, LevelCommand> hashMap = new HashMap<Integer, LevelCommand>();
            HashMap<Integer, LevelCommand> hashMap2 = new HashMap<Integer, LevelCommand>();
            for (int i = 0; i <= n2 - n + 1; ++i) {
                if (i == 0) {
                    if (this.levelCommandMap.containsKey((Object)levelCommandType)) {
                        for (LevelCommand levelCommand : this.levelCommandMap.get((Object)levelCommandType)) {
                            hashMap.put(levelCommand.getLevel(), levelCommand);
                            if (levelCommand.getLevel() != n + i) continue;
                            levelCommand.runForPlayer(mcRPGPlayer.getPlayer());
                        }
                    }
                    if (!this.levelCommandMap.containsKey((Object)LevelCommandType.POWER)) continue;
                    for (LevelCommand levelCommand : this.levelCommandMap.get((Object)LevelCommandType.POWER)) {
                        hashMap2.put(levelCommand.getLevel(), levelCommand);
                        if (levelCommand.getLevel() != n3 + i) continue;
                        levelCommand.runForPlayer(mcRPGPlayer.getPlayer());
                    }
                    continue;
                }
                if (hashMap.containsKey(i + n)) {
                    ((LevelCommand)hashMap.get(i + n)).runForPlayer(mcRPGPlayer.getPlayer());
                }
                if (!hashMap2.containsKey(i + n3)) continue;
                ((LevelCommand)hashMap2.get(i + n3)).runForPlayer(mcRPGPlayer.getPlayer());
            }
        }
    }
}

