/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.api.util.fishing;

import java.util.List;
import org.bukkit.Material;
import us.eunoians.mcrpg.api.util.fishing.EnchantmentMeta;
import us.eunoians.mcrpg.api.util.fishing.FishingItemManager;
import us.eunoians.mcrpg.api.util.fishing.PotionMeta;

public class ShakeItem {
    private Material type;
    private String displayName;
    private List<String> lore;
    private int lowEndAmount;
    private int highEndAmount;
    private int exp;
    private double chance;
    private EnchantmentMeta enchantmentMeta;
    private PotionMeta potionMeta;

    public ShakeItem(String string) {
        this.chance = FishingItemManager.getFishingLootConfig().getDouble(string + "Chance", 5.0);
        this.type = Material.getMaterial((String)FishingItemManager.getFishingLootConfig().getString(string + "Material", "AIR"));
        if (FishingItemManager.getFishingLootConfig().contains(string + "DisplayName")) {
            this.displayName = FishingItemManager.getFishingLootConfig().getString(string + "DisplayName");
        }
        if (FishingItemManager.getFishingLootConfig().contains(string + "Lore")) {
            this.lore = FishingItemManager.getFishingLootConfig().getStringList(string + "Lore");
        }
        String[] stringArray = FishingItemManager.getFishingLootConfig().getString(string + "Amount", "1").split("-");
        this.lowEndAmount = Integer.parseInt(stringArray[0]);
        this.highEndAmount = stringArray.length > 1 ? Integer.parseInt(stringArray[1]) : this.lowEndAmount;
        this.exp = FishingItemManager.getFishingLootConfig().getInt(string + "Exp", 100);
        if (FishingItemManager.getFishingLootConfig().contains(string + "EnchantmentMeta")) {
            this.enchantmentMeta = new EnchantmentMeta(string + "EnchantmentMeta.");
        }
        if (FishingItemManager.getFishingLootConfig().contains(string + "PotionMeta")) {
            this.potionMeta = new PotionMeta(string + "PotionMeta.");
        }
    }

    public Material getType() {
        return this.type;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public List<String> getLore() {
        return this.lore;
    }

    public int getLowEndAmount() {
        return this.lowEndAmount;
    }

    public int getHighEndAmount() {
        return this.highEndAmount;
    }

    public int getExp() {
        return this.exp;
    }

    public double getChance() {
        return this.chance;
    }

    public EnchantmentMeta getEnchantmentMeta() {
        return this.enchantmentMeta;
    }

    public PotionMeta getPotionMeta() {
        return this.potionMeta;
    }
}

