/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.api.util.fishing;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import us.eunoians.mcrpg.api.util.fishing.FishingItemManager;

public class PotionMeta {
    private List<PotionSubMeta> effects = new ArrayList<PotionSubMeta>();
    private boolean isCustomPotion;
    private PotionType potionType;
    private boolean extended;
    private boolean upgraded;
    private boolean isSplash;
    private boolean isLingering;
    private String RGB;

    public PotionMeta(String string) {
        if (FishingItemManager.getFishingLootConfig().contains(string + "Effects")) {
            this.isCustomPotion = true;
            for (String string2 : FishingItemManager.getFishingLootConfig().getStringList(string + "Effects")) {
                this.effects.add(new PotionSubMeta(string2));
            }
        } else {
            this.potionType = PotionType.valueOf((String)FishingItemManager.getFishingLootConfig().getString(string + "PotionType", "WATER"));
            this.extended = FishingItemManager.getFishingLootConfig().getBoolean(string + "Extended", false);
            this.upgraded = FishingItemManager.getFishingLootConfig().getBoolean(string + "Upgraded", false);
        }
        this.isSplash = FishingItemManager.getFishingLootConfig().getBoolean(string + "Splash", false);
        this.isLingering = FishingItemManager.getFishingLootConfig().getBoolean(string + "Lingering", false);
        this.RGB = FishingItemManager.getFishingLootConfig().getString(string + "RGB", "");
    }

    public List<PotionSubMeta> getEffects() {
        return this.effects;
    }

    public boolean isCustomPotion() {
        return this.isCustomPotion;
    }

    public PotionType getPotionType() {
        return this.potionType;
    }

    public boolean isExtended() {
        return this.extended;
    }

    public boolean isUpgraded() {
        return this.upgraded;
    }

    public boolean isSplash() {
        return this.isSplash;
    }

    public boolean isLingering() {
        return this.isLingering;
    }

    public String getRGB() {
        return this.RGB;
    }

    class PotionSubMeta {
        private PotionEffectType effectType;
        private int duration;
        private int level;

        PotionSubMeta(String string) {
            String[] stringArray = string.split(":");
            this.effectType = PotionEffectType.getByName((String)stringArray[0]);
            this.duration = Integer.parseInt(stringArray[2]);
            this.level = Integer.parseInt(stringArray[1]);
        }

        public PotionEffectType getEffectType() {
            return this.effectType;
        }

        public int getDuration() {
            return this.duration;
        }

        public int getLevel() {
            return this.level;
        }
    }
}

