/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.api.util.fishing;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import us.eunoians.mcrpg.McRPG;
import us.eunoians.mcrpg.abilities.BaseAbility;
import us.eunoians.mcrpg.api.util.FileManager;
import us.eunoians.mcrpg.api.util.Methods;
import us.eunoians.mcrpg.api.util.fishing.FishedItemStackFactory;
import us.eunoians.mcrpg.api.util.fishing.FishingItem;
import us.eunoians.mcrpg.api.util.fishing.FishingItemDep;
import us.eunoians.mcrpg.api.util.fishing.FishingResult;
import us.eunoians.mcrpg.api.util.fishing.ShakeItem;
import us.eunoians.mcrpg.api.util.fishing.ShakeResult;
import us.eunoians.mcrpg.players.McRPGPlayer;
import us.eunoians.mcrpg.types.UnlockedAbilities;
import us.eunoians.mcrpg.util.Parser;

public class FishingItemManager {
    private Map<String, List<FishingItem>> categoriesToItems = new HashMap<String, List<FishingItem>>();
    private Map<EntityType, List<ShakeItem>> shakeItems = new HashMap<EntityType, List<ShakeItem>>();
    private static Random rand = new Random();
    private int lowDurability = 0;
    private int highDurability = 0;

    public FishingItemManager() {
        EntityType entityType;
        for (String string : FishingItemManager.getFishingLootConfig().getConfigurationSection("Categories").getKeys(false)) {
            entityType = new ArrayList();
            for (Object object : FishingItemManager.getFishingLootConfig().getConfigurationSection("Categories." + string).getKeys(false)) {
                String string2 = "Categories." + string + "." + (String)object + ".";
                entityType.add(new FishingItem(string2));
            }
            this.categoriesToItems.put(string, (List<FishingItem>)entityType);
        }
        for (String string : FishingItemManager.getFishingLootConfig().getConfigurationSection("ShakeLootTable").getKeys(false)) {
            entityType = EntityType.fromName((String)string);
            ArrayList arrayList = new ArrayList();
            for (String string2 : FishingItemManager.getFishingLootConfig().getConfigurationSection("ShakeLootTable." + string).getKeys(false)) {
                arrayList.add(new ShakeItem("ShakeLootTable." + string + "." + string2 + "."));
            }
            this.shakeItems.put(entityType, arrayList);
        }
        String[] stringArray = FishingItemManager.getFishingLootConfig().getString("DurabilityDamageScale").split("-");
        this.lowDurability = Integer.parseInt(stringArray[0]);
        this.highDurability = stringArray.length > 1 ? Integer.parseInt(stringArray[1]) : 60;
    }

    public FishingResult generateItem(String string, BaseAbility baseAbility, McRPGPlayer mcRPGPlayer) {
        int n;
        int n2;
        int n3;
        FishingItem fishingItem2;
        List<FishingItem> list = this.categoriesToItems.get(string);
        Random random = new Random();
        ArrayList<FishingItem> arrayList = new ArrayList<FishingItem>();
        while (arrayList.isEmpty()) {
            for (FishingItem fishingItem2 : list) {
                int n4;
                Parser parser = fishingItem2.getChance();
                n3 = baseAbility != null && baseAbility.getCurrentTier() != 0 ? baseAbility.getCurrentTier() : 1;
                parser.setVariable("tier", n3);
                int n5 = (int)(parser.getValue() * 1000.0);
                if (n5 < (n4 = random.nextInt(100000))) continue;
                arrayList.add(fishingItem2);
            }
        }
        FishingItem fishingItem3 = (FishingItem)arrayList.get(random.nextInt(arrayList.size()));
        fishingItem2 = fishingItem3.getItemType();
        boolean bl = fishingItem3.getEnchantmentMeta() != null;
        n3 = fishingItem3.getPotionMeta() != null ? 1 : 0;
        String string2 = fishingItem3.getDisplayName();
        List<String> list2 = fishingItem3.getLore();
        if (fishingItem2 == null) {
            Bukkit.broadcastMessage((String)(string + "" + arrayList.size()));
        }
        if (fishingItem2 == Material.AIR || fishingItem2 == null) {
            return new FishingResult(new ItemStack(Material.COD), 1, 10);
        }
        ItemStack itemStack = FishedItemStackFactory.createItem((Material)fishingItem2, string2, list2);
        if (bl) {
            itemStack = FishedItemStackFactory.enchantItem(itemStack, fishingItem3.getEnchantmentMeta());
        } else if (n3 != 0) {
            itemStack = FishedItemStackFactory.convertToPotion(itemStack, fishingItem3.getPotionMeta());
        }
        itemStack = FishedItemStackFactory.damageItem(itemStack, this.lowDurability, this.highDurability);
        if (fishingItem3.getHighEndAmount() > 1) {
            itemStack.setAmount(fishingItem3.getLowEndAmount() + random.nextInt(fishingItem3.getHighEndAmount() - fishingItem3.getLowEndAmount()));
        }
        int n6 = fishingItem3.getLowEndVanillaExpAmount();
        if (fishingItem3.getHighEndVanillaExpAmount() > 0) {
            n6 += random.nextInt(fishingItem3.getHighEndVanillaExpAmount() - n6);
        }
        ArrayList<FishingItemDep> arrayList2 = new ArrayList<FishingItemDep>();
        for (UnlockedAbilities unlockedAbilities : fishingItem3.getDependancies().keySet()) {
            if (!mcRPGPlayer.getAbilityLoadout().contains(unlockedAbilities)) continue;
            FishingItemDep fishingItemDep = fishingItem3.getDependancies().get(unlockedAbilities);
            if (mcRPGPlayer.getBaseAbility(unlockedAbilities).getCurrentTier() < fishingItemDep.getLowTier() || mcRPGPlayer.getBaseAbility(unlockedAbilities).getCurrentTier() > fishingItemDep.getHighTier()) continue;
            Parser parser = fishingItemDep.getActivationEquation();
            parser.setVariable("tier", mcRPGPlayer.getBaseAbility(unlockedAbilities).getCurrentTier());
            n2 = (int)(parser.getValue() * 1000.0);
            if (n2 < (n = random.nextInt(100000))) continue;
            arrayList2.add(fishingItemDep);
        }
        arrayList2.sort(Comparator.comparingInt(FishingItemDep::getPriority));
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        n2 = 0;
        n = 0;
        boolean bl6 = false;
        for (FishingItemDep fishingItemDep : arrayList2) {
            ItemMeta itemMeta = itemStack.getItemMeta();
            assert (itemMeta != null);
            boolean bl7 = fishingItemDep.isOverrideLowerDependencies();
            if (fishingItemDep.getDisplayName() != null && (!bl2 || bl7)) {
                itemMeta.setDisplayName(Methods.color(fishingItemDep.getDisplayName()));
                bl2 = true;
            }
            if (fishingItemDep.getLore() != null && (!bl3 || bl7)) {
                itemMeta.setLore(Methods.colorLore(fishingItemDep.getLore()));
                bl3 = true;
            }
            itemStack.setItemMeta(itemMeta);
            if (fishingItemDep.getPotionMeta() != null && (!bl4 || bl7)) {
                itemStack = FishedItemStackFactory.convertToPotion(itemStack, fishingItemDep.getPotionMeta());
                bl4 = true;
            }
            if (fishingItemDep.getEnchantmentMeta() != null && (!bl5 || bl7)) {
                itemStack = FishedItemStackFactory.enchantItem(itemStack, fishingItemDep.getEnchantmentMeta());
                bl5 = true;
            }
            if (fishingItemDep.getHighEndAmount() > 1 && (n2 == 0 || bl7)) {
                itemStack.setAmount(fishingItemDep.getLowEndAmount() + random.nextInt(fishingItemDep.getHighEndAmount() - fishingItemDep.getLowEndAmount()));
                n2 = 1;
            }
            if (fishingItemDep.getNewType() != Material.AIR && (n == 0 || bl7)) {
                itemStack.setType(fishingItemDep.getNewType());
                n = 1;
            }
            if (fishingItemDep.getHighDamage() == 0 || bl6 && !bl7) continue;
            itemStack = FishedItemStackFactory.damageItem(itemStack, fishingItemDep.getLowDamage(), fishingItemDep.getHighDamage());
            bl6 = true;
        }
        return new FishingResult(itemStack, n6, fishingItem3.getMcrpgExpValue());
    }

    public ShakeResult getShakeItem(EntityType entityType) {
        int n;
        ShakeItem shakeItem2;
        ArrayList<ShakeItem> arrayList = new ArrayList<ShakeItem>();
        while (arrayList.isEmpty()) {
            for (ShakeItem shakeItem2 : this.shakeItems.get(entityType)) {
                int n2;
                n = (int)(shakeItem2.getChance() * 1000.0);
                if (n < (n2 = rand.nextInt(100000))) continue;
                arrayList.add(shakeItem2);
            }
        }
        ShakeItem shakeItem3 = (ShakeItem)arrayList.get(rand.nextInt(arrayList.size()));
        shakeItem2 = FishedItemStackFactory.createItem(shakeItem3.getType(), shakeItem3.getDisplayName(), shakeItem3.getLore());
        if (shakeItem3.getEnchantmentMeta() != null) {
            shakeItem2 = FishedItemStackFactory.enchantItem((ItemStack)shakeItem2, shakeItem3.getEnchantmentMeta());
        }
        if (shakeItem3.getPotionMeta() != null) {
            shakeItem2 = FishedItemStackFactory.convertToPotion((ItemStack)shakeItem2, shakeItem3.getPotionMeta());
        }
        n = shakeItem3.getLowEndAmount();
        if (shakeItem3.getHighEndAmount() > 1) {
            n += rand.nextInt(shakeItem3.getHighEndAmount() - n);
        }
        shakeItem2.setAmount(n);
        return new ShakeResult((ItemStack)shakeItem2, shakeItem3.getExp());
    }

    public boolean canShake(EntityType entityType) {
        return this.shakeItems.containsKey(entityType);
    }

    static FileConfiguration getFishingLootConfig() {
        return McRPG.getInstance().getFileManager().getFile(FileManager.Files.FISHING_LOOT);
    }
}

