/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.api.util.fishing;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import us.eunoians.mcrpg.api.util.fishing.EnchantmentMeta;
import us.eunoians.mcrpg.api.util.fishing.FishingItemDep;
import us.eunoians.mcrpg.api.util.fishing.FishingItemManager;
import us.eunoians.mcrpg.api.util.fishing.PotionMeta;
import us.eunoians.mcrpg.types.UnlockedAbilities;
import us.eunoians.mcrpg.util.Parser;

public class FishingItem {
    private Material itemType;
    private Parser chance;
    private int lowEndAmount;
    private int highEndAmount;
    private int lowEndVanillaExpAmount;
    private int highEndVanillaExpAmount;
    private int mcrpgExpValue;
    private String displayName;
    private List<String> lore;
    private EnchantmentMeta enchantmentMeta;
    private PotionMeta potionMeta;
    private Map<UnlockedAbilities, FishingItemDep> dependancies = new HashMap<UnlockedAbilities, FishingItemDep>();

    public FishingItem(String string) {
        this.itemType = Material.getMaterial((String)FishingItemManager.getFishingLootConfig().getString(string + "Material", "AIR"));
        this.chance = new Parser(FishingItemManager.getFishingLootConfig().getString(string + "Chance", "1.0"));
        String[] stringArray = FishingItemManager.getFishingLootConfig().getString(string + "Amount", "1").split("-");
        this.lowEndAmount = Integer.parseInt(stringArray[0]);
        this.highEndAmount = stringArray.length > 1 ? Integer.parseInt(stringArray[1]) : this.lowEndAmount;
        String[] stringArray2 = FishingItemManager.getFishingLootConfig().getString(string + "DurabilityRange", "0").split("-");
        String[] stringArray3 = FishingItemManager.getFishingLootConfig().getString(string + "VanillaExp", "0").split("-");
        this.lowEndVanillaExpAmount = Integer.parseInt(stringArray3[0]);
        this.highEndVanillaExpAmount = stringArray3.length > 1 ? Integer.parseInt(stringArray3[1]) : this.highEndAmount;
        this.mcrpgExpValue = FishingItemManager.getFishingLootConfig().getInt(string + "McRPGExp", 0);
        if (FishingItemManager.getFishingLootConfig().contains(string + "DisplayName")) {
            this.displayName = FishingItemManager.getFishingLootConfig().getString(string + "DisplayName");
        }
        if (FishingItemManager.getFishingLootConfig().contains(string + "Lore")) {
            this.lore = FishingItemManager.getFishingLootConfig().getStringList(string + "Lore");
        }
        if (FishingItemManager.getFishingLootConfig().contains(string + "EnchantmentMeta")) {
            this.enchantmentMeta = new EnchantmentMeta(string + "EnchantmentMeta.");
        }
        if (FishingItemManager.getFishingLootConfig().contains(string + "PotionMeta")) {
            this.potionMeta = new PotionMeta(string + "PotionMeta.");
        }
        if (FishingItemManager.getFishingLootConfig().contains(string + "Dependencies")) {
            for (String string2 : FishingItemManager.getFishingLootConfig().getConfigurationSection(string + "Dependencies").getKeys(false)) {
                if (!UnlockedAbilities.isAbility(string2)) continue;
                UnlockedAbilities unlockedAbilities = UnlockedAbilities.fromString(string2);
                FishingItemDep fishingItemDep = new FishingItemDep(string + "Dependencies." + string2 + ".");
                this.dependancies.put(unlockedAbilities, fishingItemDep);
            }
        }
    }

    public Material getItemType() {
        return this.itemType;
    }

    public Parser getChance() {
        return this.chance;
    }

    public int getLowEndAmount() {
        return this.lowEndAmount;
    }

    public int getHighEndAmount() {
        return this.highEndAmount;
    }

    public int getLowEndVanillaExpAmount() {
        return this.lowEndVanillaExpAmount;
    }

    public int getHighEndVanillaExpAmount() {
        return this.highEndVanillaExpAmount;
    }

    public int getMcrpgExpValue() {
        return this.mcrpgExpValue;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public List<String> getLore() {
        return this.lore;
    }

    public EnchantmentMeta getEnchantmentMeta() {
        return this.enchantmentMeta;
    }

    public PotionMeta getPotionMeta() {
        return this.potionMeta;
    }

    public Map<UnlockedAbilities, FishingItemDep> getDependancies() {
        return this.dependancies;
    }
}

