/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.api.util.fishing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import us.eunoians.mcrpg.api.util.Methods;
import us.eunoians.mcrpg.api.util.fishing.EnchantmentMeta;
import us.eunoians.mcrpg.api.util.fishing.PotionMeta;

public class FishedItemStackFactory {
    private static Random rand = new Random();

    public static ItemStack createItem(Material material) {
        return new ItemStack(material);
    }

    public static ItemStack createItem(Material material, String string) {
        ItemStack itemStack = new ItemStack(material);
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setDisplayName(Methods.color(string));
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    public static ItemStack createItem(Material material, String string, List<String> list) {
        if (string == null && list == null) {
            return FishedItemStackFactory.createItem(material);
        }
        if (string != null && list == null) {
            return FishedItemStackFactory.createItem(material, string);
        }
        if (string == null) {
            return FishedItemStackFactory.createItem(material, list);
        }
        ItemStack itemStack = new ItemStack(material);
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setDisplayName(Methods.color(string));
        itemMeta.setLore(Methods.colorLore(list));
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    public static ItemStack createItem(Material material, List<String> list) {
        ItemStack itemStack = new ItemStack(material);
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setLore(Methods.colorLore(list));
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    public static ItemStack damageItem(ItemStack itemStack, int n, int n2) {
        if (itemStack.getItemMeta() instanceof Damageable) {
            double d = n + rand.nextInt(n2 - n);
            Damageable damageable = (Damageable)itemStack.getItemMeta();
            double d2 = d / 100.0;
            d = (int)((double)itemStack.getType().getMaxDurability() * d2);
            damageable.setDamage(itemStack.getType().getMaxDurability() - (int)d);
            itemStack.setItemMeta((ItemMeta)damageable);
        }
        return itemStack;
    }

    public static ItemStack convertToPotion(ItemStack itemStack, PotionMeta potionMeta) {
        if (potionMeta.isSplash()) {
            itemStack.setType(Material.SPLASH_POTION);
        } else if (potionMeta.isLingering()) {
            itemStack.setType(Material.LINGERING_POTION);
        } else {
            itemStack.setType(Material.POTION);
        }
        org.bukkit.inventory.meta.PotionMeta potionMeta2 = (org.bukkit.inventory.meta.PotionMeta)itemStack.getItemMeta();
        if (potionMeta2 != null) {
            if (!potionMeta.getRGB().equals("")) {
                List list = Arrays.stream(potionMeta.getRGB().split(":")).map(Integer::parseInt).collect(Collectors.toList());
                potionMeta2.setColor(Color.fromRGB((int)((Integer)list.get(0)), (int)((Integer)list.get(1)), (int)((Integer)list.get(2))));
            }
            if (potionMeta.isCustomPotion()) {
                for (PotionMeta.PotionSubMeta potionSubMeta : potionMeta.getEffects()) {
                    potionMeta2.addCustomEffect(new PotionEffect(potionSubMeta.getEffectType(), potionSubMeta.getDuration() * 20, potionSubMeta.getLevel() - 1), false);
                }
            } else {
                potionMeta2.setBasePotionData(new PotionData(potionMeta.getPotionType(), potionMeta.isExtended(), potionMeta.isUpgraded()));
            }
        }
        itemStack.setItemMeta((ItemMeta)potionMeta2);
        return itemStack;
    }

    public static ItemStack enchantItem(ItemStack itemStack, EnchantmentMeta enchantmentMeta) {
        Map<Enchantment, Integer> map = enchantmentMeta.generateEnchantmentMap();
        if (itemStack.getType() == Material.BOOK || itemStack.getType() == Material.ENCHANTED_BOOK) {
            EnchantmentStorageMeta enchantmentStorageMeta = (EnchantmentStorageMeta)itemStack.getItemMeta();
            boolean bl = enchantmentMeta.isOverrideExistingEnchants();
            if (bl && enchantmentStorageMeta != null) {
                ArrayList arrayList = new ArrayList(enchantmentStorageMeta.getStoredEnchants().keySet());
                Enchantment enchantment = arrayList.iterator();
                while (enchantment.hasNext()) {
                    Enchantment enchantment2 = (Enchantment)enchantment.next();
                    enchantmentStorageMeta.removeStoredEnchant(enchantment2);
                }
            }
            if (enchantmentStorageMeta != null) {
                for (Enchantment enchantment : map.keySet()) {
                    enchantmentStorageMeta.addStoredEnchant(enchantment, map.get(enchantment).intValue(), true);
                }
            }
            itemStack.setItemMeta((ItemMeta)enchantmentStorageMeta);
        } else {
            boolean bl = enchantmentMeta.isOverrideExistingEnchants();
            if (bl) {
                ArrayList arrayList = new ArrayList(itemStack.getEnchantments().keySet());
                Enchantment enchantment = arrayList.iterator();
                while (enchantment.hasNext()) {
                    Enchantment enchantment3 = (Enchantment)enchantment.next();
                    itemStack.removeEnchantment(enchantment3);
                }
            }
            for (Enchantment enchantment : map.keySet()) {
                if (enchantment == null) continue;
                itemStack.addEnchantment(enchantment, map.get(enchantment).intValue());
            }
        }
        return itemStack;
    }
}

