/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.api.util.fishing;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.bukkit.enchantments.Enchantment;
import us.eunoians.mcrpg.api.util.Methods;
import us.eunoians.mcrpg.api.util.fishing.FishingItemEnchant;
import us.eunoians.mcrpg.api.util.fishing.FishingItemManager;

public class EnchantmentMeta {
    private ArrayList<FishingItemEnchant> enchants = new ArrayList();
    private boolean overrideExistingEnchants;
    private int lowEndEnchantAmount;
    private int highEndEnchantAmount;

    public EnchantmentMeta(String string) {
        this.overrideExistingEnchants = FishingItemManager.getFishingLootConfig().getBoolean(string + "OverrideExistingEnchants", false);
        String[] stringArray = FishingItemManager.getFishingLootConfig().getString(string + "EnchantmentAmountRange", "1").split("-");
        this.lowEndEnchantAmount = Integer.parseInt(stringArray[0]);
        int n = this.highEndEnchantAmount = stringArray.length > 1 ? Integer.parseInt(stringArray[1]) : this.lowEndEnchantAmount;
        if (FishingItemManager.getFishingLootConfig().contains(string + "Enchantments")) {
            for (String string2 : FishingItemManager.getFishingLootConfig().getStringList(string + "Enchantments")) {
                String[] stringArray2 = string2.split(":");
                Enchantment enchantment = Enchantment.getByName((String)stringArray2[0]);
                String[] stringArray3 = stringArray2[1].split("-");
                int n2 = Integer.parseInt(stringArray3[0]);
                int n3 = stringArray3.length > 1 ? Integer.parseInt(stringArray3[1]) : n2;
                double d = Double.parseDouble(stringArray2[2]);
                this.enchants.add(new FishingItemEnchant(enchantment, n2, n3, d));
            }
        }
    }

    public Map<Enchantment, Integer> generateEnchantmentMap() {
        int n;
        HashMap<Enchantment, Integer> hashMap = new HashMap<Enchantment, Integer>();
        Random random = new Random();
        for (FishingItemEnchant fishingItemEnchant : this.enchants) {
            int n2;
            int n3;
            if (!(fishingItemEnchant.getEnchantmentChance() >= (double)random.nextInt(100))) continue;
            n = 0;
            int n4 = 0;
            HashMap<Integer, Integer> hashMap2 = new HashMap<Integer, Integer>();
            for (n3 = fishingItemEnchant.getLowLevel(); n3 <= fishingItemEnchant.getHighLevel(); ++n3) {
                n2 = FishingItemManager.getFishingLootConfig().getInt("EnchantmentWeightScale." + Methods.convertToNumeral(n3), 0);
                n += n2;
                hashMap2.put(n3, n2);
            }
            n3 = random.nextInt(n);
            n2 = 0;
            for (int i = fishingItemEnchant.getLowLevel(); i <= fishingItemEnchant.getHighLevel(); ++i) {
                if (n3 > (n2 += ((Integer)hashMap2.get(i)).intValue())) continue;
                n4 = i;
                break;
            }
            if (hashMap.size() >= this.highEndEnchantAmount) {
                if (random.nextInt(1) != 1) continue;
                Enchantment enchantment = (Enchantment)hashMap.keySet().toArray()[random.nextInt(hashMap.size())];
                hashMap.remove(enchantment);
                hashMap.put(fishingItemEnchant.getEnchantmentType(), n4);
                continue;
            }
            hashMap.put(fishingItemEnchant.getEnchantmentType(), n4);
        }
        List list = (List)this.enchants.clone();
        if (hashMap.size() < this.lowEndEnchantAmount) {
            while (hashMap.size() < this.lowEndEnchantAmount && list.size() > 0) {
                FishingItemEnchant fishingItemEnchant;
                fishingItemEnchant = (FishingItemEnchant)list.get(random.nextInt(list.size()));
                if (!(fishingItemEnchant.getEnchantmentChance() >= (double)random.nextInt(100))) continue;
                n = fishingItemEnchant.getLowLevel() + random.nextInt(fishingItemEnchant.getHighLevel() - fishingItemEnchant.getLowLevel());
                hashMap.put(fishingItemEnchant.getEnchantmentType(), n);
                list.remove(fishingItemEnchant);
            }
        }
        return hashMap;
    }

    public ArrayList<FishingItemEnchant> getEnchants() {
        return this.enchants;
    }

    public boolean isOverrideExistingEnchants() {
        return this.overrideExistingEnchants;
    }

    public int getLowEndEnchantAmount() {
        return this.lowEndEnchantAmount;
    }

    public int getHighEndEnchantAmount() {
        return this.highEndEnchantAmount;
    }
}

