/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.api.util.exp;

import java.util.HashMap;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import us.eunoians.mcrpg.McRPG;
import us.eunoians.mcrpg.api.util.FileManager;
import us.eunoians.mcrpg.api.util.exp.ExpPerm;
import us.eunoians.mcrpg.skills.Skill;
import us.eunoians.mcrpg.types.Skills;

public class ExpPermissionManager {
    private static ExpPermissionManager instance = new ExpPermissionManager();
    private McRPG p;
    private HashMap<String, ExpPerm> permissions = new HashMap();

    public void reload() {
        this.permissions.clear();
        this.setup(this.p);
    }

    public ExpPermissionManager setup(McRPG mcRPG) {
        this.p = mcRPG;
        FileConfiguration fileConfiguration = mcRPG.getFileManager().getFile(FileManager.Files.EXP_PERM_FILE);
        for (String string : fileConfiguration.getConfigurationSection("").getKeys(false)) {
            Object object2;
            String string2 = fileConfiguration.getString(string + ".Perm");
            HashMap<Skills, Double> hashMap = new HashMap<Skills, Double>();
            for (Object object2 : fileConfiguration.getConfigurationSection(string + ".AffectedSkills").getKeys(false)) {
                Skills skills = Skills.fromString((String)object2);
                double d = fileConfiguration.getDouble(string + ".AffectedSkills." + (String)object2);
                hashMap.put(skills, d);
            }
            int n = fileConfiguration.getInt(string + ".Priority");
            object2 = new ExpPerm(string2, hashMap, n);
            this.permissions.put(string2, (ExpPerm)object2);
        }
        return this;
    }

    public double getPermBoost(Player player, Skill skill) {
        ExpPerm expPerm = null;
        for (String string : this.permissions.keySet()) {
            if (!player.hasPermission(string)) continue;
            if (expPerm != null) {
                if (expPerm.getPriority() >= this.permissions.get(string).getPriority() || !this.permissions.get(string).getExpValues().containsKey((Object)skill.getType())) continue;
                expPerm = this.permissions.get(string);
                continue;
            }
            expPerm = this.permissions.get(string);
        }
        if (expPerm == null) {
            return 1.0;
        }
        if (expPerm.getExpValues().containsKey((Object)skill.getType())) {
            return expPerm.getExpValues().get((Object)skill.getType());
        }
        return 1.0;
    }

    public static ExpPermissionManager getInstance() {
        return instance;
    }

    public HashMap<String, ExpPerm> getPermissions() {
        return this.permissions;
    }
}

