/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.api.util.brewing.standmeta;

import org.bukkit.Material;
import org.bukkit.block.BrewingStand;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.ItemStack;
import us.eunoians.mcrpg.McRPG;
import us.eunoians.mcrpg.api.util.Methods;
import us.eunoians.mcrpg.api.util.brewing.standmeta.BrewingGUI;

public class BrewingStandWrapper {
    private FileConfiguration fileConfiguration;
    private BrewingGUI brewingGUI;
    private BrewingStand brewingStand;

    public BrewingStandWrapper(BrewingStand brewingStand, FileConfiguration fileConfiguration) {
        this.brewingGUI = new BrewingGUI(brewingStand, fileConfiguration);
        this.fileConfiguration = fileConfiguration;
        this.brewingStand = brewingStand;
    }

    public void saveToFile() {
        String string = "BrewingStands." + Methods.locToString(this.brewingStand.getLocation()) + ".";
        this.fileConfiguration.set(string + "CurrentFuelLevel", (Object)this.brewingGUI.getCurrentFuelLevel());
        this.fileConfiguration.set(string + "MaxFuelLevel", (Object)this.brewingGUI.getMaxCurrentFuelLevel());
        if (this.brewingGUI.getFuel() == null || this.brewingGUI.getFuel().getType() == Material.AIR || this.brewingGUI.getFuel().getType() == Material.LIGHT_BLUE_STAINED_GLASS_PANE) {
            this.fileConfiguration.set(string + "FuelItem", null);
        } else {
            this.fileConfiguration.set(string + "FuelItem", (Object)this.brewingGUI.getFuel());
        }
        for (int i = 0; i < this.brewingGUI.getSpecialRewards().size(); ++i) {
            ItemStack itemStack = this.brewingGUI.getSpecialRewards().get(i);
            this.fileConfiguration.set(string + "BonusItems." + i, (Object)itemStack);
        }
        McRPG.getInstance().getBrewingStandManager().save(this.brewingStand.getChunk());
    }

    public void finishBrew() {
        if (this.brewingGUI.getBrewTask() != null) {
            this.brewingGUI.cancelBrewTask();
            this.brewingGUI.finishBrewTask();
        }
    }

    public void deleteData() {
        if (this.brewingGUI.getBrewTask() != null) {
            this.brewingGUI.cancelBrewTask();
        }
        this.brewingGUI.breakGUI();
        String string = "BrewingStands." + Methods.locToString(this.brewingStand.getLocation());
        this.fileConfiguration.set(string, null);
        McRPG.getInstance().getBrewingStandManager().save(this.brewingStand.getChunk());
    }

    public BrewingGUI getBrewingGUI() {
        return this.brewingGUI;
    }

    public BrewingStand getBrewingStand() {
        return this.brewingStand;
    }
}

