/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.api.util.brewing.standmeta;

import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.block.BrewingStand;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.BrewEvent;
import org.bukkit.inventory.BrewerInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffectTypeWrapper;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import us.eunoians.mcrpg.McRPG;
import us.eunoians.mcrpg.abilities.sorcery.CircesRecipes;
import us.eunoians.mcrpg.abilities.sorcery.HastyBrew;
import us.eunoians.mcrpg.abilities.sorcery.ManaAffinity;
import us.eunoians.mcrpg.api.events.mcrpg.sorcery.HastyBrewEvent;
import us.eunoians.mcrpg.api.events.mcrpg.sorcery.ManaAffinityEvent;
import us.eunoians.mcrpg.api.exceptions.McRPGPlayerNotFoundException;
import us.eunoians.mcrpg.api.util.FileManager;
import us.eunoians.mcrpg.api.util.Methods;
import us.eunoians.mcrpg.api.util.artifacts.ArtifactFactory;
import us.eunoians.mcrpg.api.util.artifacts.ArtifactManager;
import us.eunoians.mcrpg.api.util.books.BookManager;
import us.eunoians.mcrpg.api.util.books.SkillBookFactory;
import us.eunoians.mcrpg.api.util.brewing.BasePotion;
import us.eunoians.mcrpg.api.util.brewing.BrewingStandManager;
import us.eunoians.mcrpg.api.util.brewing.PotionEffectTagWrapper;
import us.eunoians.mcrpg.api.util.brewing.PotionFactory;
import us.eunoians.mcrpg.api.util.brewing.PotionRecipeManager;
import us.eunoians.mcrpg.api.util.brewing.TagMeta;
import us.eunoians.mcrpg.api.util.brewing.standmeta.BrewingStandWrapper;
import us.eunoians.mcrpg.gui.GUI;
import us.eunoians.mcrpg.gui.GUIBuilder;
import us.eunoians.mcrpg.nbtapi.NBTItem;
import us.eunoians.mcrpg.players.McRPGPlayer;
import us.eunoians.mcrpg.players.PlayerManager;
import us.eunoians.mcrpg.types.BasePotionType;
import us.eunoians.mcrpg.types.DefaultAbilities;
import us.eunoians.mcrpg.types.GainReason;
import us.eunoians.mcrpg.types.Skills;
import us.eunoians.mcrpg.types.UnlockedAbilities;
import us.eunoians.mcrpg.util.Parser;

public class BrewingGUI
extends GUI {
    private ItemStack fuel;
    private BrewingStand holder;
    private ItemStack ingredient;
    private int currentFuelLevel;
    private int maxCurrentFuelLevel = 0;
    private double currentBrewProgress;
    private double potionBrewDuration = 10.0;
    private BukkitTask brewTask;
    private Inventory inv;
    private ItemStack[] specialRewards = new ItemStack[4];
    private BasePotion[] potionItems = new BasePotion[3];
    private final int VANILLA_FUEL_SLOT = 4;
    private final int VANILLA_INGREDIENT_SLOT = 3;
    private final int VANILLA_POTION_SLOT_1 = 0;
    private final int VANILLA_POTION_SLOT_2 = 1;
    private final int VANILLA_POTION_SLOT_3 = 2;
    private final int MCRPG_POTION_SLOT_1 = 38;
    private final int MCRPG_POTION_SLOT_2 = 40;
    private final int MCRPG_POTION_SLOT_3 = 42;
    private final int MCRPG_INGREDIENT_SLOT = 13;
    private final int MCRPG_SPECIAL_ITEM_SLOT_1 = 46;
    private final int MCRPG_SPECIAL_ITEM_SLOT_2 = 48;
    private final int MCRPG_SPECIAL_ITEM_SLOT_3 = 50;
    private final int MCRPG_SPECIAL_ITEM_SLOT_4 = 52;
    private OfflinePlayer lastInteractedPlayer;
    private OfflinePlayer playerStartingBrew;

    public BrewingGUI(BrewingStand brewingStand, FileConfiguration fileConfiguration) {
        super(new GUIBuilder());
        BasePotion basePotion;
        ItemMeta itemMeta;
        this.holder = brewingStand;
        String string = "BrewingStands." + Methods.locToString(brewingStand.getLocation()) + ".";
        FileConfiguration fileConfiguration2 = McRPG.getInstance().getFileManager().getFile(FileManager.Files.BREWING_GUI);
        FileConfiguration fileConfiguration3 = McRPG.getInstance().getFileManager().getFile(FileManager.Files.BREWING_ITEMS_CONFIG);
        this.potionBrewDuration = fileConfiguration3.getDouble("Potions.PotionBrewDuration", 10.0);
        this.inv = Bukkit.createInventory(null, (int)54, (String)Methods.color(fileConfiguration2.getString("Title")));
        BrewerInventory brewerInventory = brewingStand.getInventory();
        if (!(brewerInventory.getFuel() != null && brewerInventory.getFuel().getType() != Material.AIR || fileConfiguration.contains(string + "FuelItem"))) {
            this.fuel = new ItemStack(Material.LIGHT_BLUE_STAINED_GLASS_PANE);
            itemMeta = this.fuel.getItemMeta();
            itemMeta.setDisplayName(Methods.color(fileConfiguration2.getString("FuelPlaceholder.DisplayName")));
            itemMeta.setLore(Methods.colorLore(fileConfiguration2.getStringList("FuelPlaceholder.Lore")));
            this.fuel.setItemMeta(itemMeta);
            this.inv.setItem(0, this.fuel);
        } else {
            this.fuel = fileConfiguration.contains(string + "FuelItem") ? fileConfiguration.getItemStack(string + "FuelItem") : brewerInventory.getFuel();
            this.inv.setItem(0, this.fuel);
        }
        this.currentFuelLevel = fileConfiguration.getInt(string + "CurrentFuelLevel", 0);
        this.maxCurrentFuelLevel = fileConfiguration.getInt(string + "MaxFuelLevel", 0);
        brewingStand.setFuelLevel(0);
        brewingStand.getSnapshotInventory().setItem(4, new ItemStack(Material.AIR));
        this.initFuelItems();
        this.updateFuelItems();
        if (brewerInventory.getIngredient() == null || brewerInventory.getIngredient().getType() == Material.AIR) {
            this.ingredient = new ItemStack(Material.LIGHT_BLUE_STAINED_GLASS_PANE);
            itemMeta = this.ingredient.getItemMeta();
            itemMeta.setDisplayName(Methods.color(fileConfiguration2.getString("IngredientPlaceholder.DisplayName")));
            itemMeta.setLore(Methods.colorLore(fileConfiguration2.getStringList("IngredientPlaceholder.Lore")));
            this.ingredient.setItemMeta(itemMeta);
            this.inv.setItem(13, this.ingredient);
        } else {
            this.ingredient = brewerInventory.getIngredient();
            this.inv.setItem(13, this.ingredient);
        }
        itemMeta = new ItemStack(Material.WHITE_STAINED_GLASS_PANE);
        ItemMeta itemMeta2 = itemMeta.getItemMeta();
        itemMeta2.setDisplayName(" ");
        itemMeta.setItemMeta(itemMeta2);
        this.inv.setItem(21, (ItemStack)itemMeta);
        this.inv.setItem(22, (ItemStack)itemMeta);
        this.inv.setItem(23, (ItemStack)itemMeta);
        this.inv.setItem(29, (ItemStack)itemMeta);
        this.inv.setItem(31, (ItemStack)itemMeta);
        this.inv.setItem(33, (ItemStack)itemMeta);
        ItemStack itemStack = new ItemStack(Material.LIGHT_BLUE_STAINED_GLASS_PANE);
        ItemMeta itemMeta3 = itemStack.getItemMeta();
        itemMeta3.setDisplayName(Methods.color(fileConfiguration2.getString("PotionPlaceholder.DisplayName")));
        itemMeta3.setLore(Methods.colorLore(fileConfiguration2.getStringList("PotionPlaceholder.Lore")));
        itemStack.setItemMeta(itemMeta3);
        if (brewerInventory.getItem(0) == null || brewerInventory.getItem(0).getType() == Material.AIR || !brewerInventory.getItem(0).getType().name().contains("Potion")) {
            this.inv.setItem(38, itemStack);
        } else {
            basePotion = PotionFactory.convertItemStackToBasePotion(brewerInventory.getItem(0));
            this.inv.setItem(38, basePotion.getAsItem());
            brewerInventory.setItem(0, basePotion.getAsItem());
            this.potionItems[0] = basePotion;
        }
        if (brewerInventory.getItem(1) == null || brewerInventory.getItem(1).getType() == Material.AIR || !brewerInventory.getItem(1).getType().name().contains("Potion")) {
            this.inv.setItem(40, itemStack);
        } else {
            basePotion = PotionFactory.convertItemStackToBasePotion(brewerInventory.getItem(1));
            this.inv.setItem(40, basePotion.getAsItem());
            brewerInventory.setItem(1, basePotion.getAsItem());
            this.potionItems[1] = basePotion;
        }
        if (brewerInventory.getItem(2) == null || brewerInventory.getItem(2).getType() == Material.AIR || !brewerInventory.getItem(2).getType().name().contains("Potion")) {
            this.inv.setItem(42, itemStack);
        } else {
            basePotion = PotionFactory.convertItemStackToBasePotion(brewerInventory.getItem(2));
            this.inv.setItem(42, basePotion.getAsItem());
            brewerInventory.setItem(2, basePotion.getAsItem());
            this.potionItems[2] = basePotion;
        }
        this.initProgressBar();
        basePotion = new ItemStack(Material.PURPLE_STAINED_GLASS_PANE);
        ItemMeta itemMeta4 = basePotion.getItemMeta();
        itemMeta4.setDisplayName(Methods.color(fileConfiguration2.getString("SpecialItemPlaceholder.DisplayName")));
        itemMeta4.setLore(Methods.colorLore(fileConfiguration2.getStringList("SpecialItemPlaceholder.Lore")));
        basePotion.setItemMeta(itemMeta4);
        for (int i = 0; i < 4; ++i) {
            int n = 46 + i * 2;
            ItemStack itemStack2 = null;
            if (fileConfiguration.contains(string + "BonusItems." + i)) {
                this.specialRewards[i] = fileConfiguration.getItemStack(string + "BonusItems." + i);
                itemStack2 = this.specialRewards[i];
            }
            this.inv.setItem(n, (ItemStack)(itemStack2 == null ? basePotion : itemStack2));
        }
        if (!fileConfiguration2.getBoolean("RemoveFillerGlass", false)) {
            ItemStack itemStack3 = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
            ItemMeta itemMeta5 = itemStack3.getItemMeta();
            itemMeta5.setDisplayName(" ");
            itemStack3.setItemMeta(itemMeta5);
            for (int i = 0; i < this.inv.getSize(); ++i) {
                if (this.inv.getItem(i) != null && this.inv.getItem(i).getType() != Material.AIR) continue;
                this.inv.setItem(i, itemStack3);
            }
        }
        this.getGui().setNewInventory(this.inv);
    }

    public List<ItemStack> getSpecialRewards() {
        return Arrays.asList(this.specialRewards);
    }

    public List<BasePotion> getPotionItems() {
        return Arrays.asList(this.potionItems);
    }

    public void breakGUI() {
        for (ItemStack[] itemStackArray : this.inv.getViewers()) {
            itemStackArray.closeInventory();
        }
        Location location = this.holder.getLocation();
        if (this.holder.getInventory().getIngredient() != null && this.holder.getInventory().getIngredient().getType() == Material.LIGHT_BLUE_STAINED_GLASS_PANE) {
            this.updateHolder();
            this.holder.getInventory().setIngredient(new ItemStack(Material.AIR));
            this.holder.update();
        }
        if (this.fuel != null && this.fuel.getType() != Material.AIR && this.fuel.getType() != Material.LIGHT_BLUE_STAINED_GLASS_PANE) {
            location.getWorld().dropItemNaturally(location, this.fuel);
        }
        for (ItemStack itemStack : this.specialRewards) {
            if (itemStack == null) continue;
            location.getWorld().dropItemNaturally(location, itemStack);
        }
    }

    private void initFuelItems() {
        for (int i = 5; i >= 1; --i) {
            ItemStack itemStack = new ItemStack(Material.RED_STAINED_GLASS_PANE);
            ItemMeta itemMeta = itemStack.getItemMeta();
            double d = (double)this.currentFuelLevel / (double)this.maxCurrentFuelLevel != 0.0 ? (double)this.maxCurrentFuelLevel : 1.0;
            DecimalFormat decimalFormat = new DecimalFormat();
            decimalFormat.setMinimumFractionDigits(2);
            decimalFormat.setMaximumFractionDigits(2);
            itemMeta.setDisplayName(Methods.color("&c" + decimalFormat.format(d) + "%"));
            itemStack.setItemMeta(itemMeta);
            this.inv.setItem(i * 9, itemStack);
        }
    }

    public void updateFuelItems() {
        this.updateHolder();
        this.inv.setItem(0, this.fuel);
        if (this.currentFuelLevel == 0 && this.fuel.getType() != Material.LIGHT_BLUE_STAINED_GLASS_PANE) {
            this.maxCurrentFuelLevel = this.currentFuelLevel = McRPG.getInstance().getPotionRecipeManager().getFuelAmount(this.fuel);
            if (this.fuel.getAmount() == 1) {
                FileConfiguration fileConfiguration = McRPG.getInstance().getFileManager().getFile(FileManager.Files.BREWING_GUI);
                this.fuel = new ItemStack(Material.LIGHT_BLUE_STAINED_GLASS_PANE);
                ItemMeta itemMeta = this.fuel.getItemMeta();
                itemMeta.setDisplayName(Methods.color(fileConfiguration.getString("FuelPlaceholder.DisplayName")));
                itemMeta.setLore(Methods.colorLore(fileConfiguration.getStringList("FuelPlaceholder.Lore")));
                this.fuel.setItemMeta(itemMeta);
                this.inv.setItem(0, this.fuel);
            } else {
                this.fuel.setAmount(this.fuel.getAmount() - 1);
                this.maxCurrentFuelLevel = this.currentFuelLevel = McRPG.getInstance().getPotionRecipeManager().getFuelAmount(this.fuel);
                this.inv.setItem(0, this.fuel);
            }
        }
        double d = 20 * this.currentFuelLevel;
        int n = (int)(d / (double)(this.maxCurrentFuelLevel != 0 ? this.maxCurrentFuelLevel : 1));
        int n2 = d != 0.0 ? n : 0;
        double d2 = 100.0 * ((double)this.currentFuelLevel / (double)(this.maxCurrentFuelLevel != 0 ? this.maxCurrentFuelLevel : 1));
        for (int i = 5; i >= 1; --i) {
            int n3;
            if (n2 >= 4) {
                n3 = 4;
                n2 -= 4;
            } else {
                n3 = n2;
                n2 = 0;
            }
            ItemStack itemStack = this.inv.getItem(i * 9);
            itemStack.setType(this.getFuelGlass(n3));
            ItemMeta itemMeta = itemStack.getItemMeta();
            DecimalFormat decimalFormat = new DecimalFormat();
            decimalFormat.setMinimumFractionDigits(2);
            decimalFormat.setMaximumFractionDigits(2);
            itemMeta.setDisplayName(Methods.color(this.getFuelGlassColour(n3) + decimalFormat.format(d2) + "%"));
            itemStack.setItemMeta(itemMeta);
            this.inv.setItem(i * 9, itemStack);
        }
        this.save();
        for (HumanEntity humanEntity : this.inv.getViewers()) {
            ((Player)humanEntity).updateInventory();
        }
    }

    public void resetFuelGlass() {
        FileConfiguration fileConfiguration = McRPG.getInstance().getFileManager().getFile(FileManager.Files.BREWING_GUI);
        this.fuel = new ItemStack(Material.LIGHT_BLUE_STAINED_GLASS_PANE);
        ItemMeta itemMeta = this.fuel.getItemMeta();
        itemMeta.setDisplayName(Methods.color(fileConfiguration.getString("FuelPlaceholder.DisplayName")));
        itemMeta.setLore(Methods.colorLore(fileConfiguration.getStringList("FuelPlaceholder.Lore")));
        this.fuel.setItemMeta(itemMeta);
        this.inv.setItem(0, this.fuel);
        for (HumanEntity humanEntity : this.inv.getViewers()) {
            ((Player)humanEntity).updateInventory();
        }
    }

    public void resetIngredientGlass() {
        this.updateHolder();
        FileConfiguration fileConfiguration = McRPG.getInstance().getFileManager().getFile(FileManager.Files.BREWING_GUI);
        this.ingredient = new ItemStack(Material.LIGHT_BLUE_STAINED_GLASS_PANE);
        ItemMeta itemMeta = this.ingredient.getItemMeta();
        itemMeta.setDisplayName(Methods.color(fileConfiguration.getString("IngredientPlaceholder.DisplayName")));
        itemMeta.setLore(Methods.colorLore(fileConfiguration.getStringList("IngredientPlaceholder.Lore")));
        this.ingredient.setItemMeta(itemMeta);
        this.inv.setItem(13, this.ingredient);
        this.holder.getSnapshotInventory().setItem(3, new ItemStack(Material.AIR));
        this.holder.update(true, true);
        this.cancelBrewTask();
        for (HumanEntity humanEntity : this.inv.getViewers()) {
            ((Player)humanEntity).updateInventory();
        }
    }

    public void resetSpecialItemGlass() {
        FileConfiguration fileConfiguration = McRPG.getInstance().getFileManager().getFile(FileManager.Files.BREWING_GUI);
        ItemStack itemStack = new ItemStack(Material.PURPLE_STAINED_GLASS_PANE);
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setDisplayName(Methods.color(fileConfiguration.getString("SpecialItemPlaceholder.DisplayName")));
        itemMeta.setLore(Methods.colorLore(fileConfiguration.getStringList("SpecialItemPlaceholder.Lore")));
        itemStack.setItemMeta(itemMeta);
        for (int i = 0; i < 4; ++i) {
            int n = 46 + i * 2;
            this.inv.setItem(n, this.specialRewards[i] == null ? itemStack : this.specialRewards[i]);
        }
    }

    public void resetPotionGlass() {
        FileConfiguration fileConfiguration = McRPG.getInstance().getFileManager().getFile(FileManager.Files.BREWING_GUI);
        ItemStack itemStack = new ItemStack(Material.LIGHT_BLUE_STAINED_GLASS_PANE);
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setDisplayName(Methods.color(fileConfiguration.getString("PotionPlaceholder.DisplayName")));
        itemMeta.setLore(Methods.colorLore(fileConfiguration.getStringList("PotionPlaceholder.Lore")));
        itemStack.setItemMeta(itemMeta);
        if (this.potionItems[0] == null) {
            this.inv.setItem(38, itemStack);
        }
        if (this.potionItems[1] == null) {
            this.inv.setItem(40, itemStack);
        }
        if (this.potionItems[2] == null) {
            this.inv.setItem(42, itemStack);
        }
        for (HumanEntity humanEntity : this.inv.getViewers()) {
            ((Player)humanEntity).updateInventory();
        }
    }

    public int getFirstEmptySlot() {
        return this.potionItems[0] == null ? 38 : (this.potionItems[1] == null ? 40 : (this.potionItems[2] == null ? 42 : -1));
    }

    public boolean isPotionSlot(int n) {
        return n == 38 || n == 40 || n == 42;
    }

    public boolean isSpecialItemSlot(int n) {
        return n == 46 || n == 48 || n == 50 || n == 52;
    }

    public ItemStack getSpecialItem(int n) {
        if (n == 46) {
            return this.specialRewards[0];
        }
        if (n == 48) {
            return this.specialRewards[1];
        }
        if (n == 50) {
            return this.specialRewards[2];
        }
        if (n == 52) {
            return this.specialRewards[3];
        }
        return null;
    }

    public boolean hasSpecialItem() {
        for (ItemStack itemStack : this.specialRewards) {
            if (itemStack == null) continue;
            return true;
        }
        return false;
    }

    public boolean specialItemSlotsFull() {
        for (ItemStack itemStack : this.specialRewards) {
            if (itemStack != null) continue;
            return false;
        }
        return true;
    }

    public int getFirstEmptySpecialItemSlot() {
        if (this.specialRewards[0] == null) {
            return 46;
        }
        if (this.specialRewards[1] == null) {
            return 48;
        }
        if (this.specialRewards[2] == null) {
            return 50;
        }
        if (this.specialRewards[3] == null) {
            return 52;
        }
        return 0;
    }

    public void updateIngredient() {
        this.updateHolder();
        if (this.ingredient.getType() != Material.LIGHT_BLUE_STAINED_GLASS_PANE) {
            this.holder.getSnapshotInventory().setIngredient(this.ingredient);
            this.holder.update();
        }
        this.inv.setItem(13, this.ingredient);
    }

    public void setPotion(ItemStack itemStack, int n) {
        this.updateHolder();
        BasePotion basePotion = PotionFactory.convertItemStackToBasePotion(itemStack);
        if (n == 38) {
            this.potionItems[0] = basePotion;
            this.inv.setItem(38, basePotion.getAsItem());
            this.holder.getSnapshotInventory().setItem(0, basePotion.getAsItem());
        } else if (n == 40) {
            this.potionItems[1] = basePotion;
            this.inv.setItem(40, basePotion.getAsItem());
            this.holder.getSnapshotInventory().setItem(1, basePotion.getAsItem());
        } else if (n == 42) {
            this.potionItems[2] = basePotion;
            this.inv.setItem(42, basePotion.getAsItem());
            this.holder.getSnapshotInventory().setItem(2, basePotion.getAsItem());
        }
        this.holder.update(true, true);
    }

    public void removeSpecialReward(int n) {
        if (n == 46) {
            this.specialRewards[0] = null;
        } else if (n == 48) {
            this.specialRewards[1] = null;
        } else if (n == 50) {
            this.specialRewards[2] = null;
        } else if (n == 52) {
            this.specialRewards[3] = null;
        }
        this.resetSpecialItemGlass();
        this.save();
    }

    public void removePotion(int n) {
        this.updateHolder();
        if (n == 38) {
            this.potionItems[0] = null;
            this.inv.setItem(38, null);
            this.holder.getSnapshotInventory().setItem(0, new ItemStack(Material.AIR));
        } else if (n == 40) {
            this.potionItems[1] = null;
            this.inv.setItem(40, null);
            this.holder.getSnapshotInventory().setItem(1, new ItemStack(Material.AIR));
        } else if (n == 42) {
            this.potionItems[2] = null;
            this.inv.setItem(42, null);
            this.holder.getSnapshotInventory().setItem(2, new ItemStack(Material.AIR));
        }
        this.holder.update(true, true);
        this.resetPotionGlass();
        for (BasePotion basePotion : this.potionItems) {
            if (basePotion == null) continue;
            return;
        }
        this.cancelBrewTask();
    }

    private void updateHolder() {
        this.holder = (BrewingStand)this.holder.getWorld().getBlockAt(this.holder.getLocation()).getState();
    }

    public ItemStack getPotion(int n) {
        return this.inv.getItem(n);
    }

    public boolean checkForBrewingTask() {
        return this.currentFuelLevel > 0 && this.isIngredientValid(this.ingredient) && this.brewTask == null;
    }

    public BukkitTask startBrewTask() {
        BukkitTask bukkitTask;
        this.updateHolder();
        final double d = this.getBrewDuration() / 24.0;
        final BrewingGUI brewingGUI = this;
        this.brewTask = bukkitTask = new BukkitRunnable(){

            public void run() {
                if (BrewingGUI.this.currentBrewProgress >= BrewingGUI.this.getBrewDuration()) {
                    this.cancel();
                    BrewingGUI.this.finishBrewTask();
                    return;
                }
                brewingGUI.setCurrentBrewProgress(brewingGUI.getCurrentBrewProgress() + d);
                BrewingGUI.this.updateProgressBar();
            }
        }.runTaskTimer((Plugin)McRPG.getInstance(), (long)(d * 20.0), (long)(d * 20.0));
        return bukkitTask;
    }

    public void cancelBrewTask() {
        if (this.brewTask != null) {
            this.brewTask.cancel();
        }
        this.brewTask = null;
        this.currentBrewProgress = 0.0;
        this.initProgressBar();
    }

    public void finishBrewTask() {
        this.updateHolder();
        Chunk chunk = this.holder.getChunk();
        boolean bl = false;
        PotionRecipeManager potionRecipeManager = McRPG.getInstance().getPotionRecipeManager();
        BrewerInventory brewerInventory = this.holder.getSnapshotInventory();
        if (!chunk.isLoaded()) {
            // empty if block
        }
        BrewEvent brewEvent = new BrewEvent(this.holder.getBlock(), brewerInventory, this.currentFuelLevel);
        Bukkit.getPluginManager().callEvent((Event)brewEvent);
        if (!brewEvent.isCancelled()) {
            Object object;
            Object object2;
            FileConfiguration fileConfiguration = McRPG.getInstance().getFileManager().getFile(FileManager.Files.SOUNDS_FILE);
            this.holder.getLocation().getWorld().playSound(this.holder.getLocation(), Sound.valueOf((String)fileConfiguration.getString("Sounds.Brewing.FinishBrewSound.Sound")), (float)fileConfiguration.getInt("Sounds.Brewing.FinishBrewSound.Volume"), (float)fileConfiguration.getInt("Sounds.Brewing.FinishBrewSound.Pitch"));
            int n = 0;
            FileConfiguration fileConfiguration2 = McRPG.getInstance().getFileManager().getFile(FileManager.Files.SORCERY_CONFIG);
            String string = "ExpAwardedPerBrewAmount.";
            for (int i = 0; i < this.potionItems.length; ++i) {
                object2 = this.potionItems[i];
                if (object2 == null) continue;
                object = potionRecipeManager.getPotionEffectTagWrapper(((BasePotion)object2).getBasePotionType());
                if (((BasePotion)object2).getAsItem().getType() == Material.POTION && this.ingredient.getType() == Material.GUNPOWDER && ((PotionEffectTagWrapper)object).isCanBeSplash()) {
                    int n2 = ((BasePotion)object2).getTotalTimesModified();
                    ((BasePotion)object2).setSplash();
                    int n3 = ((BasePotion)object2).getTotalTimesModified();
                    if (n2 != n3) {
                        n += fileConfiguration2.getInt(string + n3);
                    }
                    this.potionItems[i] = object2;
                    continue;
                }
                if (((BasePotion)object2).getAsItem().getType() == Material.SPLASH_POTION && this.ingredient.getType() == Material.DRAGON_BREATH && ((PotionEffectTagWrapper)object).isCanBeLingering()) {
                    int n4 = ((BasePotion)object2).getTotalTimesModified();
                    ((BasePotion)object2).setLingering();
                    int n5 = ((BasePotion)object2).getTotalTimesModified();
                    if (n4 != n5) {
                        n += fileConfiguration2.getInt(string + n5);
                    }
                    this.potionItems[i] = object2;
                    continue;
                }
                TagMeta tagMeta = ((PotionEffectTagWrapper)object).getTagMeta(((BasePotion)object2).getTag());
                String string2 = ((PotionEffectTagWrapper)object).getTagMeta(((BasePotion)object2).getTag()).getChildTag(this.ingredient.getType());
                if (string2 == null) continue;
                String[] stringArray = string2.split("\\.");
                if (stringArray.length > 1) {
                    BasePotionType basePotionType = stringArray[0].equals("AWKWARD") ? BasePotionType.AWKWARD : BasePotionType.getFromPotionEffect(PotionEffectTypeWrapper.getByName((String)stringArray[0]));
                    ((BasePotion)object2).setBasePotionType(basePotionType);
                    string2 = stringArray[1];
                }
                ((BasePotion)object2).setTag(string2);
                int n6 = ((BasePotion)object2).getTotalTimesModified();
                ((BasePotion)object2).updateInfo();
                int n7 = ((BasePotion)object2).getTotalTimesModified();
                if (n6 != n7) {
                    n += fileConfiguration2.getInt(string + n7);
                }
                this.potionItems[i] = object2;
            }
            if (this.lastInteractedPlayer != null && this.lastInteractedPlayer.isOnline()) {
                try {
                    McRPGPlayer mcRPGPlayer = PlayerManager.getPlayer(this.lastInteractedPlayer.getUniqueId());
                    mcRPGPlayer.giveExp(Skills.SORCERY, n, GainReason.BREW);
                }
                catch (McRPGPlayerNotFoundException mcRPGPlayerNotFoundException) {
                    mcRPGPlayerNotFoundException.printStackTrace();
                }
            }
            if (this.potionItems[0] != null) {
                brewerInventory.setItem(0, this.potionItems[0].getAsItem());
                this.inv.setItem(38, this.potionItems[0].getAsItem());
                this.holder.update(true, true);
            }
            if (this.potionItems[1] != null) {
                brewerInventory.setItem(1, this.potionItems[1].getAsItem());
                this.inv.setItem(40, this.potionItems[1].getAsItem());
                this.holder.update(true, true);
            }
            if (this.potionItems[2] != null) {
                brewerInventory.setItem(2, this.potionItems[2].getAsItem());
                this.inv.setItem(42, this.potionItems[2].getAsItem());
                this.holder.update(true, true);
            }
            --this.currentFuelLevel;
            if (this.lastInteractedPlayer != null && this.lastInteractedPlayer.isOnline()) {
                McRPGPlayer mcRPGPlayer = null;
                try {
                    mcRPGPlayer = PlayerManager.getPlayer(this.lastInteractedPlayer.getUniqueId());
                }
                catch (McRPGPlayerNotFoundException mcRPGPlayerNotFoundException) {
                    // empty catch block
                }
                if (mcRPGPlayer != null) {
                    ManaAffinityEvent manaAffinityEvent;
                    double d;
                    object2 = McRPG.getInstance().getBookManager();
                    object = McRPG.getInstance().getArtifactManager();
                    Random random = new Random();
                    if (!this.specialItemSlotsFull() && ((BookManager)object2).getEnabledUnlockEvents().contains("Brewing")) {
                        int n8;
                        int n9 = McRPG.getInstance().getFileManager().getFile(FileManager.Files.CONFIG).getBoolean("Configuration.DisableBooksInEnd", false) && this.holder.getLocation().getBlock().getBiome().name().contains("END") ? 100001 : random.nextInt(100000);
                        double d2 = ((BookManager)object2).getDefaultUnlockChance();
                        if (fileConfiguration2.getBoolean("SorceryEnabled") && UnlockedAbilities.MANA_AFFINITY.isEnabled() && mcRPGPlayer.doesPlayerHaveAbilityInLoadout(UnlockedAbilities.MANA_AFFINITY) && mcRPGPlayer.getBaseAbility(UnlockedAbilities.MANA_AFFINITY).isToggled()) {
                            ManaAffinity manaAffinity = (ManaAffinity)mcRPGPlayer.getBaseAbility(UnlockedAbilities.MANA_AFFINITY);
                            d = fileConfiguration2.getDouble("ManaAffinityConfig.Tier" + Methods.convertToNumeral(manaAffinity.getCurrentTier()) + ".DiscoveryChanceIncrease");
                            manaAffinityEvent = new ManaAffinityEvent(mcRPGPlayer, manaAffinity, d);
                            Bukkit.getPluginManager().callEvent((Event)manaAffinityEvent);
                            if (!manaAffinityEvent.isCancelled()) {
                                d2 += manaAffinityEvent.getDiscoveryChanceIncrease();
                            }
                        }
                        if ((d2 *= 1000.0) >= (double)n9 && (n8 = this.getFirstEmptySpecialItemSlot()) != 0) {
                            ItemStack itemStack = SkillBookFactory.generateUnlockBook();
                            if (n8 == 46) {
                                this.inv.setItem(46, itemStack);
                                this.specialRewards[0] = itemStack;
                            }
                            if (n8 == 48) {
                                this.inv.setItem(48, itemStack);
                                this.specialRewards[1] = itemStack;
                            }
                            if (n8 == 50) {
                                this.inv.setItem(50, itemStack);
                                this.specialRewards[2] = itemStack;
                            }
                            if (n8 == 52) {
                                this.inv.setItem(52, itemStack);
                                this.specialRewards[3] = itemStack;
                            }
                        }
                    }
                    if (!this.specialItemSlotsFull() && ((BookManager)object2).getEnabledUpgradeEvents().contains("Brewing")) {
                        int n10;
                        int n11 = McRPG.getInstance().getFileManager().getFile(FileManager.Files.CONFIG).getBoolean("Configuration.DisableBooksInEnd", false) && this.holder.getLocation().getBlock().getBiome().name().contains("END") ? 100001 : random.nextInt(100000);
                        double d3 = ((BookManager)object2).getDefaultUpgradeChance();
                        if (fileConfiguration2.getBoolean("SorceryEnabled") && UnlockedAbilities.MANA_AFFINITY.isEnabled() && mcRPGPlayer.doesPlayerHaveAbilityInLoadout(UnlockedAbilities.MANA_AFFINITY) && mcRPGPlayer.getBaseAbility(UnlockedAbilities.MANA_AFFINITY).isToggled()) {
                            ManaAffinity manaAffinity = (ManaAffinity)mcRPGPlayer.getBaseAbility(UnlockedAbilities.MANA_AFFINITY);
                            d = fileConfiguration2.getDouble("ManaAffinityConfig.Tier" + Methods.convertToNumeral(manaAffinity.getCurrentTier()) + ".DiscoveryChanceIncrease");
                            manaAffinityEvent = new ManaAffinityEvent(mcRPGPlayer, manaAffinity, d);
                            Bukkit.getPluginManager().callEvent((Event)manaAffinityEvent);
                            if (!manaAffinityEvent.isCancelled()) {
                                d3 += manaAffinityEvent.getDiscoveryChanceIncrease();
                            }
                        }
                        if ((d3 *= 1000.0) >= (double)n11 && (n10 = this.getFirstEmptySpecialItemSlot()) != 0) {
                            ItemStack itemStack = SkillBookFactory.generateUpgradeBook();
                            if (n10 == 46) {
                                this.inv.setItem(46, itemStack);
                                this.specialRewards[0] = itemStack;
                            }
                            if (n10 == 48) {
                                this.inv.setItem(48, itemStack);
                                this.specialRewards[1] = itemStack;
                            }
                            if (n10 == 50) {
                                this.inv.setItem(50, itemStack);
                                this.specialRewards[2] = itemStack;
                            }
                            if (n10 == 52) {
                                this.inv.setItem(52, itemStack);
                                this.specialRewards[3] = itemStack;
                            }
                        }
                    }
                    if (!this.specialItemSlotsFull()) {
                        int n12;
                        double d4 = ((ArtifactManager)object).getArtifactTypeChance("BrewingArtifacts");
                        if (fileConfiguration2.getBoolean("SorceryEnabled") && UnlockedAbilities.MANA_AFFINITY.isEnabled() && mcRPGPlayer.doesPlayerHaveAbilityInLoadout(UnlockedAbilities.MANA_AFFINITY) && mcRPGPlayer.getBaseAbility(UnlockedAbilities.MANA_AFFINITY).isToggled()) {
                            ManaAffinity manaAffinity = (ManaAffinity)mcRPGPlayer.getBaseAbility(UnlockedAbilities.MANA_AFFINITY);
                            double d5 = fileConfiguration2.getDouble("ManaAffinityConfig.Tier" + Methods.convertToNumeral(manaAffinity.getCurrentTier()) + ".DiscoveryChanceIncrease");
                            ManaAffinityEvent manaAffinityEvent2 = new ManaAffinityEvent(mcRPGPlayer, manaAffinity, d5);
                            Bukkit.getPluginManager().callEvent((Event)manaAffinityEvent2);
                            if (!manaAffinityEvent2.isCancelled()) {
                                d4 += manaAffinityEvent2.getDiscoveryChanceIncrease();
                            }
                        }
                        if ((d4 *= 1000.0) >= (double)random.nextInt(100000) && (n12 = this.getFirstEmptySpecialItemSlot()) != 0) {
                            ItemStack itemStack = ArtifactFactory.generateArtifact("BrewingArtifacts");
                            NBTItem nBTItem = new NBTItem(itemStack);
                            if (n12 == 46) {
                                this.inv.setItem(46, itemStack);
                                this.specialRewards[0] = itemStack;
                            }
                            if (n12 == 48) {
                                this.inv.setItem(48, itemStack);
                                this.specialRewards[1] = itemStack;
                            }
                            if (n12 == 50) {
                                this.inv.setItem(50, itemStack);
                                this.specialRewards[2] = itemStack;
                            }
                            if (n12 == 52) {
                                this.inv.setItem(52, itemStack);
                                this.specialRewards[3] = itemStack;
                            }
                        }
                    }
                }
            }
        }
        if (this.ingredient.getAmount() == 1) {
            this.resetIngredientGlass();
        } else {
            this.ingredient.setAmount(this.ingredient.getAmount() - 1);
        }
        this.updateFuelItems();
        this.updateIngredient();
        this.currentBrewProgress = 0.0;
        this.initProgressBar();
        this.brewTask = null;
        for (HumanEntity humanEntity : this.inv.getViewers()) {
            ((Player)humanEntity).updateInventory();
        }
    }

    private boolean isIngredientValid(ItemStack itemStack) {
        Material material = itemStack.getType();
        PotionRecipeManager potionRecipeManager = McRPG.getInstance().getPotionRecipeManager();
        for (BasePotion basePotion : this.potionItems) {
            if (basePotion == null) continue;
            PotionEffectTagWrapper potionEffectTagWrapper = potionRecipeManager.getPotionEffectTagWrapper(basePotion.getBasePotionType());
            if (basePotion.getAsItem().getType() == Material.POTION && itemStack.getType() == Material.GUNPOWDER && potionEffectTagWrapper.isCanBeSplash()) {
                return true;
            }
            if (basePotion.getAsItem().getType() == Material.SPLASH_POTION && itemStack.getType() == Material.DRAGON_BREATH && potionEffectTagWrapper.isCanBeLingering()) {
                return true;
            }
            if (!potionRecipeManager.doesMaterialLeadToChild(material, basePotion)) continue;
            BasePotionType basePotionType = potionRecipeManager.getChildPotionType(material, basePotion);
            if (potionRecipeManager.isLockedRecipe(basePotionType)) {
                if (this.lastInteractedPlayer == null || !this.lastInteractedPlayer.isOnline()) continue;
                try {
                    FileConfiguration fileConfiguration = McRPG.getInstance().getFileManager().getFile(FileManager.Files.SORCERY_CONFIG);
                    McRPGPlayer mcRPGPlayer = PlayerManager.getPlayer(this.lastInteractedPlayer.getUniqueId());
                    if (fileConfiguration.getBoolean("SorceryEnabled") && UnlockedAbilities.CIRCES_RECIPES.isEnabled() && mcRPGPlayer.doesPlayerHaveAbilityInLoadout(UnlockedAbilities.CIRCES_RECIPES) && mcRPGPlayer.getBaseAbility(UnlockedAbilities.CIRCES_RECIPES).isToggled()) {
                        CircesRecipes circesRecipes = (CircesRecipes)mcRPGPlayer.getBaseAbility(UnlockedAbilities.CIRCES_RECIPES);
                        return potionRecipeManager.getTypesForTier(circesRecipes.getCurrentTier()).contains((Object)basePotionType);
                    }
                }
                catch (McRPGPlayerNotFoundException mcRPGPlayerNotFoundException) {}
                continue;
            }
            return true;
        }
        return false;
    }

    public void setIngredient(ItemStack itemStack) {
        this.updateHolder();
        this.ingredient = itemStack;
        this.inv.setItem(13, itemStack);
        this.holder.getSnapshotInventory().setIngredient(itemStack);
        this.holder.update(true, true);
        for (HumanEntity humanEntity : this.inv.getViewers()) {
            ((Player)humanEntity).updateInventory();
        }
    }

    private void initProgressBar() {
        for (int i = 6; i >= 1; --i) {
            ItemStack itemStack = new ItemStack(Material.RED_STAINED_GLASS_PANE);
            ItemMeta itemMeta = itemStack.getItemMeta();
            double d = this.currentBrewProgress / this.getBrewDuration();
            DecimalFormat decimalFormat = new DecimalFormat();
            decimalFormat.setMinimumFractionDigits(2);
            decimalFormat.setMaximumFractionDigits(2);
            itemMeta.setDisplayName(Methods.color("&c" + decimalFormat.format(d) + "%"));
            itemStack.setItemMeta(itemMeta);
            this.inv.setItem(i * 9 - 1, itemStack);
        }
    }

    private void updateProgressBar() {
        double d = this.getBrewDuration();
        double d2 = 24.0 * d;
        int n = (int)(this.currentBrewProgress / (d != 0.0 ? d : 1.0));
        int n2 = (int)(this.currentBrewProgress / d * 24.0);
        double d3 = 100.0 * (this.currentBrewProgress / (d != 0.0 ? d : 1.0));
        for (int i = 6; i >= 1; --i) {
            int n3;
            if (n2 >= 4) {
                n3 = 4;
                n2 -= 4;
            } else {
                n3 = n2;
                n2 = 0;
            }
            ItemStack itemStack = this.inv.getItem(i * 9 - 1);
            itemStack.setType(this.getFuelGlass(n3));
            ItemMeta itemMeta = itemStack.getItemMeta();
            DecimalFormat decimalFormat = new DecimalFormat();
            decimalFormat.setMinimumFractionDigits(2);
            decimalFormat.setMaximumFractionDigits(2);
            itemMeta.setDisplayName(Methods.color(this.getFuelGlassColour(n3) + decimalFormat.format(d3 <= 100.0 ? d3 : 100.0) + "%"));
            itemStack.setItemMeta(itemMeta);
            this.inv.setItem(i * 9 - 1, itemStack);
        }
        for (HumanEntity humanEntity : this.inv.getViewers()) {
            ((Player)humanEntity).updateInventory();
        }
    }

    private double getBrewDuration() {
        if (this.lastInteractedPlayer != null && this.lastInteractedPlayer.isOnline()) {
            try {
                McRPGPlayer mcRPGPlayer = PlayerManager.getPlayer(this.lastInteractedPlayer.getUniqueId());
                FileConfiguration fileConfiguration = McRPG.getInstance().getFileManager().getFile(FileManager.Files.SORCERY_CONFIG);
                if (fileConfiguration.getBoolean("SorceryEnabled") && DefaultAbilities.HASTY_BREW.isEnabled() && mcRPGPlayer.getBaseAbility(DefaultAbilities.HASTY_BREW).isToggled()) {
                    HastyBrew hastyBrew = (HastyBrew)mcRPGPlayer.getBaseAbility(DefaultAbilities.HASTY_BREW);
                    Parser parser = DefaultAbilities.HASTY_BREW.getActivationEquation();
                    parser.setVariable("sorcery_level", mcRPGPlayer.getSkill(Skills.SORCERY).getCurrentLevel());
                    parser.setVariable("power_level", mcRPGPlayer.getPowerLevel());
                    double d = parser.getValue();
                    HastyBrewEvent hastyBrewEvent = new HastyBrewEvent(mcRPGPlayer, hastyBrew, d);
                    Bukkit.getPluginManager().callEvent((Event)hastyBrewEvent);
                    if (hastyBrewEvent.isCancelled()) {
                        return this.potionBrewDuration;
                    }
                    d = hastyBrewEvent.getBrewDurationBoost();
                    d /= 100.0;
                    return this.potionBrewDuration * ((d = 1.0 - d) > 0.0 ? d : 0.2);
                }
            }
            catch (McRPGPlayerNotFoundException mcRPGPlayerNotFoundException) {
                return this.potionBrewDuration;
            }
        }
        return this.potionBrewDuration;
    }

    private Material getFuelGlass(int n) {
        if (n == 4) {
            return Material.LIME_STAINED_GLASS_PANE;
        }
        if (n == 3) {
            return Material.YELLOW_STAINED_GLASS_PANE;
        }
        if (n == 2) {
            return Material.ORANGE_STAINED_GLASS_PANE;
        }
        return Material.RED_STAINED_GLASS_PANE;
    }

    private String getFuelGlassColour(int n) {
        if (n == 4) {
            return "&a";
        }
        if (n == 3) {
            return "&e";
        }
        if (n == 2) {
            return "&6";
        }
        return "&c";
    }

    public void save() {
        BrewingStandManager brewingStandManager = McRPG.getInstance().getBrewingStandManager();
        if (brewingStandManager.isBrewingStandLoaded(this.holder)) {
            BrewingStandWrapper brewingStandWrapper = brewingStandManager.getBrewingStandWrapper(this.holder);
            brewingStandWrapper.saveToFile();
        }
    }

    public ItemStack getFuel() {
        return this.fuel;
    }

    public void setFuel(ItemStack itemStack) {
        this.fuel = itemStack;
    }

    public BrewingStand getHolder() {
        return this.holder;
    }

    public ItemStack getIngredient() {
        return this.ingredient;
    }

    public int getCurrentFuelLevel() {
        return this.currentFuelLevel;
    }

    public void setCurrentFuelLevel(int n) {
        this.currentFuelLevel = n;
    }

    public int getMaxCurrentFuelLevel() {
        return this.maxCurrentFuelLevel;
    }

    public void setMaxCurrentFuelLevel(int n) {
        this.maxCurrentFuelLevel = n;
    }

    public double getCurrentBrewProgress() {
        return this.currentBrewProgress;
    }

    public void setCurrentBrewProgress(double d) {
        this.currentBrewProgress = d;
    }

    public double getPotionBrewDuration() {
        return this.potionBrewDuration;
    }

    public BukkitTask getBrewTask() {
        return this.brewTask;
    }

    public Inventory getInv() {
        return this.inv;
    }

    public OfflinePlayer getLastInteractedPlayer() {
        return this.lastInteractedPlayer;
    }

    public void setLastInteractedPlayer(OfflinePlayer offlinePlayer) {
        this.lastInteractedPlayer = offlinePlayer;
    }

    public OfflinePlayer getPlayerStartingBrew() {
        return this.playerStartingBrew;
    }

    public void setPlayerStartingBrew(OfflinePlayer offlinePlayer) {
        this.playerStartingBrew = offlinePlayer;
    }
}

