/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.api.util.brewing;

import java.util.HashSet;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.potion.PotionEffectType;
import us.eunoians.mcrpg.McRPG;
import us.eunoians.mcrpg.api.util.FileManager;
import us.eunoians.mcrpg.api.util.brewing.PotionRecipeManager;
import us.eunoians.mcrpg.types.BasePotionType;

public class TagMeta {
    private Set<Material> ingredients = new HashSet<Material>();
    private Set<String> children;
    private String tag;
    private int duration;
    private int potionEffectLevel;
    private BasePotionType basePotionType;

    TagMeta(String string, String string2, BasePotionType basePotionType) {
        this.basePotionType = basePotionType;
        this.tag = string2;
        FileConfiguration fileConfiguration = McRPG.getInstance().getFileManager().getFile(FileManager.Files.BREWING_ITEMS_CONFIG);
        String string3 = string + "." + string2 + ".";
        fileConfiguration.getStringList(string3 + "Ingredients").stream().map(Material::getMaterial).forEach(material -> this.ingredients.add((Material)material));
        this.duration = fileConfiguration.getInt(string3 + "Duration", 0);
        this.potionEffectLevel = fileConfiguration.getInt(string3 + "PotionEffectLevel", 1);
        this.children = fileConfiguration.contains(string3 + "ChildTags") ? new HashSet(fileConfiguration.getStringList(string3 + "ChildTags")) : new HashSet();
    }

    public boolean isValidIngredient(Material material) {
        return this.ingredients.contains(material);
    }

    public boolean doesIngredientLeadToChild(Material material) {
        PotionRecipeManager potionRecipeManager = McRPG.getInstance().getPotionRecipeManager();
        for (String string : this.children) {
            TagMeta tagMeta = potionRecipeManager.getPotionEffectTagWrapper(this.basePotionType).getTagMeta(string);
            if (!tagMeta.isValidIngredient(material)) continue;
            return true;
        }
        return false;
    }

    public String getChildTag(Material material) {
        PotionRecipeManager potionRecipeManager = McRPG.getInstance().getPotionRecipeManager();
        for (String string : this.children) {
            Object object;
            String[] stringArray = string.split("\\.");
            BasePotionType basePotionType = this.basePotionType;
            String string2 = string;
            if (stringArray.length > 1) {
                basePotionType = stringArray[0].equals("AWKWARD") ? BasePotionType.AWKWARD : BasePotionType.getFromPotionEffect(PotionEffectType.getByName((String)stringArray[0]));
                string2 = stringArray[1];
            }
            if (!(stringArray.length == 3 ? material == (object = Material.getMaterial((String)stringArray[2])) : ((TagMeta)(object = potionRecipeManager.getPotionEffectTagWrapper(basePotionType).getTagMeta(string2))).isValidIngredient(material))) continue;
            return string;
        }
        return null;
    }

    public Set<Material> getIngredients() {
        return this.ingredients;
    }

    public Set<String> getChildren() {
        return this.children;
    }

    public String getTag() {
        return this.tag;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int n) {
        this.duration = n;
    }

    public int getPotionEffectLevel() {
        return this.potionEffectLevel;
    }

    public void setPotionEffectLevel(int n) {
        this.potionEffectLevel = n;
    }

    public BasePotionType getBasePotionType() {
        return this.basePotionType;
    }
}

