/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.api.util.brewing;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffectType;
import us.eunoians.mcrpg.McRPG;
import us.eunoians.mcrpg.api.util.FileManager;
import us.eunoians.mcrpg.api.util.Methods;
import us.eunoians.mcrpg.api.util.brewing.BasePotion;
import us.eunoians.mcrpg.api.util.brewing.PotionEffectTagWrapper;
import us.eunoians.mcrpg.api.util.brewing.TagMeta;
import us.eunoians.mcrpg.types.BasePotionType;

public class PotionRecipeManager {
    private Map<Material, Integer> fuelMaterials = new HashMap<Material, Integer>();
    private Map<BasePotionType, PotionEffectTagWrapper> potionRecipeMap = new HashMap<BasePotionType, PotionEffectTagWrapper>();
    private Set<Material> allPossibleIngredients = new HashSet<Material>();
    private Set<BasePotionType> extraRecipes = new HashSet<BasePotionType>();
    private HashMap<Integer, Set<BasePotionType>> tierToTypes = new HashMap();

    public PotionRecipeManager() {
        this.reloadManager();
    }

    public void reloadManager() {
        this.initRecipes();
        this.initFuelItems();
    }

    private void initRecipes() {
        Object object;
        this.potionRecipeMap.clear();
        this.extraRecipes.clear();
        this.tierToTypes.clear();
        this.allPossibleIngredients.add(Material.NETHER_WART);
        this.allPossibleIngredients.add(Material.FERMENTED_SPIDER_EYE);
        this.allPossibleIngredients.add(Material.GUNPOWDER);
        this.allPossibleIngredients.add(Material.DRAGON_BREATH);
        FileConfiguration fileConfiguration = McRPG.getInstance().getFileManager().getFile(FileManager.Files.BREWING_ITEMS_CONFIG);
        for (String string : fileConfiguration.getConfigurationSection("Potions").getKeys(false)) {
            BasePotionType basePotionType;
            if (string.equals("WATER")) {
                basePotionType = BasePotionType.WATER;
            } else if (string.equals("AWKWARD")) {
                basePotionType = BasePotionType.AWKWARD;
            } else {
                object = PotionEffectType.getByName((String)string);
                basePotionType = BasePotionType.getFromPotionEffect((PotionEffectType)object);
            }
            object = new PotionEffectTagWrapper(basePotionType);
            this.potionRecipeMap.put(basePotionType, (PotionEffectTagWrapper)object);
            this.allPossibleIngredients.addAll(((PotionEffectTagWrapper)object).getAllChildIgredients());
        }
        FileConfiguration fileConfiguration2 = McRPG.getInstance().getFileManager().getFile(FileManager.Files.SORCERY_CONFIG);
        int n = fileConfiguration2.getInt("CircesRecipesConfig.TierAmount");
        for (int i = 1; i <= n; ++i) {
            object = new HashSet();
            for (String string : fileConfiguration2.getStringList("CircesRecipesConfig.Tier" + Methods.convertToNumeral(i) + ".PotionEffects")) {
                PotionEffectType potionEffectType = PotionEffectType.getByName((String)string);
                BasePotionType basePotionType = BasePotionType.getFromPotionEffect(potionEffectType);
                this.extraRecipes.add(basePotionType);
                object.add(basePotionType);
            }
            this.tierToTypes.put(i, (Set<BasePotionType>)object);
        }
    }

    private void initFuelItems() {
        FileConfiguration fileConfiguration = McRPG.getInstance().getFileManager().getFile(FileManager.Files.BREWING_ITEMS_CONFIG);
        this.fuelMaterials.clear();
        for (String string : fileConfiguration.getConfigurationSection("Fuel").getKeys(false)) {
            String string2 = "Fuel." + string + ".";
            Material material = Material.getMaterial((String)fileConfiguration.getString(string2 + "Material"));
            int n = fileConfiguration.getInt(string2 + "FuelAmount");
            this.fuelMaterials.put(material, n);
        }
    }

    public boolean isFuel(ItemStack itemStack) {
        return this.fuelMaterials.containsKey(itemStack.getType());
    }

    public boolean isLockedRecipe(BasePotionType basePotionType) {
        return this.extraRecipes.contains((Object)basePotionType);
    }

    public Set<BasePotionType> getTypesForTier(int n) {
        return this.tierToTypes.get(n);
    }

    public int getFuelAmount(ItemStack itemStack) {
        return this.fuelMaterials.get(itemStack.getType());
    }

    public boolean isPotionTypeRegistered(BasePotionType basePotionType) {
        return this.potionRecipeMap.containsKey((Object)basePotionType);
    }

    public PotionEffectTagWrapper getPotionEffectTagWrapper(BasePotionType basePotionType) {
        return this.potionRecipeMap.get((Object)basePotionType);
    }

    public boolean doesMaterialLeadToChild(Material material, BasePotion basePotion) {
        if (basePotion.getBasePotionType() == BasePotionType.WATER && (material == Material.NETHER_WART || material == Material.FERMENTED_SPIDER_EYE)) {
            return true;
        }
        PotionEffectTagWrapper potionEffectTagWrapper = this.getPotionEffectTagWrapper(basePotion.getBasePotionType());
        if (basePotion.getAsItem().getType() == Material.POTION && material == Material.GUNPOWDER && potionEffectTagWrapper.isCanBeSplash()) {
            return true;
        }
        if (basePotion.getAsItem().getType() == Material.SPLASH_POTION && material == Material.DRAGON_BREATH && potionEffectTagWrapper.isCanBeLingering()) {
            return true;
        }
        String string = basePotion.getTag();
        TagMeta tagMeta = potionEffectTagWrapper.getTagMeta(string);
        return tagMeta.getChildTag(material) != null;
    }

    public BasePotionType getChildPotionType(Material material, BasePotion basePotion) {
        if (basePotion.getBasePotionType() == BasePotionType.WATER && material == Material.NETHER_WART) {
            return BasePotionType.AWKWARD;
        }
        if (basePotion.getBasePotionType() == BasePotionType.WATER && material == Material.FERMENTED_SPIDER_EYE) {
            return BasePotionType.WEAKNESS;
        }
        PotionEffectTagWrapper potionEffectTagWrapper = this.getPotionEffectTagWrapper(basePotion.getBasePotionType());
        if (basePotion.getAsItem().getType() == Material.POTION && material == Material.GUNPOWDER && potionEffectTagWrapper.isCanBeSplash()) {
            return basePotion.getBasePotionType();
        }
        if (basePotion.getAsItem().getType() == Material.SPLASH_POTION && material == Material.DRAGON_BREATH && potionEffectTagWrapper.isCanBeLingering()) {
            return basePotion.getBasePotionType();
        }
        String string = basePotion.getTag();
        TagMeta tagMeta = potionEffectTagWrapper.getTagMeta(string);
        String string2 = tagMeta.getChildTag(material);
        if (string2.split("\\.").length >= 2) {
            return BasePotionType.getFromPotionEffect(PotionEffectType.getByName((String)string2.split("\\.")[0]));
        }
        return tagMeta.getBasePotionType();
    }

    public void updateInformation(Material material, BasePotion basePotion) {
        if (basePotion.getBasePotionType() == BasePotionType.WATER && material == Material.NETHER_WART) {
            basePotion.setBasePotionType(BasePotionType.AWKWARD);
            return;
        }
    }

    public boolean isValidIngredient(Material material) {
        return this.allPossibleIngredients.contains(material);
    }

    public String validateTag(ItemStack itemStack) {
        return "";
    }
}

