/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.api.util.brewing;

import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import us.eunoians.mcrpg.api.util.brewing.BasePotion;
import us.eunoians.mcrpg.types.BasePotionType;

public class PotionFactory {
    public static BasePotion convertItemStackToBasePotion(ItemStack itemStack) {
        return new BasePotion(itemStack);
    }

    public static BasePotionType getBasePotionTypeFromItemStack(ItemStack itemStack) {
        if (!itemStack.getType().name().contains("POTION")) {
            return null;
        }
        PotionMeta potionMeta = (PotionMeta)itemStack.getItemMeta();
        if (potionMeta.getBasePotionData().getType() == PotionType.WATER) {
            return BasePotionType.WATER;
        }
        if (potionMeta.getBasePotionData().getType() == PotionType.AWKWARD) {
            return BasePotionType.AWKWARD;
        }
        PotionData potionData = potionMeta.getBasePotionData();
        PotionEffectType potionEffectType = potionData.getType().getEffectType();
        if (potionData.getType() == PotionType.UNCRAFTABLE && potionMeta.hasCustomEffects()) {
            potionEffectType = ((PotionEffect)potionMeta.getCustomEffects().get(0)).getType();
        }
        return BasePotionType.getFromPotionEffect(potionEffectType);
    }
}

