/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.api.util.brewing;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import us.eunoians.mcrpg.McRPG;
import us.eunoians.mcrpg.api.util.FileManager;
import us.eunoians.mcrpg.api.util.brewing.TagMeta;
import us.eunoians.mcrpg.types.BasePotionType;

public class PotionEffectTagWrapper {
    private HashMap<String, TagMeta> storedTagMeta = new HashMap();
    private boolean canBeSplash;
    private double splashDurationModifier;
    private boolean canBeLingering;
    private double lingeringDurationModifier;

    PotionEffectTagWrapper(BasePotionType basePotionType) {
        FileConfiguration fileConfiguration = McRPG.getInstance().getFileManager().getFile(FileManager.Files.BREWING_ITEMS_CONFIG);
        if (!fileConfiguration.contains("Potions." + basePotionType.getName())) {
            Bukkit.getLogger().log(Level.WARNING, basePotionType.getName() + " is invalidly registered in the brewing configuration. It has been ignored. To make this warning go away, please remove or correct the issue.");
            return;
        }
        String string = "Potions." + basePotionType.getName() + ".Tags";
        for (String string2 : fileConfiguration.getConfigurationSection(string).getKeys(false)) {
            TagMeta tagMeta = new TagMeta(string, string2, basePotionType);
            this.storedTagMeta.put(string2, tagMeta);
        }
        String string3 = "Potions." + basePotionType.getName() + ".SpecialModifiers.";
        this.canBeSplash = fileConfiguration.getBoolean((String)string3 + "CanBeSplash", false);
        this.canBeLingering = fileConfiguration.getBoolean((String)string3 + "CanBeLingering", false);
        this.splashDurationModifier = fileConfiguration.getDouble((String)string3 + "SplashDurationModifier", 0.5);
        this.lingeringDurationModifier = fileConfiguration.getDouble((String)string3 + "LingeringDurationModifier", 0.3);
    }

    public TagMeta getTagMeta(String string) {
        return this.storedTagMeta.getOrDefault(string, null);
    }

    public Map<String, TagMeta> getAllTags() {
        return (Map)this.storedTagMeta.clone();
    }

    public Set<Material> getAllChildIgredients() {
        HashSet<Material> hashSet = new HashSet<Material>();
        for (TagMeta tagMeta : this.storedTagMeta.values()) {
            for (String string : tagMeta.getChildren()) {
                String[] stringArray = string.split("\\.");
                if (stringArray.length != 3) continue;
                hashSet.add(Material.getMaterial((String)stringArray[2]));
            }
            hashSet.addAll(tagMeta.getIngredients());
        }
        return hashSet;
    }

    public boolean isCanBeSplash() {
        return this.canBeSplash;
    }

    public void setCanBeSplash(boolean bl) {
        this.canBeSplash = bl;
    }

    public double getSplashDurationModifier() {
        return this.splashDurationModifier;
    }

    public void setSplashDurationModifier(double d) {
        this.splashDurationModifier = d;
    }

    public boolean isCanBeLingering() {
        return this.canBeLingering;
    }

    public void setCanBeLingering(boolean bl) {
        this.canBeLingering = bl;
    }

    public double getLingeringDurationModifier() {
        return this.lingeringDurationModifier;
    }

    public void setLingeringDurationModifier(double d) {
        this.lingeringDurationModifier = d;
    }
}

