/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.api.util.brewing;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.block.BrewingStand;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import us.eunoians.mcrpg.McRPG;
import us.eunoians.mcrpg.api.util.Methods;
import us.eunoians.mcrpg.api.util.brewing.standmeta.BrewingStandWrapper;

public class BrewingStandManager {
    private Map<String, FileWrapper> chunkToSaveFile = new HashMap<String, FileWrapper>();
    private Map<String, Map<Location, BrewingStandWrapper>> brewingStandWrapperMap = new HashMap<String, Map<Location, BrewingStandWrapper>>();

    public BrewingStandWrapper initNewBrewingStand(BrewingStand brewingStand) {
        Serializable serializable;
        Object object;
        Location location = brewingStand.getLocation();
        String string = Methods.chunkToLoc(location.getChunk());
        if (!this.chunkToSaveFile.containsKey(string)) {
            object = new File(McRPG.getInstance().getDataFolder(), "brewing_storage");
            if (!((File)object).exists()) {
                ((File)object).mkdir();
            }
            serializable = new File((File)object, string + ".yml");
            FileWrapper fileWrapper = new FileWrapper((File)serializable);
            this.chunkToSaveFile.put(string, fileWrapper);
        }
        object = new BrewingStandWrapper(brewingStand, this.chunkToSaveFile.get(string).getFileConfiguration());
        if (this.brewingStandWrapperMap.containsKey(string)) {
            this.brewingStandWrapperMap.get(string).put(location, (BrewingStandWrapper)object);
        } else {
            serializable = new HashMap<Location, Object>();
            serializable.put(location, object);
            this.brewingStandWrapperMap.put(string, (Map<Location, BrewingStandWrapper>)((Object)serializable));
        }
        ((BrewingStandWrapper)object).saveToFile();
        this.save(location);
        return object;
    }

    public void unloadChunk(Chunk chunk) {
        String string = Methods.chunkToLoc(chunk);
        if (this.brewingStandWrapperMap.containsKey(string)) {
            for (Location location : this.brewingStandWrapperMap.get(string).keySet()) {
                BrewingStandWrapper brewingStandWrapper = this.brewingStandWrapperMap.get(string).get(location);
                brewingStandWrapper.finishBrew();
                brewingStandWrapper.saveToFile();
            }
        }
        this.brewingStandWrapperMap.remove(string);
        this.chunkToSaveFile.remove(string);
    }

    public void breakBrewingStand(Location location) {
        String string = Methods.chunkToLoc(location.getChunk());
        if (this.brewingStandWrapperMap.containsKey(string) && this.brewingStandWrapperMap.get(string).containsKey(location)) {
            this.brewingStandWrapperMap.get(string).get(location).deleteData();
            String string2 = Methods.locToString(location);
            this.chunkToSaveFile.get(string).getFileConfiguration().set("BrewingStands." + string2, null);
            this.brewingStandWrapperMap.get(string).remove(location);
            if (this.brewingStandWrapperMap.get(string).size() == 0) {
                this.brewingStandWrapperMap.remove(string);
                this.chunkToSaveFile.get(string).getFile().delete();
                this.chunkToSaveFile.remove(string);
            }
        }
    }

    public boolean isBrewingStandLoaded(BrewingStand brewingStand) {
        Location location = brewingStand.getLocation();
        String string = Methods.chunkToLoc(location.getChunk());
        return this.brewingStandWrapperMap.containsKey(string) && this.brewingStandWrapperMap.get(string).containsKey(location);
    }

    public BrewingStandWrapper getBrewingStandWrapper(BrewingStand brewingStand) {
        Location location = brewingStand.getLocation();
        String string = Methods.chunkToLoc(location.getChunk());
        return this.brewingStandWrapperMap.get(string).get(location);
    }

    public void save(Location location) {
        String string = Methods.chunkToLoc(location.getChunk());
        if (this.chunkToSaveFile.containsKey(string)) {
            this.chunkToSaveFile.get(string).save();
        }
    }

    public void save(Chunk chunk) {
        String string = Methods.chunkToLoc(chunk);
        if (this.chunkToSaveFile.containsKey(string)) {
            this.chunkToSaveFile.get(string).save();
        }
    }

    public void shutDown() {
        for (FileWrapper fileWrapper : this.chunkToSaveFile.values()) {
            fileWrapper.save();
        }
    }

    public void updateNamingFormat() {
        List list;
        File[] fileArray;
        File file2 = new File(McRPG.getInstance().getDataFolder(), "brewing_storage");
        if (file2.exists() && (fileArray = file2.listFiles()) != null && fileArray.length > 0 && (list = Arrays.stream(fileArray).filter(file -> file.getName().contains(":")).collect(Collectors.toList())).size() > 0) {
            McRPG.getInstance().getLogger().info("Found pre-1.2.4 brewing stand storage format. Converting...");
            boolean bl = false;
            for (File file3 : list) {
                try {
                    Files.move(file3.toPath(), file3.toPath().resolveSibling(file3.getName().replaceAll(":", "@")), new CopyOption[0]);
                }
                catch (IOException iOException) {
                    bl = true;
                    iOException.printStackTrace();
                }
            }
            if (bl) {
                McRPG.getInstance().getLogger().severe("Oops! 1.2.4 brewing stand storage format did not convert successfully :(");
            } else {
                McRPG.getInstance().getLogger().info("1.2.4 brewing stand storage format converted successfully!");
            }
        }
    }

    private static class FileWrapper {
        private File file;
        private FileConfiguration fileConfiguration;

        public FileWrapper(File file) {
            this.file = file;
            this.fileConfiguration = YamlConfiguration.loadConfiguration((File)file);
        }

        public void save() {
            try {
                this.fileConfiguration.save(this.file);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        public File getFile() {
            return this.file;
        }

        public FileConfiguration getFileConfiguration() {
            return this.fileConfiguration;
        }
    }
}

