/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.api.util.brewing;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionType;
import us.eunoians.mcrpg.McRPG;
import us.eunoians.mcrpg.api.util.FileManager;
import us.eunoians.mcrpg.api.util.Methods;
import us.eunoians.mcrpg.api.util.brewing.PotionEffectTagWrapper;
import us.eunoians.mcrpg.api.util.brewing.PotionFactory;
import us.eunoians.mcrpg.api.util.brewing.PotionRecipeManager;
import us.eunoians.mcrpg.api.util.brewing.TagMeta;
import us.eunoians.mcrpg.nbtapi.NBTItem;
import us.eunoians.mcrpg.types.BasePotionType;

public class BasePotion {
    private int totalTimesModified;
    private String tag;
    private BasePotionType basePotionType;
    private ItemStack potionItem;
    private NBTItem nbtItem;

    BasePotion(ItemStack itemStack) {
        PotionMeta potionMeta = (PotionMeta)itemStack.getItemMeta();
        PotionData potionData = potionMeta.getBasePotionData();
        PotionType potionType = potionData.getType();
        this.potionItem = itemStack;
        if (potionType != PotionType.AWKWARD && potionType != PotionType.WATER && potionType != PotionType.UNCRAFTABLE) {
            int n;
            potionMeta.setBasePotionData(new PotionData(PotionType.UNCRAFTABLE));
            int n2 = potionData.isExtended() ? 480 : (potionData.isUpgraded() ? 90 : (n = potionType.isInstant() ? 0 : 180));
            if (itemStack.getType() == Material.LINGERING_POTION) {
                n /= 4;
            }
            int n3 = potionData.isUpgraded() ? 1 : 0;
            potionMeta.addCustomEffect(new PotionEffect(potionData.getType().getEffectType(), n * 20, n3), true);
            itemStack.setItemMeta((ItemMeta)potionMeta);
        }
        this.basePotionType = PotionFactory.getBasePotionTypeFromItemStack(itemStack);
        if (this.basePotionType != BasePotionType.AWKWARD && this.basePotionType != BasePotionType.WATER) {
            String string = (this.potionItem.getType() == Material.LINGERING_POTION ? McRPG.getInstance().getLangFile().getString("Potions.Lingering") + " " : (this.potionItem.getType() == Material.SPLASH_POTION ? McRPG.getInstance().getLangFile().getString("Potions.Splash") + " " : "")) + McRPG.getInstance().getLangFile().getString("Potions.PotionNamePrefix").replace("%PotionName%", this.basePotionType.getDisplayName());
            potionMeta.setDisplayName(Methods.color(string));
            List list = Arrays.stream(this.basePotionType.getCustomColour().split(":")).map(Integer::parseInt).collect(Collectors.toList());
            potionMeta.setColor(Color.fromRGB((int)((Integer)list.get(0)), (int)((Integer)list.get(1)), (int)((Integer)list.get(2))));
        }
        itemStack.setItemMeta((ItemMeta)potionMeta);
        this.potionItem = itemStack;
        this.nbtItem = new NBTItem(this.potionItem);
        if (this.nbtItem.hasNBTData()) {
            this.tag = this.nbtItem.hasKey("McRPGTag") != false ? this.nbtItem.getString("McRPGTag") : null;
            this.totalTimesModified = this.nbtItem.hasKey("TotalModified") != false ? this.nbtItem.getInteger("TotalModified") : 0;
            this.potionItem = this.nbtItem.getItem();
        } else {
            this.totalTimesModified = 0;
        }
        if (this.tag == null || this.tag.equalsIgnoreCase("INVALID")) {
            PotionRecipeManager potionRecipeManager = McRPG.getInstance().getPotionRecipeManager();
            if (this.basePotionType == BasePotionType.WATER) {
                this.tag = "Default";
            } else if (this.basePotionType == BasePotionType.AWKWARD) {
                this.tag = "Default";
            } else if (potionRecipeManager.isPotionTypeRegistered(this.basePotionType)) {
                PotionEffectTagWrapper potionEffectTagWrapper = potionRecipeManager.getPotionEffectTagWrapper(this.basePotionType);
                Map<String, TagMeta> map = potionEffectTagWrapper.getAllTags();
                PotionEffect potionEffect = (PotionEffect)potionMeta.getCustomEffects().get(0);
                int n = potionEffect.getDuration() / 20;
                if (itemStack.getType() == Material.LINGERING_POTION) {
                    n *= 4;
                }
                int n4 = potionEffect.getAmplifier();
                int n5 = 0;
                String string = "";
                for (String string2 : map.keySet()) {
                    int n6;
                    TagMeta tagMeta = map.get(string2);
                    int n7 = Math.abs(tagMeta.getDuration() - n);
                    int n8 = 180 - n7 + (200 - 200 * (n6 = Math.abs(tagMeta.getPotionEffectLevel() - n4)));
                    if (n8 <= n5) continue;
                    string = string2;
                    n5 = n8;
                }
                this.tag = string;
            }
        }
        this.saveStack();
    }

    public void updateInfo() {
        this.potionItem = this.nbtItem.getItem();
        if (McRPG.getInstance().getFileManager().getFile(FileManager.Files.SORCERY_CONFIG).getInt("MaxBrewAmountForExp") > this.totalTimesModified) {
            ++this.totalTimesModified;
        }
        PotionRecipeManager potionRecipeManager = McRPG.getInstance().getPotionRecipeManager();
        PotionEffectTagWrapper potionEffectTagWrapper = potionRecipeManager.getPotionEffectTagWrapper(this.basePotionType);
        TagMeta tagMeta = potionEffectTagWrapper.getTagMeta(this.tag);
        PotionMeta potionMeta = (PotionMeta)this.potionItem.getItemMeta();
        this.basePotionType = tagMeta.getBasePotionType();
        if (this.basePotionType == BasePotionType.AWKWARD) {
            potionMeta.setBasePotionData(new PotionData(PotionType.AWKWARD));
        } else {
            potionMeta.setBasePotionData(new PotionData(PotionType.UNCRAFTABLE));
        }
        if (this.basePotionType != BasePotionType.AWKWARD && this.basePotionType != BasePotionType.WATER) {
            PotionEffect potionEffect = new PotionEffect(this.basePotionType.getEffectType(), (int)((double)(tagMeta.getDuration() * 20) * (this.potionItem.getType() == Material.LINGERING_POTION ? potionEffectTagWrapper.getLingeringDurationModifier() * 2.0 : (this.potionItem.getType() == Material.SPLASH_POTION ? potionEffectTagWrapper.getSplashDurationModifier() : 1.0))), tagMeta.getPotionEffectLevel() - 1);
            potionMeta.clearCustomEffects();
            potionMeta.addCustomEffect(potionEffect, true);
            String string = (this.potionItem.getType() == Material.LINGERING_POTION ? McRPG.getInstance().getLangFile().getString("Potions.Lingering") + " " : (this.potionItem.getType() == Material.SPLASH_POTION ? McRPG.getInstance().getLangFile().getString("Potions.Splash") + " " : "")) + McRPG.getInstance().getLangFile().getString("Potions.PotionNamePrefix").replace("%PotionName%", this.basePotionType.getDisplayName());
            potionMeta.setDisplayName(Methods.color(string));
            List list = Arrays.stream(this.basePotionType.getCustomColour().split(":")).map(Integer::parseInt).collect(Collectors.toList());
            potionMeta.setColor(Color.fromRGB((int)((Integer)list.get(0)), (int)((Integer)list.get(1)), (int)((Integer)list.get(2))));
        }
        this.potionItem.setItemMeta((ItemMeta)potionMeta);
        this.nbtItem = new NBTItem(this.potionItem);
        this.saveStack();
    }

    public void setSplash() {
        if (this.basePotionType == BasePotionType.AWKWARD || this.basePotionType == BasePotionType.WATER) {
            return;
        }
        this.potionItem = this.nbtItem.getItem();
        this.potionItem.setType(Material.SPLASH_POTION);
        double d = McRPG.getInstance().getPotionRecipeManager().getPotionEffectTagWrapper(this.basePotionType).getSplashDurationModifier();
        PotionMeta potionMeta = (PotionMeta)this.potionItem.getItemMeta();
        potionMeta.setDisplayName(Methods.color("&fSplash " + ChatColor.stripColor((String)potionMeta.getDisplayName())));
        PotionEffect potionEffect = (PotionEffect)potionMeta.getCustomEffects().get(0);
        PotionEffect potionEffect2 = new PotionEffect(this.basePotionType.getEffectType(), (int)((double)potionEffect.getDuration() * d), potionEffect.getAmplifier());
        potionMeta.clearCustomEffects();
        potionMeta.addCustomEffect(potionEffect2, true);
        this.potionItem.setItemMeta((ItemMeta)potionMeta);
        this.nbtItem = new NBTItem(this.potionItem);
        if (McRPG.getInstance().getFileManager().getFile(FileManager.Files.SORCERY_CONFIG).getInt("MaxBrewAmountForExp") > this.totalTimesModified) {
            ++this.totalTimesModified;
        }
        this.saveStack();
    }

    public void setLingering() {
        if (this.basePotionType == BasePotionType.AWKWARD || this.basePotionType == BasePotionType.WATER) {
            return;
        }
        this.potionItem = this.nbtItem.getItem();
        this.potionItem.setType(Material.LINGERING_POTION);
        double d = McRPG.getInstance().getPotionRecipeManager().getPotionEffectTagWrapper(this.basePotionType).getLingeringDurationModifier();
        PotionMeta potionMeta = (PotionMeta)this.potionItem.getItemMeta();
        potionMeta.setDisplayName(Methods.color(McRPG.getInstance().getLangFile().getString("Potions.Lingering") + " " + McRPG.getInstance().getLangFile().getString("Potions.PotionNamePrefix").replace("%PotionName%", this.basePotionType.getDisplayName())));
        PotionEffect potionEffect = (PotionEffect)potionMeta.getCustomEffects().get(0);
        PotionEffect potionEffect2 = new PotionEffect(this.basePotionType.getEffectType(), (int)((double)potionEffect.getDuration() * d * 2.0), potionEffect.getAmplifier());
        potionMeta.clearCustomEffects();
        potionMeta.addCustomEffect(potionEffect2, true);
        this.potionItem.setItemMeta((ItemMeta)potionMeta);
        this.nbtItem = new NBTItem(this.potionItem);
        if (McRPG.getInstance().getFileManager().getFile(FileManager.Files.SORCERY_CONFIG).getInt("MaxBrewAmountForExp") > this.totalTimesModified) {
            ++this.totalTimesModified;
        }
        this.saveStack();
    }

    public void saveStack() {
        this.nbtItem.setString("McRPGTag", this.tag);
        this.nbtItem.setInteger("TotalModified", this.totalTimesModified);
    }

    public ItemStack getAsItem() {
        return this.nbtItem.getItem();
    }

    public int getTotalTimesModified() {
        return this.totalTimesModified;
    }

    public void setTotalTimesModified(int n) {
        this.totalTimesModified = n;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String string) {
        this.tag = string;
    }

    public BasePotionType getBasePotionType() {
        return this.basePotionType;
    }

    public void setBasePotionType(BasePotionType basePotionType) {
        this.basePotionType = basePotionType;
    }

    public ItemStack getPotionItem() {
        return this.potionItem;
    }
}

