/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.api.util.artifacts;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.file.FileConfiguration;
import us.eunoians.mcrpg.McRPG;
import us.eunoians.mcrpg.api.util.FileManager;

public class ArtifactManager {
    private static ArtifactManager instance;
    private McRPG mcRPG;
    private Map<String, Double> spawnChances = new HashMap<String, Double>();

    public ArtifactManager(McRPG mcRPG) {
        this.mcRPG = mcRPG;
        this.init();
        instance = this;
    }

    private void init() {
        FileConfiguration fileConfiguration = this.mcRPG.getFileManager().getFile(FileManager.Files.ARTIFACT_FILE);
        if (fileConfiguration.getBoolean("BrewingArtifacts.Enabled")) {
            double d = fileConfiguration.getDouble("BrewingArtifacts.ChanceOfSpawning");
            this.spawnChances.put("BrewingArtifacts", d);
        }
    }

    public void reload() {
        this.spawnChances.clear();
        this.init();
    }

    public boolean isArtifactTypeValid(String string) {
        return this.spawnChances.containsKey(string);
    }

    public double getArtifactTypeChance(String string) {
        return this.spawnChances.get(string);
    }

    public static ArtifactManager getInstance() {
        return instance;
    }
}

