/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.api.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.file.FileConfiguration;
import us.eunoians.mcrpg.McRPG;
import us.eunoians.mcrpg.api.util.FileManager;
import us.eunoians.mcrpg.types.Skills;

public class WorldModifierManager {
    private Map<String, ExpModifierWrapper> worldModifiers = new HashMap<String, ExpModifierWrapper>();

    public WorldModifierManager() {
        FileConfiguration fileConfiguration = McRPG.getInstance().getFileManager().getFile(FileManager.Files.WORLD_MODIFIER);
        for (String string : fileConfiguration.getConfigurationSection("WorldModifier").getKeys(false)) {
            if (string.equalsIgnoreCase("test")) continue;
            this.worldModifiers.put(string, new ExpModifierWrapper(fileConfiguration.getStringList("WorldModifier." + string)));
        }
    }

    public Map<String, ExpModifierWrapper> getWorldModifiers() {
        return this.worldModifiers;
    }

    public class ExpModifierWrapper {
        Map<Skills, Double> expModifiers = new HashMap<Skills, Double>();

        public ExpModifierWrapper(List<String> list) {
            for (String string : list) {
                String[] stringArray = string.split(":");
                Skills skills = Skills.fromString(stringArray[0]);
                double d = Double.parseDouble(stringArray[1]);
                this.expModifiers.put(skills, d);
            }
        }

        public boolean isModified(Skills skills) {
            return this.expModifiers.containsKey((Object)skills);
        }

        public double getModifier(Skills skills) {
            return this.expModifiers.getOrDefault((Object)skills, 1.0);
        }
    }
}

