/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.api.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.file.FileConfiguration;
import us.eunoians.mcrpg.McRPG;
import us.eunoians.mcrpg.api.util.FileManager;

public class RemoteTransferTracker {
    private static HashMap<UUID, Location> locations = new HashMap();

    public RemoteTransferTracker() {
        this.load();
    }

    public static void addLocation(UUID uUID, Location location) {
        locations.put(uUID, location);
        RemoteTransferTracker.save();
    }

    public static Location getLocation(UUID uUID) {
        return locations.getOrDefault(uUID, null);
    }

    public static void removeLocation(UUID uUID) {
        Location location = locations.remove(uUID);
        McRPG.getInstance().getFileManager().getFile(FileManager.Files.LOCATIONS).set("RemoteTransfer." + uUID.toString(), null);
        RemoteTransferTracker.save();
    }

    public static boolean isTracked(Location location) {
        return locations.values().contains(location);
    }

    public static boolean isTracked(UUID uUID) {
        return locations.keySet().contains(uUID);
    }

    public static ArrayList<Location> getLocations() {
        return new ArrayList<Location>(locations.values());
    }

    public static UUID getUUID(Location location) {
        return locations.keySet().stream().filter(uUID -> locations.get(uUID).equals((Object)location)).findFirst().orElse(null);
    }

    private static void save() {
        McRPG mcRPG = McRPG.getInstance();
        FileConfiguration fileConfiguration = mcRPG.getFileManager().getFile(FileManager.Files.LOCATIONS);
        locations.keySet().forEach(uUID -> {
            Location location = locations.get(uUID);
            fileConfiguration.set("RemoteTransfer." + uUID.toString(), (Object)RemoteTransferTracker.locToString(location));
        });
        mcRPG.getFileManager().saveFile(FileManager.Files.LOCATIONS);
    }

    private void load() {
        FileConfiguration fileConfiguration = McRPG.getInstance().getFileManager().getFile(FileManager.Files.LOCATIONS);
        if (fileConfiguration.contains("RemoteTransfer")) {
            McRPG.getInstance().getFileManager().getFile(FileManager.Files.LOCATIONS).getConfigurationSection("RemoteTransfer").getKeys(false).stream().map(UUID::fromString).forEach(uUID -> {
                String string = McRPG.getInstance().getFileManager().getFile(FileManager.Files.LOCATIONS).getString("RemoteTransfer." + uUID.toString());
                locations.put((UUID)uUID, RemoteTransferTracker.stringToLocation(string));
            });
        }
    }

    private static String locToString(Location location) {
        return location.getWorld().getName() + "?" + (int)location.getX() + "?" + (int)location.getY() + "?" + (int)location.getZ();
    }

    public static Location stringToLocation(String string) {
        String[] stringArray = string.split("\\?");
        if (stringArray.length == 4) {
            Location location = new Location(Bukkit.getWorld((String)stringArray[0]), Double.parseDouble(stringArray[1]), Double.parseDouble(stringArray[2]), Double.parseDouble(stringArray[3]), 0.0f, 0.0f);
            return location;
        }
        return null;
    }
}

