/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.api.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TreeMap;
import java.util.UUID;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import us.eunoians.mcrpg.McRPG;
import us.eunoians.mcrpg.api.exceptions.McRPGPlayerNotFoundException;
import us.eunoians.mcrpg.api.util.FileManager;
import us.eunoians.mcrpg.gui.GUIItem;
import us.eunoians.mcrpg.nbtapi.NBTItem;
import us.eunoians.mcrpg.party.Party;
import us.eunoians.mcrpg.party.PartyMember;
import us.eunoians.mcrpg.players.McRPGPlayer;
import us.eunoians.mcrpg.players.PlayerManager;
import us.eunoians.mcrpg.types.PartyPermissions;
import us.eunoians.mcrpg.types.Skills;

public class Methods {
    private static final TreeMap<Integer, String> map = new TreeMap();

    public static String convertToNumeral(int n) {
        int n2 = map.floorKey(n);
        if (n == n2) {
            return map.get(n);
        }
        return map.get(n2) + Methods.convertToNumeral(n - n2);
    }

    public static int convertToNumber(String string) {
        switch (string) {
            case "I": {
                return 1;
            }
            case "II": {
                return 2;
            }
            case "III": {
                return 3;
            }
            case "IV": {
                return 4;
            }
            case "V": {
                return 5;
            }
        }
        return 0;
    }

    public static boolean isInt(String string) {
        try {
            Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    public static boolean isLong(String string) {
        try {
            Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    public static String color(String string) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)string);
    }

    public static String color(Player player, String string) {
        if (McRPG.getInstance().isPapiEnabled()) {
            string = PlaceholderAPI.setPlaceholders((Player)player, (String)string);
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)string);
    }

    public static int convertMinToTicks(int n) {
        int n2 = n * 1200;
        return n2;
    }

    public static boolean hasPlayerLoggedInBefore(UUID uUID) {
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)uUID);
        return offlinePlayer.isOnline() || offlinePlayer.hasPlayedBefore();
    }

    public static boolean hasPlayerLoggedInBefore(String string) {
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)string);
        return offlinePlayer.isOnline() || offlinePlayer.hasPlayedBefore();
    }

    public static List<String> colorLore(List<String> list) {
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            list.set(i, Methods.color(string));
        }
        return list;
    }

    public static Inventory fillInventory(Inventory inventory, ItemStack itemStack, List<GUIItem> list) {
        for (GUIItem gUIItem : list) {
            if (gUIItem.getItemStack() == null) continue;
            inventory.setItem(gUIItem.getSlot(), gUIItem.getItemStack());
        }
        for (int i = 0; i < inventory.getSize(); ++i) {
            GUIItem gUIItem;
            gUIItem = inventory.getItem(i);
            if (gUIItem != null || itemStack == null) continue;
            inventory.setItem(i, itemStack);
        }
        return inventory;
    }

    public static long getCurrentTimeInMillis() {
        Calendar calendar = Calendar.getInstance();
        return calendar.getTimeInMillis();
    }

    public static long getEndTimeInMillis(int n, int n2) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(n, n2);
        return calendar.getTimeInMillis();
    }

    public static Skills getSkillsItem(Material material, Material material2) {
        switch (material) {
            case DIAMOND_SWORD: 
            case IRON_SWORD: 
            case GOLDEN_SWORD: 
            case STONE_SWORD: 
            case WOODEN_SWORD: {
                return Skills.SWORDS;
            }
            case DIAMOND_PICKAXE: 
            case IRON_PICKAXE: 
            case GOLDEN_PICKAXE: 
            case STONE_PICKAXE: 
            case WOODEN_PICKAXE: {
                return Skills.MINING;
            }
            case DIAMOND_HOE: 
            case IRON_HOE: 
            case GOLDEN_HOE: 
            case STONE_HOE: 
            case WOODEN_HOE: {
                return Skills.HERBALISM;
            }
            case DIAMOND_AXE: 
            case IRON_AXE: 
            case GOLDEN_AXE: 
            case STONE_AXE: 
            case WOODEN_AXE: {
                switch (material2) {
                    case AIR: {
                        return Skills.AXES;
                    }
                }
                return Skills.WOODCUTTING;
            }
            case BOW: {
                return Skills.ARCHERY;
            }
            case DIAMOND_SHOVEL: 
            case IRON_SHOVEL: 
            case GOLDEN_SHOVEL: 
            case STONE_SHOVEL: 
            case WOODEN_SHOVEL: {
                return Skills.EXCAVATION;
            }
            case AIR: {
                return Skills.UNARMED;
            }
        }
        return null;
    }

    public static boolean specialHandDigggingCase(Material material) {
        switch (material) {
            case DIRT: 
            case COARSE_DIRT: 
            case GRASS_BLOCK: 
            case GRASS_PATH: 
            case FARMLAND: 
            case MYCELIUM: 
            case PODZOL: 
            case GRAVEL: 
            case SAND: 
            case RED_SAND: {
                return true;
            }
        }
        return false;
    }

    public static Location lookAt(Location location, Location location2) {
        location = location.clone();
        double d = location2.getX() - location.getX();
        double d2 = location2.getY() - location.getY();
        double d3 = location2.getZ() - location.getZ();
        if (d != 0.0) {
            if (d < 0.0) {
                location.setYaw(4.712389f);
            } else {
                location.setYaw(1.5707964f);
            }
            location.setYaw(location.getYaw() - (float)Math.atan(d3 / d));
        } else if (d3 < 0.0) {
            location.setYaw((float)Math.PI);
        }
        double d4 = Math.sqrt(Math.pow(d, 2.0) + Math.pow(d3, 2.0));
        location.setPitch((float)(-Math.atan(d2 / d4)));
        location.setYaw(-location.getYaw() * 180.0f / (float)Math.PI);
        location.setPitch(location.getPitch() * 180.0f / (float)Math.PI);
        return location;
    }

    public static void setMetadata(Entity entity, String string, Object object) {
        entity.setMetadata(string, (MetadataValue)new FixedMetadataValue((Plugin)McRPG.getInstance(), object));
    }

    public static String locToString(Location location) {
        return location.getBlockX() + ":" + location.getBlockY() + ":" + location.getBlockZ() + ":" + location.getWorld().getName();
    }

    public static String chunkToLoc(Chunk chunk) {
        return chunk.getX() + "@" + chunk.getZ() + "@" + chunk.getWorld().getName();
    }

    public static Location stringToLoc(String string) {
        String[] stringArray = string.split(":");
        World world = Bukkit.getWorld((String)stringArray[3]);
        return new Location(world, (double)Integer.parseInt(stringArray[0]), (double)Integer.parseInt(stringArray[1]), (double)Integer.parseInt(stringArray[2]));
    }

    public static String convertNameToSQL(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (String string2 : string.split("")) {
            if (bl) {
                stringBuilder.append(string2.toLowerCase());
                bl = false;
                continue;
            }
            if (Character.isUpperCase(string2.charAt(0))) {
                stringBuilder.append("_");
            }
            stringBuilder.append(string2.toLowerCase());
        }
        return stringBuilder.toString();
    }

    public static String convertBool(Boolean bl) {
        if (bl.booleanValue()) {
            return "1";
        }
        return "0";
    }

    public static boolean isDiamondFlower(Material material) {
        return material == Material.POPPY || material == Material.DANDELION || material == Material.BLUE_ORCHID || material == Material.LILAC;
    }

    public static boolean isSkillBook(ItemStack itemStack) {
        NBTItem nBTItem = new NBTItem(itemStack);
        return nBTItem.hasKey("UpgradeSkill") != false || nBTItem.hasKey("UnlockSkill") != false;
    }

    public static boolean isArtifact(ItemStack itemStack) {
        if (itemStack == null || itemStack.getType() == Material.AIR) {
            return false;
        }
        NBTItem nBTItem = new NBTItem(itemStack);
        return nBTItem.getBoolean("McRPGArtifact");
    }

    public static int getExpToLevelUp(int n) {
        if (n <= 15) {
            return 2 * n + 7;
        }
        if (n <= 30) {
            return 5 * n - 38;
        }
        return 9 * n - 158;
    }

    public static int getExpAtLevel(int n) {
        if (n <= 16) {
            return (int)(Math.pow(n, 2.0) + (double)(6 * n));
        }
        if (n <= 31) {
            return (int)(2.5 * Math.pow(n, 2.0) - 40.5 * (double)n + 360.0);
        }
        return (int)(4.5 * Math.pow(n, 2.0) - 162.5 * (double)n + 2220.0);
    }

    public static int getPlayerExp(Player player) {
        int n = 0;
        int n2 = player.getLevel();
        n += Methods.getExpAtLevel(n2);
        return n += Math.round((float)Methods.getExpToLevelUp(n2) * player.getExp());
    }

    public static int findHoursDiffFromCurrent(long l) {
        Calendar calendar = Calendar.getInstance();
        long l2 = calendar.getTimeInMillis() - l;
        long l3 = l2 / 1000L;
        long l4 = l3 / 60L;
        long l5 = l4 / 60L;
        return (int)l5;
    }

    public static String getLastLoginDay(OfflinePlayer offlinePlayer) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return simpleDateFormat.format(new Date(offlinePlayer.getLastPlayed()));
    }

    public static boolean canPlayersPVP(Player player, Player player2) {
        if (!McRPG.getInstance().getFileManager().getFile(FileManager.Files.PARTY_CONFIG).getBoolean("PartiesEnabled", false)) {
            return true;
        }
        try {
            Party party;
            McRPGPlayer mcRPGPlayer = PlayerManager.getPlayer(player.getUniqueId());
            McRPGPlayer mcRPGPlayer2 = PlayerManager.getPlayer(player2.getUniqueId());
            if (mcRPGPlayer.getPartyID() != null && mcRPGPlayer2.getPartyID() != null && mcRPGPlayer.getPartyID().equals(mcRPGPlayer2.getPartyID()) && (party = McRPG.getInstance().getPartyManager().getParty(mcRPGPlayer.getPartyID())) != null) {
                PartyMember partyMember = party.getPartyMember(player.getUniqueId());
                PartyMember partyMember2 = party.getPartyMember(player2.getUniqueId());
                if (partyMember != null && partyMember2 != null) {
                    int n = Math.max(partyMember.getPartyRole().getId(), partyMember2.getPartyRole().getId());
                    return n <= party.getRoleForPermission(PartyPermissions.PVP).getId();
                }
            }
            return true;
        }
        catch (McRPGPlayerNotFoundException mcRPGPlayerNotFoundException) {
            return true;
        }
    }

    static {
        map.put(1000, "M");
        map.put(900, "CM");
        map.put(500, "D");
        map.put(400, "CD");
        map.put(100, "C");
        map.put(90, "XC");
        map.put(50, "L");
        map.put(40, "XL");
        map.put(10, "X");
        map.put(9, "IX");
        map.put(5, "V");
        map.put(4, "IV");
        map.put(1, "I");
    }
}

