/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.api.util;

import java.util.UUID;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import us.eunoians.mcrpg.McRPG;
import us.eunoians.mcrpg.api.exceptions.McRPGPlayerNotFoundException;
import us.eunoians.mcrpg.api.leaderboards.LeaderboardManager;
import us.eunoians.mcrpg.api.leaderboards.PlayerLeaderboardData;
import us.eunoians.mcrpg.api.util.Methods;
import us.eunoians.mcrpg.players.McRPGPlayer;
import us.eunoians.mcrpg.players.PlayerManager;
import us.eunoians.mcrpg.types.Skills;

public class McRPGPlaceHolders
extends PlaceholderExpansion {
    public String getIdentifier() {
        return "mcrpg";
    }

    public String getPlugin() {
        return McRPG.getInstance().getName();
    }

    public String getAuthor() {
        return "DiamondDagger590";
    }

    public String getVersion() {
        return "0.2";
    }

    public String onPlaceholderRequest(Player player, String string) {
        McRPGPlayer mcRPGPlayer;
        if (player == null) {
            return null;
        }
        try {
            mcRPGPlayer = PlayerManager.getPlayer(player.getUniqueId());
        }
        catch (McRPGPlayerNotFoundException mcRPGPlayerNotFoundException) {
            mcRPGPlayer = new McRPGPlayer(player.getUniqueId());
        }
        String[] stringArray = string.split("_");
        if (string.equalsIgnoreCase("power_level")) {
            return Integer.toString(mcRPGPlayer.getPowerLevel());
        }
        if (string.contains("_level")) {
            Skills skills = Skills.fromString(stringArray[0]);
            return Integer.toString(mcRPGPlayer.getSkill(skills).getCurrentLevel());
        }
        if (string.contains("_exp_needed")) {
            Skills skills = Skills.fromString(stringArray[0]);
            return Integer.toString(mcRPGPlayer.getSkill(skills).getExpToLevel());
        }
        if (string.contains("_exp")) {
            Skills skills = Skills.fromString(stringArray[0]);
            return Integer.toString(mcRPGPlayer.getSkill(skills).getCurrentExp());
        }
        if (string.contains("player_rank")) {
            LeaderboardManager leaderboardManager = McRPG.getInstance().getLeaderboardManager();
            if (Skills.isSkill(stringArray[2])) {
                return Integer.toString(leaderboardManager.getPlayersSkillRank(player.getUniqueId(), Skills.fromString(stringArray[2])));
            }
            if (stringArray[2].equalsIgnoreCase("power")) {
                return Integer.toString(leaderboardManager.getPlayersPowerRank(player.getUniqueId()));
            }
            return "ERROR";
        }
        if (string.contains("_rank")) {
            LeaderboardManager leaderboardManager = McRPG.getInstance().getLeaderboardManager();
            if (!Methods.isInt(stringArray[2])) {
                return "ERROR";
            }
            int n = Integer.parseInt(stringArray[2]);
            if (stringArray[0].equalsIgnoreCase("power")) {
                PlayerLeaderboardData playerLeaderboardData = leaderboardManager.getPowerPlayer(n);
                return playerLeaderboardData == null ? "N/A" : (string.contains("name") ? Bukkit.getOfflinePlayer((UUID)playerLeaderboardData.getUUID()).getName() : Integer.toString(playerLeaderboardData.getLevel()));
            }
            if (Skills.isSkill(stringArray[0])) {
                Skills skills = Skills.fromString(stringArray[0]);
                PlayerLeaderboardData playerLeaderboardData = leaderboardManager.getSkillPlayer(n, skills);
                return playerLeaderboardData == null ? "N/A" : (string.contains("name") ? Bukkit.getOfflinePlayer((UUID)playerLeaderboardData.getUUID()).getName() : Integer.toString(playerLeaderboardData.getLevel()));
            }
        }
        return "";
    }
}

