/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.api.util;

import java.io.InputStreamReader;
import java.io.Reader;
import org.bukkit.configuration.file.YamlConfiguration;
import us.eunoians.mcrpg.McRPG;

public class HiddenConfig {
    private static HiddenConfig instance;
    private String fileName;
    private YamlConfiguration config;
    private boolean chunkletsEnabled;
    private int conversionRate;
    private boolean useEnchantmentBuffs;
    private int uuidConvertAmount;
    private int mojangRateLimit;
    private long mojangLimitPeriod;

    public HiddenConfig(String string) {
        this.fileName = string;
        this.load();
    }

    public static HiddenConfig getInstance() {
        if (instance == null) {
            instance = new HiddenConfig("hidden.yml");
        }
        return instance;
    }

    public void load() {
        InputStreamReader inputStreamReader = McRPG.getInstance().getResourceAsReader(this.fileName);
        if (inputStreamReader != null) {
            this.config = YamlConfiguration.loadConfiguration((Reader)inputStreamReader);
            this.chunkletsEnabled = this.config.getBoolean("Options.Chunklets", true);
            this.conversionRate = this.config.getInt("Options.ConversionRate", 1);
            this.useEnchantmentBuffs = this.config.getBoolean("Options.EnchantmentBuffs", true);
            this.uuidConvertAmount = this.config.getInt("Options.UUIDConvertAmount", 5);
            this.mojangRateLimit = this.config.getInt("Options.MojangRateLimit", 50000);
            this.mojangLimitPeriod = this.config.getLong("Options.MojangLimitPeriod", 600000L);
        }
    }

    public boolean getChunkletsEnabled() {
        return this.chunkletsEnabled;
    }

    public int getConversionRate() {
        return this.conversionRate;
    }

    public boolean useEnchantmentBuffs() {
        return this.useEnchantmentBuffs;
    }

    public int getUUIDConvertAmount() {
        return this.uuidConvertAmount;
    }

    public int getMojangRateLimit() {
        return this.mojangRateLimit;
    }

    public long getMojangLimitPeriod() {
        return this.mojangLimitPeriod;
    }
}

