/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.api.util;

import de.articdive.enum_to_yaml.EnumConfigurationBuilder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import us.eunoians.mcrpg.McRPG;
import us.eunoians.mcrpg.types.Skills;
import us.eunoians.mcrpg.util.IOUtil;
import us.eunoians.mcrpg.util.configuration.ConfigEnum;
import us.eunoians.mcrpg.util.configuration.LangEnum;
import us.eunoians.mcrpg.util.configuration.SoundEnum;

public class FileManager {
    private Plugin plugin;
    private String prefix = "";
    private Boolean log = false;
    private Map<Files, File> files = new HashMap<Files, File>();
    private List<String> homeFolders = new ArrayList<String>();
    private List<CustomFile> customFiles = new ArrayList<CustomFile>();
    private Map<String, String> autoGenerateFiles = new HashMap<String, String>();
    private Map<Files, FileConfiguration> configurations = new HashMap<Files, FileConfiguration>();
    private static FileManager instance = new FileManager();

    public static FileManager getInstance() {
        return instance;
    }

    public FileManager setup(Plugin plugin) {
        EnumConfigurationBuilder enumConfigurationBuilder = new EnumConfigurationBuilder(new File(McRPG.getInstance().getDataFolder() + File.separator + "config.yml"), ConfigEnum.class);
        EnumConfigurationBuilder enumConfigurationBuilder2 = new EnumConfigurationBuilder(new File(McRPG.getInstance().getDataFolder() + File.separator + "localization" + File.separator + "en.yml"), LangEnum.class);
        EnumConfigurationBuilder enumConfigurationBuilder3 = new EnumConfigurationBuilder(new File(McRPG.getInstance().getDataFolder() + File.separator + "sounds.yml"), SoundEnum.class);
        enumConfigurationBuilder.setWidth(100000);
        enumConfigurationBuilder2.setWidth(100000);
        enumConfigurationBuilder3.setWidth(100000);
        enumConfigurationBuilder.build();
        enumConfigurationBuilder2.build();
        enumConfigurationBuilder3.build();
        this.prefix = "[" + plugin.getName() + "] ";
        this.plugin = plugin;
        if (!plugin.getDataFolder().exists()) {
            plugin.getDataFolder().mkdirs();
        }
        this.files.clear();
        this.customFiles.clear();
        for (Files object : Files.values()) {
            File file = new File(plugin.getDataFolder(), object.getFileLocation());
            if (this.log.booleanValue()) {
                System.out.println(this.prefix + "Loading the " + object.getFileName());
            }
            if (!file.exists()) {
                try {
                    IOUtil.saveResource((McRPG)plugin, object.fileLocation, false);
                }
                catch (Exception exception) {
                    if (this.log.booleanValue()) {
                        System.out.println(this.prefix + "Failed to load " + object.getFileName());
                    }
                    exception.printStackTrace();
                    continue;
                }
            }
            this.files.put(object, file);
            YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
            if (object == Files.SWORDS_CONFIG && yamlConfiguration.getString("DeeperWoundConfig.Item.Material").equals("ROSE_RED")) {
                yamlConfiguration.set("DeeperWoundConfig.Item.Material", (Object)"RED_DYE");
            }
            this.configurations.put(object, (FileConfiguration)yamlConfiguration);
            if (!this.log.booleanValue()) continue;
            System.out.println(this.prefix + "Successfully loaded " + object.getFileName());
        }
        if (this.homeFolders.size() > 0) {
            if (this.log.booleanValue()) {
                System.out.println(this.prefix + "Loading custom files.");
            }
            for (String string : this.homeFolders) {
                File file = new File(plugin.getDataFolder(), "/" + string);
                if (file.exists()) {
                    String[] stringArray = file.list();
                    if (stringArray == null) continue;
                    for (String string2 : stringArray) {
                        CustomFile customFile;
                        if (!string2.endsWith(".yml") || !(customFile = new CustomFile(string2, string, plugin)).exists().booleanValue()) continue;
                        this.customFiles.add(customFile);
                        if (!this.log.booleanValue()) continue;
                        System.out.println(this.prefix + "Loaded new custom file: " + string + "/" + string2 + ".");
                    }
                    continue;
                }
                file.mkdir();
                if (this.log.booleanValue()) {
                    System.out.println(this.prefix + "The folder " + string + "/ was not found so it was created.");
                }
                for (String string3 : this.autoGenerateFiles.keySet()) {
                    if (!this.autoGenerateFiles.get(string3).equalsIgnoreCase(string)) continue;
                    string = this.autoGenerateFiles.get(string3);
                    try {
                        File file2 = new File(plugin.getDataFolder(), string + "/" + string3);
                        InputStream inputStream = this.getClass().getResourceAsStream(string + "/" + string3);
                        this.copyFile(inputStream, file2);
                        if (string3.toLowerCase().endsWith(".yml")) {
                            this.customFiles.add(new CustomFile(string3, string, plugin));
                        }
                        if (!this.log.booleanValue()) continue;
                        System.out.println(this.prefix + "Created new default file: " + string + "/" + string3 + ".");
                    }
                    catch (Exception exception) {
                        if (this.log.booleanValue()) {
                            System.out.println(this.prefix + "Failed to create new default file: " + string + "/" + string3 + "!");
                        }
                        exception.printStackTrace();
                    }
                }
            }
            if (this.log.booleanValue()) {
                System.out.println(this.prefix + "Finished loading custom files.");
            }
        }
        return this;
    }

    public FileManager logInfo(Boolean bl) {
        this.log = bl;
        return this;
    }

    public Boolean isLogging() {
        return this.log;
    }

    public FileManager registerCustomFilesFolder(String string) {
        this.homeFolders.add(string);
        return this;
    }

    public FileManager unregisterCustomFilesFolder(String string) {
        this.homeFolders.remove(string);
        return this;
    }

    public FileManager registerDefaultGenerateFiles(String string, String string2) {
        this.autoGenerateFiles.put(string, string2);
        return this;
    }

    public FileManager unregisterDefaultGenerateFiles(String string) {
        this.autoGenerateFiles.remove(string);
        return this;
    }

    public FileConfiguration getFile(Files files) {
        return this.configurations.get((Object)files);
    }

    public CustomFile getFile(String string) {
        for (CustomFile customFile : this.customFiles) {
            if (!customFile.getName().toLowerCase().equalsIgnoreCase(string.toLowerCase())) continue;
            return customFile;
        }
        return null;
    }

    public void saveFile(Files files) {
        try {
            this.configurations.get((Object)files).save(this.files.get((Object)files));
        }
        catch (IOException iOException) {
            System.out.println(this.prefix + "Could not save " + files.getFileName() + "!");
            iOException.printStackTrace();
        }
    }

    public void saveFile(String string) {
        CustomFile customFile = this.getFile(string);
        if (customFile != null) {
            try {
                customFile.getFile().save(new File(this.plugin.getDataFolder(), customFile.getHomeFolder() + "/" + customFile.getFileName()));
                if (this.log.booleanValue()) {
                    System.out.println(this.prefix + "Successfuly saved the " + customFile.getFileName() + ".");
                }
            }
            catch (Exception exception) {
                System.out.println(this.prefix + "Could not save " + customFile.getFileName() + "!");
                exception.printStackTrace();
            }
        } else if (this.log.booleanValue()) {
            System.out.println(this.prefix + "The file " + string + ".yml could not be found!");
        }
    }

    public Boolean saveFile(CustomFile customFile) {
        return customFile.saveFile();
    }

    public void reloadFile(Files files) {
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)this.files.get((Object)files));
        if (files == Files.SWORDS_CONFIG && yamlConfiguration.getString("DeeperWoundConfig.Item.Material").equals("ROSE_RED")) {
            yamlConfiguration.set("DeeperWoundConfig.Item.Material", (Object)"RED_DYE");
        }
        this.configurations.put(files, (FileConfiguration)yamlConfiguration);
    }

    public void reloadFiles() {
        Arrays.stream(Files.values()).forEach(this::reloadFile);
    }

    public void reloadFile(String string) {
        CustomFile customFile = this.getFile(string);
        if (customFile != null) {
            try {
                customFile.file = (FileConfiguration)YamlConfiguration.loadConfiguration((File)new File(this.plugin.getDataFolder(), "/" + customFile.getHomeFolder() + "/" + customFile.getFileName()));
                if (this.log.booleanValue()) {
                    System.out.println(this.prefix + "Successfully reload the " + customFile.getFileName() + ".");
                }
            }
            catch (Exception exception) {
                System.out.println(this.prefix + "Could not reload the " + customFile.getFileName() + "!");
                exception.printStackTrace();
            }
        } else if (this.log.booleanValue()) {
            System.out.println(this.prefix + "The file " + string + ".yml could not be found!");
        }
    }

    public Boolean reloadFile(CustomFile customFile) {
        return customFile.reloadFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(InputStream inputStream, File file) {
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            int n;
            byte[] byArray = new byte[1024];
            while ((n = inputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    public class CustomFile {
        private String name;
        private Plugin plugin;
        private String fileName;
        private String homeFolder;
        private FileConfiguration file;

        public CustomFile(String string, String string2, Plugin plugin) {
            this.name = string.replace(".yml", "");
            this.plugin = plugin;
            this.fileName = string;
            this.homeFolder = string2;
            if (new File(plugin.getDataFolder(), "/" + string2).exists()) {
                this.file = new File(plugin.getDataFolder(), "/" + string2 + "/" + string).exists() ? YamlConfiguration.loadConfiguration((File)new File(plugin.getDataFolder(), "/" + string2 + "/" + string)) : null;
            } else {
                new File(plugin.getDataFolder(), "/" + string2).mkdir();
                if (FileManager.this.log.booleanValue()) {
                    System.out.println(FileManager.this.prefix + "The folder " + string2 + "/ was not found so it was created.");
                }
                this.file = null;
            }
        }

        public String getName() {
            return this.name;
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getHomeFolder() {
            return this.homeFolder;
        }

        public Plugin getPlugin() {
            return this.plugin;
        }

        public FileConfiguration getFile() {
            return this.file;
        }

        public Boolean exists() {
            return this.file != null;
        }

        public Boolean saveFile() {
            if (this.file != null) {
                try {
                    this.file.save(new File(this.plugin.getDataFolder(), this.homeFolder + "/" + this.fileName));
                    if (FileManager.this.log.booleanValue()) {
                        System.out.println(FileManager.this.prefix + "Successfuly saved the " + this.fileName + ".");
                    }
                    return true;
                }
                catch (Exception exception) {
                    System.out.println(FileManager.this.prefix + "Could not save " + this.fileName + "!");
                    exception.printStackTrace();
                    return false;
                }
            }
            if (FileManager.this.log.booleanValue()) {
                System.out.println(FileManager.this.prefix + "There was a null custom file that could not be found!");
            }
            return false;
        }

        public Boolean reloadFile() {
            if (this.file != null) {
                try {
                    this.file = YamlConfiguration.loadConfiguration((File)new File(this.plugin.getDataFolder(), "/" + this.homeFolder + "/" + this.fileName));
                    if (FileManager.this.log.booleanValue()) {
                        System.out.println(FileManager.this.prefix + "Successfuly reload the " + this.fileName + ".");
                    }
                    return true;
                }
                catch (Exception exception) {
                    System.out.println(FileManager.this.prefix + "Could not reload the " + this.fileName + "!");
                    exception.printStackTrace();
                }
            } else if (FileManager.this.log.booleanValue()) {
                System.out.println(FileManager.this.prefix + "There was a null custom file that was not found!");
            }
            return false;
        }
    }

    public static enum Files {
        ABILITY_OVERRIDE_GUI("abilityoverridegui.yml", "guis/abilityoverridegui.yml"),
        ACCEPT_ABILITY_GUI("acceptabilitygui.yml", "guis/acceptabilitygui.yml"),
        ARCHERY_CONFIG("archery.yml", "skills/archery.yml"),
        ARTIFACT_FILE("artifacts.yml", "artifacts/artifacts.yml"),
        AXES_CONFIG("axes.yml", "skills/axes.yml"),
        BREWING_GUI("brewinggui.yml", "guis/brewinggui.yml"),
        BREWING_ITEMS_CONFIG("potionitems.yml", "skills/potionitems.yml"),
        CONFIG("config.yml", "config.yml"),
        CUSTOM("custom.yml", "localization/custom.yml"),
        EDIT_DEFAULT_ABILITIES_GUI("editdefaultabilitiesgui.yml", "guis/editdefaultabilitiesgui.yml"),
        EDIT_LOADOUT_GUI("editloadoutgui.yml", "guis/editloadoutgui.yml"),
        EDIT_LOADOUT_SELECT_GUI("editloadoutgselectui.yml", "guis/editloadoutselectgui.yml"),
        ENGLISH_FILE("en.yml", "localization/en.yml"),
        EXCAVATION_CONFIG("excavation.yml", "skills/excavation.yml"),
        EXP_PERM_FILE("exp_perms.yml", "exp_perms.yml"),
        FILTER("filter.yml", "filter.yml"),
        FISHING_CONFIG("fishing.yml", "skills/fishing.yml"),
        FISHING_LOOT("fishingloot.yml", "skills/fishingloot.yml"),
        FITNESS_CONFIG("fitness.yml", "skills/fitness.yml"),
        HERBALISM_CONFIG("herbalism.yml", "skills/herbalism.yml"),
        LEVEL_COMMAND("level_commands.yml", "level_commands.yml"),
        LOCATIONS("locations.yml", "data/locations.yml"),
        MAIN_GUI("maingui.yml", "guis/maingui.yml"),
        MINING_CONFIG("mining.yml", "skills/mining.yml"),
        PARTY_CONFIG("party_config.yml", "party_config.yml"),
        PARTY_MAIN_GUI("partymastergui.yml", "guis/parties/partymastergui.yml"),
        PARTY_MEMBER_GUI("partymembergui.yml", "guis/parties/partymembergui.yml"),
        PARTY_ROLE_GUI("partyrolegui.yml", "guis/parties/partyrolegui.yml"),
        PARTY_UPGRADES_GUI("partyupgradesgui.yml", "guis/parties/partyupgradesgui.yml"),
        REDEEM_GUI("redeemgui.yml", "guis/redeemgui.yml"),
        REMOTE_TRANSFER_GUI("remotetransfergui.yml", "guis/remotetransfergui.yml"),
        REPLACE_SKILLS_GUI("replaceskillsgui.yml", "guis/replaceskillsgui.yml"),
        SELECT_REPLACE_SKILLS_GUI("selectreplaceskillsgui.yml", "guis/selectreplaceskillsgui.yml"),
        SETTINGS_GUI("playersettingsgui.yml", "guis/playersettingsgui.yml"),
        SIGN_CONFIG("signdata.yml", "data/signdata.yml"),
        SKILLS_GUI("skillgui.yml", "guis/skillsgui.yml"),
        SORCERY_CONFIG("sorcery.yml", "skills/sorcery.yml"),
        SOUNDS_FILE("sounds.yml", "sounds.yml"),
        SUBSKILL_GUI("subskillgui.yml", "guis/subskillgui.yml"),
        SWORDS_CONFIG("swords.yml", "skills/swords.yml"),
        UNARMED_CONFIG("unarmed.yml", "skills/unarmed.yml"),
        UNLOCK_BOOKS("unlock_books.yml", "skill_books/unlock_books.yml"),
        UPGRADE_BOOKS("upgrade_books.yml", "skill_books/upgrade_books.yml"),
        WOODCUTTING_CONFIG("woodcutting.yml", "skills/woodcutting.yml"),
        WORLDGUARD_CONFIG("wg_support.yml", "wg_support.yml"),
        WORLD_MODIFIER("world_modifier.yml", "world_modifier.yml");

        private String fileName;
        private String fileLocation;

        private Files(String string2, String string3) {
            this.fileName = string2;
            this.fileLocation = string3;
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getFileLocation() {
            return this.fileLocation;
        }

        public FileConfiguration getFile() {
            return FileManager.getInstance().getFile(this);
        }

        public static Files fromString(String string) {
            for (Files files : Files.values()) {
                if (!files.getFileName().replaceAll(".yml", "").equalsIgnoreCase(string)) continue;
                return files;
            }
            return null;
        }

        public void saveFile() {
            FileManager.getInstance().saveFile(this);
        }

        public void reloadFile() {
            FileManager.getInstance().reloadFile(this);
        }

        public static Files getSkillFile(Skills skills) {
            return Files.fromString(skills.getName());
        }
    }
}

