/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.api.leaderboards;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import us.eunoians.mcrpg.McRPG;
import us.eunoians.mcrpg.api.leaderboards.PlayerLeaderboardData;
import us.eunoians.mcrpg.api.leaderboards.PlayerRank;
import us.eunoians.mcrpg.api.util.Methods;
import us.eunoians.mcrpg.players.McRPGPlayer;
import us.eunoians.mcrpg.players.PlayerManager;
import us.eunoians.mcrpg.types.Skills;

public class LeaderboardManager {
    private List<PlayerLeaderboardData> powerLevel;
    private Map<Skills, List<PlayerLeaderboardData>> skillSets;
    private Map<Skills, Map<UUID, Integer>> playerSkillRanks;
    private Map<UUID, Integer> playerPowerMap;
    private static PreparedStatement powerLevelStatement;
    private static Map<Skills, PreparedStatement> skillsPreparedStatementMap;
    private List<UUID> loadingPlayers = new ArrayList<UUID>();
    private long lastTimeRan = 0L;
    private long lastTimeCompleted = 0L;
    private McRPG plugin;
    private static final Calendar cal;

    public LeaderboardManager(McRPG mcRPG) {
        this.plugin = mcRPG;
        try {
            powerLevelStatement = mcRPG.getMcRPGDb().getDatabase().getConnection().prepareStatement("SELECT uuid, power_level FROM mcrpg_player_data ORDER BY power_level DESC ");
            for (Skills skills : Skills.values()) {
                PreparedStatement preparedStatement = mcRPG.getMcRPGDb().getDatabase().getConnection().prepareStatement("SELECT uuid, current_level FROM mcrpg_" + skills.getName().toLowerCase() + "_data ORDER BY current_level DESC ");
                skillsPreparedStatementMap.put(skills, preparedStatement);
            }
            this.startLeaderBoardTask();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    public boolean hasInit() {
        return this.lastTimeCompleted != 0L;
    }

    public List<PlayerLeaderboardData> getPowerPage(int n) {
        if (10 * n - 10 > this.powerLevel.size()) {
            n = 1;
        }
        int n2 = 10 * n <= this.powerLevel.size() ? 10 * n : this.powerLevel.size();
        return this.powerLevel.subList(10 * n - 10, n2);
    }

    public List<PlayerLeaderboardData> getSkillPage(int n, Skills skills) {
        if (10 * n - 10 > this.skillSets.get((Object)skills).size()) {
            n = 1;
        }
        int n2 = 10 * n <= this.skillSets.get((Object)skills).size() ? 10 * n : this.skillSets.get((Object)skills).size();
        return this.skillSets.get((Object)skills).subList(10 * n - 10, n2);
    }

    public int getPlayersPowerRank(UUID uUID) {
        if (this.playerPowerMap != null && this.playerPowerMap.containsKey(uUID)) {
            return this.playerPowerMap.get(uUID);
        }
        return -1;
    }

    public int getPlayersSkillRank(UUID uUID, Skills skills) {
        if (this.playerSkillRanks != null && this.playerSkillRanks.containsKey((Object)skills) && this.playerSkillRanks.get((Object)skills).containsKey(uUID)) {
            return this.playerSkillRanks.get((Object)skills).get(uUID);
        }
        return -1;
    }

    public PlayerLeaderboardData getPowerPlayer(int n) {
        if (this.powerLevel.size() <= n - 1) {
            Bukkit.getLogger().log(Level.WARNING, Methods.color("&cYou are trying to get the #" + n + "s player power level and it does not exist. This may be because you are using a placeholder, if so ignore this"));
            return null;
        }
        return this.powerLevel.get(n - 1);
    }

    public PlayerLeaderboardData getSkillPlayer(int n, Skills skills) {
        if (this.skillSets.get((Object)skills).size() <= n - 1) {
            Bukkit.getLogger().log(Level.WARNING, Methods.color("&cYou are trying to get the #" + n + "s player " + skills.getName() + " level and it does not exist. This may be because you are using a placeholder, if so ignore this"));
            return null;
        }
        return this.skillSets.get((Object)skills).get(n - 1);
    }

    public boolean updateRank(McRPGPlayer mcRPGPlayer, String string) {
        if (string.equalsIgnoreCase("power") || string.equalsIgnoreCase("powerlevel")) {
            if (mcRPGPlayer.getPowerRank() == null || mcRPGPlayer.getPowerRank().getLastTimeUpdated() > this.lastTimeCompleted) {
                this.generatePlayerPowerRank(mcRPGPlayer);
                return true;
            }
            return false;
        }
        if (Skills.isSkill(string)) {
            Skills skills = Skills.fromString(string);
            if (!mcRPGPlayer.getSkillRanks().containsKey((Object)skills) || mcRPGPlayer.getSkillRanks().get((Object)skills).getLastTimeUpdated() > this.lastTimeCompleted) {
                this.generatePlayerSkillRank(mcRPGPlayer, skills);
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean isLoading(McRPGPlayer mcRPGPlayer) {
        return this.loadingPlayers.contains(mcRPGPlayer.getUuid());
    }

    private void generatePlayerPowerRank(final McRPGPlayer mcRPGPlayer) {
        this.loadingPlayers.add(mcRPGPlayer.getUuid());
        new BukkitRunnable(){

            public void run() {
                int n = 0;
                for (PlayerLeaderboardData playerLeaderboardData : LeaderboardManager.this.powerLevel) {
                    ++n;
                    if (!playerLeaderboardData.getUUID().equals(mcRPGPlayer.getUuid())) continue;
                    break;
                }
                if (PlayerManager.isPlayerStored(mcRPGPlayer.getUuid())) {
                    mcRPGPlayer.setPowerRank(new PlayerRank(n, cal.getTimeInMillis()));
                }
                LeaderboardManager.this.loadingPlayers.remove(mcRPGPlayer.getUuid());
            }
        }.runTaskAsynchronously((Plugin)this.plugin);
    }

    private void generatePlayerSkillRank(final McRPGPlayer mcRPGPlayer, final Skills skills) {
        this.loadingPlayers.add(mcRPGPlayer.getUuid());
        new BukkitRunnable(){

            public void run() {
                int n = 0;
                List list = (List)LeaderboardManager.this.skillSets.get((Object)skills);
                for (PlayerLeaderboardData playerLeaderboardData : list) {
                    ++n;
                    if (!playerLeaderboardData.getUUID().equals(mcRPGPlayer.getUuid())) continue;
                    break;
                }
                if (PlayerManager.isPlayerStored(mcRPGPlayer.getUuid())) {
                    mcRPGPlayer.getSkillRanks().put(skills, new PlayerRank(n, cal.getTimeInMillis()));
                }
                LeaderboardManager.this.loadingPlayers.remove(mcRPGPlayer.getUuid());
            }
        }.runTaskAsynchronously((Plugin)this.plugin);
    }

    private void startLeaderBoardTask() {
        new BukkitRunnable(){

            public void run() {
                if (LeaderboardManager.this.lastTimeRan == 0L) {
                    LeaderboardManager.this.updateLeaderboards();
                } else if (LeaderboardManager.this.lastTimeRan < LeaderboardManager.this.lastTimeCompleted) {
                    LeaderboardManager.this.updateLeaderboards();
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 100L, 6000L);
    }

    private void updateLeaderboards() {
        this.lastTimeRan = cal.getTimeInMillis();
        new BukkitRunnable(){

            public void run() {
                ArrayList<PlayerLeaderboardData> arrayList = new ArrayList<PlayerLeaderboardData>();
                HashMap hashMap = new HashMap();
                HashMap hashMap2 = new HashMap();
                HashMap<UUID, Integer> hashMap3 = new HashMap<UUID, Integer>();
                try {
                    ResultSet resultSet = powerLevelStatement.executeQuery();
                    while (resultSet.next()) {
                        UUID object = UUID.fromString(resultSet.getString("uuid"));
                        int n = resultSet.getInt("power_level");
                        arrayList.add(new PlayerLeaderboardData(object, n));
                        hashMap3.put(object, arrayList.size() + 1);
                    }
                    for (Skills skills : Skills.values()) {
                        ResultSet resultSet2 = ((PreparedStatement)skillsPreparedStatementMap.get((Object)skills)).executeQuery();
                        ArrayList<PlayerLeaderboardData> arrayList2 = new ArrayList<PlayerLeaderboardData>();
                        HashMap<UUID, Integer> hashMap4 = new HashMap<UUID, Integer>();
                        while (resultSet2.next()) {
                            UUID uUID = UUID.fromString(resultSet2.getString("uuid"));
                            int n = resultSet2.getInt("current_level");
                            arrayList2.add(new PlayerLeaderboardData(uUID, n));
                            hashMap4.put(uUID, arrayList2.size() + 1);
                        }
                        hashMap2.put(skills, hashMap4);
                        hashMap.put(skills, arrayList2);
                    }
                    LeaderboardManager.this.powerLevel = arrayList;
                    LeaderboardManager.this.skillSets = hashMap;
                    LeaderboardManager.this.playerPowerMap = hashMap3;
                    LeaderboardManager.this.playerSkillRanks = hashMap2;
                    LeaderboardManager.this.lastTimeCompleted = cal.getTimeInMillis();
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
            }
        }.runTaskTimerAsynchronously((Plugin)McRPG.getInstance(), 0L, 6000L);
    }

    static {
        skillsPreparedStatementMap = new HashMap<Skills, PreparedStatement>();
        cal = Calendar.getInstance();
    }
}

