/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.api.leaderboards;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Sign;
import org.bukkit.block.Skull;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import us.eunoians.mcrpg.McRPG;
import us.eunoians.mcrpg.api.leaderboards.PlayerLeaderboardData;
import us.eunoians.mcrpg.api.util.FileManager;
import us.eunoians.mcrpg.api.util.Methods;
import us.eunoians.mcrpg.types.Skills;

public class LeaderboardHeadManager {
    private Map<Location, Integer> powerLevelSigns = new HashMap<Location, Integer>();
    private Map<Location, Location> signToSkullMap = new HashMap<Location, Location>();
    private Map<Location, SkillDataWrapper> skillLevelSigns = new HashMap<Location, SkillDataWrapper>();

    public LeaderboardHeadManager() {
        Location location;
        FileConfiguration fileConfiguration = McRPG.getInstance().getFileManager().getFile(FileManager.Files.SIGN_CONFIG);
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (fileConfiguration.contains("Power")) {
            for (String string : fileConfiguration.getConfigurationSection("Power").getKeys(false)) {
                location = this.stringToLoc(string);
                if (location == null) {
                    arrayList.add(string);
                }
                int n = fileConfiguration.getInt("Power." + string + ".Rank");
                this.powerLevelSigns.put(location, n);
                Location location2 = this.stringToLoc(fileConfiguration.getString("Power." + string + ".Skull"));
                this.signToSkullMap.put(location, location2);
            }
        }
        if (fileConfiguration.contains("Skills")) {
            for (String string : fileConfiguration.getConfigurationSection("Skills").getKeys(false)) {
                location = this.stringToLoc(string);
                if (location == null) {
                    arrayList2.add(string);
                }
                Skills skills = Skills.fromString(fileConfiguration.getString("Skills." + string + ".Skill"));
                int n = fileConfiguration.getInt("Skills." + string + ".Rank");
                SkillDataWrapper skillDataWrapper = new SkillDataWrapper(skills, n);
                this.skillLevelSigns.put(location, skillDataWrapper);
                Location location3 = this.stringToLoc(fileConfiguration.getString("Skills." + string + ".Skull"));
                this.signToSkullMap.put(location, location3);
            }
        }
        for (String string : arrayList) {
            fileConfiguration.set("Power." + string, null);
        }
        for (String string : arrayList2) {
            fileConfiguration.set("Skills." + string, null);
        }
        McRPG.getInstance().getFileManager().saveFile(FileManager.Files.SIGN_CONFIG);
        new BukkitRunnable(){

            public void run() {
                LeaderboardHeadManager.this.updateSigns();
            }
        }.runTaskTimer((Plugin)McRPG.getInstance(), 1200L, 6000L);
    }

    private void updateSigns() {
        OfflinePlayer offlinePlayer;
        int n;
        PlayerLeaderboardData playerLeaderboardData;
        Sign sign;
        Location location;
        ArrayList<Location> arrayList = new ArrayList<Location>();
        ArrayList<Location> arrayList2 = new ArrayList<Location>();
        for (Location location2 : this.powerLevelSigns.keySet()) {
            if (!location2.getChunk().isLoaded() || !(location = this.signToSkullMap.get(location2)).getChunk().isLoaded()) continue;
            if (!(location2.getBlock().getState() instanceof Sign)) {
                Bukkit.getLogger().log(Level.SEVERE, Methods.color("&cThe rank sign placed at " + location2.toString() + " is broken and will be unregistered"));
                arrayList.add(location2);
                this.signToSkullMap.remove(location2);
                continue;
            }
            if (!(location.getBlock().getState() instanceof Skull)) {
                Bukkit.getLogger().log(Level.SEVERE, Methods.color("&cThe player skull placed at " + location.toString() + " is broken and will be unregistered"));
                arrayList.add(location2);
                this.signToSkullMap.remove(location2);
                continue;
            }
            sign = (Sign)location2.getBlock().getState();
            playerLeaderboardData = McRPG.getInstance().getLeaderboardManager().getPowerPlayer(this.powerLevelSigns.get(location2));
            if (playerLeaderboardData == null) continue;
            int n2 = this.powerLevelSigns.get(location2);
            n = playerLeaderboardData.getLevel();
            OfflinePlayer offlinePlayer2 = Bukkit.getOfflinePlayer((UUID)playerLeaderboardData.getUUID());
            sign.setLine(0, Methods.color(McRPG.getInstance().getLangFile().getString("Signs.PowerLeaderboard.Line1").replace("%Rank%", Integer.toString(n2)).replace("%Level%", Integer.toString(n)).replace("%Player%", offlinePlayer2.getName())));
            sign.setLine(1, Methods.color(McRPG.getInstance().getLangFile().getString("Signs.PowerLeaderboard.Line2").replace("%Rank%", Integer.toString(n2)).replace("%Level%", Integer.toString(n)).replace("%Player%", offlinePlayer2.getName())));
            sign.setLine(2, Methods.color(McRPG.getInstance().getLangFile().getString("Signs.PowerLeaderboard.Line3").replace("%Rank%", Integer.toString(n2)).replace("%Level%", Integer.toString(n)).replace("%Player%", offlinePlayer2.getName())));
            sign.setLine(3, Methods.color(McRPG.getInstance().getLangFile().getString("Signs.PowerLeaderboard.Line4").replace("%Rank%", Integer.toString(n2)).replace("%Level%", Integer.toString(n)).replace("%Player%", offlinePlayer2.getName())));
            sign.update();
            offlinePlayer = (Skull)location.getBlock().getState();
            if (offlinePlayer.getOwningPlayer().getUniqueId().equals(playerLeaderboardData.getUUID())) continue;
            offlinePlayer.setOwningPlayer(Bukkit.getOfflinePlayer((UUID)playerLeaderboardData.getUUID()));
            offlinePlayer.update();
        }
        for (Location location2 : this.skillLevelSigns.keySet()) {
            if (!location2.getChunk().isLoaded() || !(location = this.signToSkullMap.get(location2)).getChunk().isLoaded()) continue;
            if (!(location2.getBlock().getState() instanceof Sign)) {
                Bukkit.getLogger().log(Level.SEVERE, Methods.color("&cThe rank sign placed at " + location2.toString() + " is broken and will be unregistered"));
                arrayList2.add(location2);
                this.signToSkullMap.remove(location2);
                continue;
            }
            if (!(location.getBlock().getState() instanceof Skull)) {
                Bukkit.getLogger().log(Level.SEVERE, Methods.color("&cThe player skull placed at " + location.toString() + " is broken and will be unregistered"));
                arrayList2.add(location2);
                this.signToSkullMap.remove(location2);
                continue;
            }
            sign = (Sign)location2.getBlock().getState();
            playerLeaderboardData = McRPG.getInstance().getLeaderboardManager().getSkillPlayer(this.skillLevelSigns.get(location2).rank, this.skillLevelSigns.get(location2).skill);
            if (playerLeaderboardData == null) continue;
            Skills skills = this.skillLevelSigns.get(location2).skill;
            n = this.skillLevelSigns.get(location2).rank;
            int n3 = playerLeaderboardData.getLevel();
            offlinePlayer = Bukkit.getOfflinePlayer((UUID)playerLeaderboardData.getUUID());
            sign.setLine(0, Methods.color(McRPG.getInstance().getLangFile().getString("Signs.PowerLeaderboard.Line1").replace("%Skill%", skills.getDisplayName()).replace("%Rank%", Integer.toString(n)).replace("%Level%", Integer.toString(n3)).replace("%Player%", offlinePlayer.getName())));
            sign.setLine(1, Methods.color(McRPG.getInstance().getLangFile().getString("Signs.PowerLeaderboard.Line2").replace("%Skill%", skills.getDisplayName()).replace("%Rank%", Integer.toString(n)).replace("%Level%", Integer.toString(n3)).replace("%Player%", offlinePlayer.getName())));
            sign.setLine(2, Methods.color(McRPG.getInstance().getLangFile().getString("Signs.PowerLeaderboard.Line3").replace("%Skill%", skills.getDisplayName()).replace("%Rank%", Integer.toString(n)).replace("%Level%", Integer.toString(n3)).replace("%Player%", offlinePlayer.getName())));
            sign.setLine(3, Methods.color(McRPG.getInstance().getLangFile().getString("Signs.PowerLeaderboard.Line4").replace("%Skill%", skills.getDisplayName()).replace("%Rank%", Integer.toString(n)).replace("%Level%", Integer.toString(n3)).replace("%Player%", offlinePlayer.getName())));
            sign.update();
            Skull skull = (Skull)location.getBlock().getState();
            if (skull.getOwningPlayer().getUniqueId().equals(playerLeaderboardData.getUUID())) continue;
            skull.setOwningPlayer(Bukkit.getOfflinePlayer((UUID)playerLeaderboardData.getUUID()));
            skull.update();
        }
        for (Location location2 : arrayList) {
            this.powerLevelSigns.remove(location2);
            this.removeSign("Power." + this.locToString(location2));
        }
        for (Location location2 : arrayList2) {
            this.skillLevelSigns.remove(location2);
            this.removeSign("Skills." + this.locToString(location2));
        }
    }

    public void removeSign(String string) {
        McRPG.getInstance().getFileManager().getFile(FileManager.Files.SIGN_CONFIG).set(string, null);
        McRPG.getInstance().getFileManager().saveFile(FileManager.Files.SIGN_CONFIG);
    }

    public void addPowerSign(Location location, Location location2, int n) {
        this.powerLevelSigns.put(location, n);
        this.signToSkullMap.put(location, location2);
        FileConfiguration fileConfiguration = McRPG.getInstance().getFileManager().getFile(FileManager.Files.SIGN_CONFIG);
        fileConfiguration.set("Power." + this.locToString(location) + ".Rank", (Object)n);
        fileConfiguration.set("Power." + this.locToString(location) + ".Skull", (Object)this.locToString(location2));
        McRPG.getInstance().getFileManager().saveFile(FileManager.Files.SIGN_CONFIG);
    }

    public void addSkillSign(Location location, Location location2, int n, Skills skills) {
        this.skillLevelSigns.put(location, new SkillDataWrapper(skills, n));
        this.signToSkullMap.put(location, location2);
        FileConfiguration fileConfiguration = McRPG.getInstance().getFileManager().getFile(FileManager.Files.SIGN_CONFIG);
        fileConfiguration.set("Skills." + this.locToString(location) + ".Rank", (Object)n);
        fileConfiguration.set("Skills." + this.locToString(location) + ".Skill", (Object)skills.getName());
        fileConfiguration.set("Skills." + this.locToString(location) + ".Skull", (Object)this.locToString(location2));
        McRPG.getInstance().getFileManager().saveFile(FileManager.Files.SIGN_CONFIG);
    }

    private String locToString(Location location) {
        return location.getBlockX() + "&" + location.getBlockY() + "&" + location.getBlockZ() + "&" + location.getWorld().getName();
    }

    private Location stringToLoc(String string) {
        String[] stringArray = string.split("&");
        World world = Bukkit.getWorld((String)stringArray[3]);
        if (world == null) {
            return null;
        }
        return new Location(world, (double)Integer.parseInt(stringArray[0]), (double)Integer.parseInt(stringArray[1]), (double)Integer.parseInt(stringArray[2]));
    }

    private class SkillDataWrapper {
        private Skills skill;
        private int rank;

        public SkillDataWrapper(Skills skills, int n) {
            this.skill = skills;
            this.rank = n;
        }

        public Skills getSkill() {
            return this.skill;
        }

        public int getRank() {
            return this.rank;
        }
    }
}

