/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.api.events.mcrpg.swords;

import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import us.eunoians.mcrpg.McRPG;
import us.eunoians.mcrpg.abilities.swords.Bleed;
import us.eunoians.mcrpg.abilities.swords.BleedPlus;
import us.eunoians.mcrpg.abilities.swords.DeeperWound;
import us.eunoians.mcrpg.abilities.swords.Vampire;
import us.eunoians.mcrpg.api.events.mcrpg.AbilityActivateEvent;
import us.eunoians.mcrpg.api.events.mcrpg.swords.BleedPlusEvent;
import us.eunoians.mcrpg.api.events.mcrpg.swords.DeeperWoundEvent;
import us.eunoians.mcrpg.api.events.mcrpg.swords.VampireEvent;
import us.eunoians.mcrpg.api.util.FileManager;
import us.eunoians.mcrpg.api.util.Methods;
import us.eunoians.mcrpg.players.McRPGPlayer;
import us.eunoians.mcrpg.types.AbilityEventType;
import us.eunoians.mcrpg.types.UnlockedAbilities;

public class BleedEvent
extends AbilityActivateEvent {
    private Entity target;
    private Bleed bleed;
    private int damage;
    private int frequency;
    private int baseDuration;
    private boolean pierceArmour;
    private int minimumHealthAllowed;
    private boolean bleedImmunityEnabled;
    private int bleedImmunityDuration;

    public BleedEvent(McRPGPlayer mcRPGPlayer, LivingEntity livingEntity, Bleed bleed) {
        super(bleed, mcRPGPlayer, AbilityEventType.COMBAT);
        AbilityActivateEvent abilityActivateEvent;
        int n;
        int n2;
        Random random;
        FileConfiguration fileConfiguration = McRPG.getInstance().getFileManager().getFile(FileManager.Files.SWORDS_CONFIG);
        this.bleed = bleed;
        this.isCancelled = bleed.isToggled();
        this.target = livingEntity;
        this.damage = fileConfiguration.getInt("BleedConfig.BaseDamage");
        this.minimumHealthAllowed = fileConfiguration.getInt("BleedConfig.MinimumHealthAllowed");
        this.frequency = fileConfiguration.getInt("BleedConfig.Frequency");
        this.baseDuration = fileConfiguration.getInt("BleedConfig.BaseDuration");
        this.pierceArmour = fileConfiguration.getBoolean("BleedConfig.BleedPierceArmour");
        this.bleedImmunityEnabled = fileConfiguration.getBoolean("BleedConfig.BleedImmunityEnabled");
        this.bleedImmunityDuration = fileConfiguration.getInt("BleedConfig.BleedImmunityDuration");
        if (UnlockedAbilities.DEEPER_WOUND.isEnabled() && mcRPGPlayer.doesPlayerHaveAbilityInLoadout(UnlockedAbilities.DEEPER_WOUND)) {
            random = new Random();
            n2 = random.nextInt(10000);
            n = (int)fileConfiguration.getDouble("DeeperWoundConfig.Tier" + Methods.convertToNumeral(mcRPGPlayer.getBaseAbility(UnlockedAbilities.DEEPER_WOUND).getCurrentTier()) + ".ActivationChance") * 100;
            if (n >= n2) {
                abilityActivateEvent = new DeeperWoundEvent(mcRPGPlayer, (DeeperWound)mcRPGPlayer.getBaseAbility(UnlockedAbilities.DEEPER_WOUND));
                Bukkit.getPluginManager().callEvent((Event)abilityActivateEvent);
                if (!abilityActivateEvent.isCancelled()) {
                    this.baseDuration += ((DeeperWoundEvent)abilityActivateEvent).getDurationBoost();
                }
            }
        }
        if (UnlockedAbilities.BLEED_PLUS.isEnabled() && mcRPGPlayer.doesPlayerHaveAbilityInLoadout(UnlockedAbilities.BLEED_PLUS)) {
            random = new Random();
            n2 = random.nextInt(10000);
            n = (int)fileConfiguration.getDouble("Bleed+Config.Tier" + Methods.convertToNumeral(mcRPGPlayer.getBaseAbility(UnlockedAbilities.BLEED_PLUS).getCurrentTier()) + ".ActivationChance") * 100;
            if (n >= n2) {
                abilityActivateEvent = new BleedPlusEvent(mcRPGPlayer, (BleedPlus)mcRPGPlayer.getBaseAbility(UnlockedAbilities.BLEED_PLUS));
                Bukkit.getPluginManager().callEvent((Event)abilityActivateEvent);
                if (!abilityActivateEvent.isCancelled()) {
                    this.damage += ((BleedPlusEvent)abilityActivateEvent).getDamageBoost();
                }
            }
        }
        if (UnlockedAbilities.VAMPIRE.isEnabled() && mcRPGPlayer.doesPlayerHaveAbilityInLoadout(UnlockedAbilities.VAMPIRE) && livingEntity instanceof Player) {
            random = new Random();
            n2 = random.nextInt(10000);
            n = (int)fileConfiguration.getDouble("VampireConfig.Tier" + Methods.convertToNumeral(mcRPGPlayer.getBaseAbility(UnlockedAbilities.VAMPIRE).getCurrentTier()) + ".ActivationChance") * 100;
            if (n >= n2) {
                double d;
                abilityActivateEvent = new VampireEvent(mcRPGPlayer, (Vampire)mcRPGPlayer.getBaseAbility(UnlockedAbilities.VAMPIRE));
                Bukkit.getPluginManager().callEvent((Event)abilityActivateEvent);
                if (!abilityActivateEvent.isCancelled() && (d = mcRPGPlayer.getPlayer().getHealth()) < 20.0) {
                    if (d + (double)((VampireEvent)abilityActivateEvent).getAmountToHeal() > 20.0) {
                        mcRPGPlayer.getPlayer().setHealth(20.0);
                    } else {
                        mcRPGPlayer.getPlayer().setHealth(d + (double)((VampireEvent)abilityActivateEvent).getAmountToHeal());
                    }
                }
            }
        }
    }

    public Entity getTarget() {
        return this.target;
    }

    public Bleed getBleed() {
        return this.bleed;
    }

    public int getDamage() {
        return this.damage;
    }

    public void setDamage(int n) {
        this.damage = n;
    }

    public int getFrequency() {
        return this.frequency;
    }

    public void setFrequency(int n) {
        this.frequency = n;
    }

    public int getBaseDuration() {
        return this.baseDuration;
    }

    public void setBaseDuration(int n) {
        this.baseDuration = n;
    }

    public boolean isPierceArmour() {
        return this.pierceArmour;
    }

    public void setPierceArmour(boolean bl) {
        this.pierceArmour = bl;
    }

    public int getMinimumHealthAllowed() {
        return this.minimumHealthAllowed;
    }

    public boolean isBleedImmunityEnabled() {
        return this.bleedImmunityEnabled;
    }

    public void setBleedImmunityEnabled(boolean bl) {
        this.bleedImmunityEnabled = bl;
    }

    public int getBleedImmunityDuration() {
        return this.bleedImmunityDuration;
    }

    public void setBleedImmunityDuration(int n) {
        this.bleedImmunityDuration = n;
    }
}

