/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.api.displays;

import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.ScoreboardManager;
import us.eunoians.mcrpg.McRPG;
import us.eunoians.mcrpg.api.displays.DecayableDisplay;
import us.eunoians.mcrpg.api.displays.GenericDisplay;
import us.eunoians.mcrpg.api.displays.LeaderboardDisplay;
import us.eunoians.mcrpg.api.displays.ScoreboardBase;
import us.eunoians.mcrpg.api.leaderboards.LeaderboardManager;
import us.eunoians.mcrpg.api.leaderboards.PlayerLeaderboardData;
import us.eunoians.mcrpg.api.util.Methods;
import us.eunoians.mcrpg.players.McRPGPlayer;
import us.eunoians.mcrpg.types.DisplayType;
import us.eunoians.mcrpg.types.LeaderboardType;
import us.eunoians.mcrpg.types.Skills;

public class LeaderboardScoreboard
extends GenericDisplay
implements ScoreboardBase,
LeaderboardDisplay,
DecayableDisplay {
    private Scoreboard oldBoard;
    private static ScoreboardManager manager = Bukkit.getScoreboardManager();
    private Scoreboard board;
    private LeaderboardType leaderboardType;
    private List<PlayerLeaderboardData> storedData;
    private Skills storedSkill;
    private int page;
    private int displayTime;
    private BukkitTask endTask;

    public LeaderboardScoreboard(McRPGPlayer mcRPGPlayer, LeaderboardType leaderboardType, int n, int n2) {
        super(mcRPGPlayer, DisplayType.SCOREBOARD);
        this.leaderboardType = leaderboardType;
        this.displayTime = n;
        this.page = n2;
        this.createScoreboard();
        this.updateEndTime();
    }

    public LeaderboardScoreboard(McRPGPlayer mcRPGPlayer, LeaderboardType leaderboardType, Skills skills, int n, int n2) {
        super(mcRPGPlayer, DisplayType.SCOREBOARD);
        this.leaderboardType = leaderboardType;
        this.displayTime = n;
        this.storedSkill = skills;
        this.page = n2;
        this.createScoreboard();
        this.updateEndTime();
    }

    public LeaderboardScoreboard(McRPGPlayer mcRPGPlayer, LeaderboardType leaderboardType, Scoreboard scoreboard, int n, int n2) {
        super(mcRPGPlayer, DisplayType.SCOREBOARD);
        this.leaderboardType = leaderboardType;
        this.displayTime = n;
        this.oldBoard = scoreboard;
        this.page = n2;
        this.createScoreboard();
        this.updateEndTime();
    }

    public LeaderboardScoreboard(McRPGPlayer mcRPGPlayer, LeaderboardType leaderboardType, Scoreboard scoreboard, Skills skills, int n, int n2) {
        super(mcRPGPlayer, DisplayType.SCOREBOARD);
        this.leaderboardType = leaderboardType;
        this.displayTime = n;
        this.storedSkill = skills;
        this.oldBoard = scoreboard;
        this.page = n2;
        this.createScoreboard();
        this.updateEndTime();
    }

    @Override
    public void nextPage() {
        ++this.page;
        this.createScoreboard();
    }

    @Override
    public void previousPage() {
        this.page = this.page - 1 >= 0 ? this.page - 1 : 0;
        this.createScoreboard();
    }

    private void createScoreboard() {
        int n;
        FileConfiguration fileConfiguration = McRPG.getInstance().getConfig();
        this.board = manager.getNewScoreboard();
        Objective objective = this.board.registerNewObjective("mcrpg", "dummy");
        LeaderboardManager leaderboardManager = McRPG.getInstance().getLeaderboardManager();
        int n2 = n = 1 + (this.page - 1) * 10;
        if (this.leaderboardType == LeaderboardType.POWER) {
            this.storedData = leaderboardManager.getPowerPage(this.page);
            for (PlayerLeaderboardData playerLeaderboardData : this.storedData) {
                String string;
                String string2 = string = playerLeaderboardData.getUUID().equals(this.player.getUuid()) ? "&6--You--" : Bukkit.getOfflinePlayer((UUID)playerLeaderboardData.getUUID()).getName();
                if (string == null) {
                    string = "N/A Player #" + n;
                }
                objective.getScore(Methods.color(string)).setScore(playerLeaderboardData.getLevel());
                ++n;
            }
        } else {
            this.storedData = leaderboardManager.getSkillPage(this.page, this.storedSkill);
            for (PlayerLeaderboardData playerLeaderboardData : this.storedData) {
                String string;
                String string3 = string = playerLeaderboardData.getUUID().equals(this.player.getUuid()) ? "&6--You--" : Bukkit.getOfflinePlayer((UUID)playerLeaderboardData.getUUID()).getName();
                if (string == null) {
                    string = "N/A Player #" + n;
                }
                objective.getScore(Methods.color(string)).setScore(playerLeaderboardData.getLevel());
                ++n;
            }
        }
        Object object = Methods.color("&a%Type% (" + n2 + "-" + (n - 1) + ")");
        objective.setDisplaySlot(DisplaySlot.SIDEBAR);
        object = this.leaderboardType == LeaderboardType.POWER ? ((String)object).replace("%Type%", "Power") : ((String)object).replace("%Type%", this.storedSkill.getDisplayName());
        objective.setDisplayName(Methods.color(this.player.getPlayer(), (String)object));
    }

    @Override
    public void cancel() {
        if (this.hasOldScoreBoard()) {
            this.player.getPlayer().setScoreboard(this.oldBoard);
            return;
        }
        this.board = manager.getNewScoreboard();
        this.player.getPlayer().setScoreboard(this.board);
    }

    @Override
    public boolean hasOldScoreBoard() {
        return this.oldBoard != null;
    }

    @Override
    public Scoreboard getOldScoreBoard() {
        return this.oldBoard;
    }

    @Override
    public int getDisplayTime() {
        return this.displayTime;
    }

    private void updateEndTime() {
        if (this.endTask != null) {
            this.endTask.cancel();
        }
        this.endTask = new BukkitRunnable(){

            public void run() {
                McRPG.getInstance().getDisplayManager().removePlayersDisplay(LeaderboardScoreboard.this.player.getUuid());
            }
        }.runTaskLater((Plugin)McRPG.getInstance(), (long)(this.displayTime * 20));
    }

    public Scoreboard getBoard() {
        return this.board;
    }

    @Override
    public LeaderboardType getLeaderboardType() {
        return this.leaderboardType;
    }

    @Override
    public List<PlayerLeaderboardData> getStoredData() {
        return this.storedData;
    }

    @Override
    public Skills getStoredSkill() {
        return this.storedSkill;
    }

    @Override
    public int getPage() {
        return this.page;
    }
}

