/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.api.displays;

import org.bukkit.scoreboard.Scoreboard;
import us.eunoians.mcrpg.api.displays.DecayableExpActionBar;
import us.eunoians.mcrpg.api.displays.DecayableExpBossBar;
import us.eunoians.mcrpg.api.displays.DecayableExpScoreboard;
import us.eunoians.mcrpg.api.displays.ExpActionBar;
import us.eunoians.mcrpg.api.displays.ExpBossbarDisplay;
import us.eunoians.mcrpg.api.displays.ExpScoreboardDisplay;
import us.eunoians.mcrpg.api.displays.GenericDisplay;
import us.eunoians.mcrpg.players.McRPGPlayer;
import us.eunoians.mcrpg.types.DisplayType;
import us.eunoians.mcrpg.types.Skills;

public class ExpDisplayFactory {
    public static GenericDisplay createDisplay(DisplayType displayType, McRPGPlayer mcRPGPlayer, Skills skills) {
        if (displayType == DisplayType.ACTION_BAR) {
            return new ExpActionBar(mcRPGPlayer, skills);
        }
        if (displayType == DisplayType.BOSS_BAR) {
            return new ExpBossbarDisplay(mcRPGPlayer, skills);
        }
        if (displayType == DisplayType.SCOREBOARD) {
            return new ExpScoreboardDisplay(mcRPGPlayer, skills, mcRPGPlayer.getPlayer().getScoreboard());
        }
        return null;
    }

    public static GenericDisplay createDisplay(DisplayType displayType, McRPGPlayer mcRPGPlayer, Skills skills, int n) {
        if (displayType == DisplayType.ACTION_BAR) {
            return new DecayableExpActionBar(mcRPGPlayer, skills);
        }
        if (displayType == DisplayType.BOSS_BAR) {
            return new DecayableExpBossBar(mcRPGPlayer, skills, n);
        }
        if (displayType == DisplayType.SCOREBOARD) {
            return new DecayableExpScoreboard(mcRPGPlayer, skills, mcRPGPlayer.getPlayer().getScoreboard(), n);
        }
        return null;
    }

    public static GenericDisplay createDisplay(McRPGPlayer mcRPGPlayer, Skills skills, Scoreboard scoreboard) {
        return new ExpScoreboardDisplay(mcRPGPlayer, skills, scoreboard);
    }

    public static GenericDisplay createDisplay(McRPGPlayer mcRPGPlayer, Skills skills, Scoreboard scoreboard, int n) {
        return new DecayableExpScoreboard(mcRPGPlayer, skills, scoreboard, n);
    }
}

