/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.api.displays;

import org.bukkit.Bukkit;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import us.eunoians.mcrpg.McRPG;
import us.eunoians.mcrpg.api.displays.BossbarBase;
import us.eunoians.mcrpg.api.displays.ExpDisplayType;
import us.eunoians.mcrpg.api.displays.GenericDisplay;
import us.eunoians.mcrpg.api.util.Methods;
import us.eunoians.mcrpg.players.McRPGPlayer;
import us.eunoians.mcrpg.skills.Skill;
import us.eunoians.mcrpg.types.BarColor;
import us.eunoians.mcrpg.types.DisplayType;
import us.eunoians.mcrpg.types.Skills;
import us.eunoians.mcrpg.util.Parser;

public class ExpBossbarDisplay
extends GenericDisplay
implements BossbarBase,
ExpDisplayType {
    private BossBar expBar;
    private Skills skill;

    public ExpBossbarDisplay(McRPGPlayer mcRPGPlayer, Skills skills) {
        super(mcRPGPlayer, DisplayType.BOSS_BAR);
        this.skill = skills;
        this.createBossBar();
    }

    @Override
    public void createBossBar() {
        Skill skill = this.player.getSkill(this.skill);
        String string = Methods.color(this.player.getPlayer(), McRPG.getInstance().getConfig().getString("DisplayConfig.BossBar.DisplayName").replace("%Skill%", this.skill.getDisplayName()).replace("%Exp_To_Level%", Integer.toString(skill.getExpToLevel() - skill.getCurrentExp())).replace("%Current_Level%", Integer.toString(skill.getCurrentLevel())));
        BarStyle barStyle = BarStyle.SEGMENTED_10;
        org.bukkit.boss.BarColor barColor = BarColor.fromString(McRPG.getInstance().getConfig().getString("DisplayConfig.BossBar.Color." + this.skill.getName()));
        Parser parser = this.skill.getExpEquation();
        parser.setVariable("skill_level", skill.getCurrentLevel());
        parser.setVariable("power_level", this.player.getPowerLevel());
        double d = (double)skill.getCurrentExp() / parser.getValue();
        if (d >= 1.0) {
            d = 0.9;
        } else if (d < 0.0) {
            d = 0.0;
        }
        this.expBar = Bukkit.createBossBar((String)string, (org.bukkit.boss.BarColor)barColor, (BarStyle)barStyle, (BarFlag[])new BarFlag[0]);
        this.expBar.setProgress(d);
        this.expBar.setVisible(true);
        this.expBar.addPlayer(this.player.getPlayer());
    }

    @Override
    public void sendUpdate(int n, int n2, int n3, int n4) {
        Skill skill = this.player.getSkill(this.skill);
        Parser parser = this.skill.getExpEquation();
        parser.setVariable("skill_level", skill.getCurrentLevel());
        parser.setVariable("power_level", this.player.getPowerLevel());
        double d = (double)skill.getCurrentExp() / parser.getValue();
        if (d >= 1.0) {
            d = 0.9;
        } else if (d < 0.0) {
            d = 0.0;
        }
        this.expBar.setProgress(d);
        this.expBar.setTitle(Methods.color(this.player.getPlayer(), McRPG.getInstance().getConfig().getString("DisplayConfig.BossBar.DisplayName").replace("%Skill%", this.skill.getDisplayName()).replace("%Exp_Gained%", Integer.toString(n4)).replace("%Exp_To_Level%", Integer.toString(skill.getExpToLevel() - skill.getCurrentExp())).replace("%Current_Level%", Integer.toString(n3))));
    }

    @Override
    public void cancel() {
        this.expBar.removeAll();
    }

    @Override
    public BossBar getBossbar() {
        return this.expBar;
    }

    @Override
    public Skills getSkill() {
        return this.skill;
    }
}

