/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.api.displays;

import java.util.ArrayList;
import java.util.UUID;
import org.bukkit.entity.Player;
import us.eunoians.mcrpg.api.displays.GenericDisplay;

public class DisplayManager {
    private static DisplayManager instance = new DisplayManager();
    private ArrayList<GenericDisplay> displays = new ArrayList();

    public GenericDisplay getDisplay(Player player) {
        return this.displays.stream().filter(genericDisplay -> genericDisplay.getPlayer().getUuid().equals(player.getUniqueId())).findFirst().orElse(null);
    }

    public GenericDisplay getDisplay(UUID uUID) {
        return this.displays.stream().filter(genericDisplay -> genericDisplay.getPlayer().getUuid().equals(uUID)).findFirst().orElse(null);
    }

    public void setGenericDisplay(GenericDisplay genericDisplay) {
        GenericDisplay genericDisplay2 = this.getDisplay(genericDisplay.player.getPlayer());
        if (genericDisplay2 != null) {
            this.displays.remove(genericDisplay2);
        }
        this.displays.add(genericDisplay);
    }

    public void removePlayersDisplay(Player player) {
        GenericDisplay genericDisplay = this.getDisplay(player);
        if (genericDisplay != null) {
            genericDisplay.cancel();
            this.displays.remove(genericDisplay);
        }
    }

    public void removePlayersDisplay(UUID uUID) {
        GenericDisplay genericDisplay = this.getDisplay(uUID);
        if (genericDisplay != null) {
            genericDisplay.cancel();
            this.displays.remove(genericDisplay);
        }
    }

    public boolean doesPlayerHaveDisplay(Player player) {
        return this.displays.stream().anyMatch(genericDisplay -> genericDisplay.getPlayer().getUuid().equals(player.getUniqueId()));
    }

    public static DisplayManager getInstance() {
        return instance;
    }
}

