/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.api.displays;

import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.ScoreboardManager;
import us.eunoians.mcrpg.McRPG;
import us.eunoians.mcrpg.api.displays.DecayableDisplay;
import us.eunoians.mcrpg.api.displays.ExpDisplayType;
import us.eunoians.mcrpg.api.displays.GenericDisplay;
import us.eunoians.mcrpg.api.displays.ScoreboardBase;
import us.eunoians.mcrpg.api.util.Methods;
import us.eunoians.mcrpg.players.McRPGPlayer;
import us.eunoians.mcrpg.skills.Skill;
import us.eunoians.mcrpg.types.DisplayType;
import us.eunoians.mcrpg.types.Skills;

public class DecayableExpScoreboard
extends GenericDisplay
implements ScoreboardBase,
ExpDisplayType,
DecayableDisplay {
    private Skills skill;
    private Scoreboard oldBoard;
    private static ScoreboardManager manager = Bukkit.getScoreboardManager();
    private Scoreboard board;
    private int displayTime;
    private BukkitTask endTask;

    public DecayableExpScoreboard(McRPGPlayer mcRPGPlayer, Skills skills, int n) {
        super(mcRPGPlayer, DisplayType.SCOREBOARD);
        this.skill = skills;
        this.displayTime = n;
        this.createScoreboard();
        this.updateEndTime();
    }

    public DecayableExpScoreboard(McRPGPlayer mcRPGPlayer, Skills skills, Scoreboard scoreboard, int n) {
        super(mcRPGPlayer, DisplayType.SCOREBOARD);
        this.skill = skills;
        this.oldBoard = scoreboard;
        this.displayTime = n;
        this.createScoreboard();
        this.updateEndTime();
    }

    private void createScoreboard() {
        FileConfiguration fileConfiguration = McRPG.getInstance().getConfig();
        this.board = manager.getNewScoreboard();
        Objective objective = this.board.registerNewObjective("mcrpg", "dummy");
        objective.setDisplayName(Methods.color(this.player.getPlayer(), fileConfiguration.getString("DisplayConfig.Scoreboard.DisplayName").replaceAll("%Player%", this.player.getPlayer().getDisplayName()).replaceAll("%Skill%", this.skill.getDisplayName())));
        Skill skill = this.player.getSkill(this.skill);
        fileConfiguration.getConfigurationSection("DisplayConfig.Scoreboard.Lines").getKeys(false).stream().forEach(string -> {
            String string2 = Methods.color(this.player.getPlayer(), fileConfiguration.getString("DisplayConfig.Scoreboard.Lines." + string));
            objective.getScore(string2).setScore(0);
        });
        this.sendUpdate(skill.getCurrentExp(), skill.getExpToLevel(), skill.getCurrentLevel(), 0);
    }

    @Override
    public void sendUpdate(int n, int n2, int n3, int n4) {
        FileConfiguration fileConfiguration = McRPG.getInstance().getConfig();
        Objective objective = this.board.getObjective("mcrpg");
        objective.getScore(Methods.color(this.player.getPlayer(), fileConfiguration.getString("DisplayConfig.Scoreboard.Lines.CurrentExp"))).setScore(n);
        objective.getScore(Methods.color(this.player.getPlayer(), fileConfiguration.getString("DisplayConfig.Scoreboard.Lines.ExpNeeded"))).setScore(n2 - n);
        objective.getScore(Methods.color(this.player.getPlayer(), fileConfiguration.getString("DisplayConfig.Scoreboard.Lines.CurrentLevel"))).setScore(n3);
        objective.setDisplaySlot(DisplaySlot.SIDEBAR);
        this.updateEndTime();
    }

    @Override
    public void cancel() {
        if (this.endTask != null) {
            this.endTask.cancel();
        }
        if (this.hasOldScoreBoard()) {
            this.player.getPlayer().setScoreboard(this.oldBoard);
            return;
        }
        this.board = manager.getNewScoreboard();
        this.player.getPlayer().setScoreboard(this.board);
    }

    @Override
    public boolean hasOldScoreBoard() {
        return this.oldBoard != null;
    }

    @Override
    public Scoreboard getOldScoreBoard() {
        return this.oldBoard;
    }

    @Override
    public int getDisplayTime() {
        return this.displayTime;
    }

    private void updateEndTime() {
        if (this.endTask != null) {
            this.endTask.cancel();
        }
        this.endTask = new BukkitRunnable(){

            public void run() {
                McRPG.getInstance().getDisplayManager().removePlayersDisplay(DecayableExpScoreboard.this.player.getUuid());
            }
        }.runTaskLater((Plugin)McRPG.getInstance(), (long)(this.displayTime * 20));
    }

    @Override
    public Skills getSkill() {
        return this.skill;
    }

    public Scoreboard getBoard() {
        return this.board;
    }
}

