/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.abilities.mining;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import us.eunoians.mcrpg.McRPG;
import us.eunoians.mcrpg.abilities.BaseAbility;
import us.eunoians.mcrpg.api.util.FileManager;
import us.eunoians.mcrpg.api.util.Methods;
import us.eunoians.mcrpg.api.util.RemoteTransferTracker;
import us.eunoians.mcrpg.types.UnlockedAbilities;

public class RemoteTransfer
extends BaseAbility {
    private Location linkedChestLocation;
    private HashMap<Material, Boolean> itemsToSync = new HashMap();

    public RemoteTransfer(UUID uUID, boolean bl, int n) {
        super(UnlockedAbilities.REMOTE_TRANSFER, bl, n);
        File file;
        YamlConfiguration yamlConfiguration;
        if (this.isUnlocked()) {
            this.updateBlocks();
        }
        if (RemoteTransferTracker.isTracked(uUID)) {
            this.linkedChestLocation = RemoteTransferTracker.getLocation(uUID);
        }
        if ((yamlConfiguration = YamlConfiguration.loadConfiguration((File)(file = new File(McRPG.getInstance().getDataFolder(), File.separator + "remote_transfer_data" + File.separator + uUID.toString() + ".yml")))).contains("RemoteTransferBlocks")) {
            for (String string : yamlConfiguration.getConfigurationSection("RemoteTransferBlocks").getKeys(false)) {
                this.itemsToSync.put(Material.getMaterial((String)string), yamlConfiguration.getBoolean("RemoteTransferBlocks." + string));
            }
        }
    }

    public void updateBlocks() {
        FileConfiguration fileConfiguration = McRPG.getInstance().getFileManager().getFile(FileManager.Files.MINING_CONFIG);
        for (String string : fileConfiguration.getStringList("RemoteTransferConfig.Tier" + Methods.convertToNumeral(this.getCurrentTier()) + ".Categories")) {
            List list = fileConfiguration.getStringList("RemoteTransferConfig.Categories." + string).stream().map(Material::getMaterial).collect(Collectors.toList());
            for (Material material : list) {
                if (this.itemsToSync.containsKey(material)) continue;
                this.itemsToSync.put(material, true);
            }
        }
    }

    public boolean isAbilityLinked() {
        return this.linkedChestLocation != null;
    }

    public Location getLinkedChestLocation() {
        return this.linkedChestLocation;
    }

    public void setLinkedChestLocation(Location location) {
        this.linkedChestLocation = location;
    }

    public HashMap<Material, Boolean> getItemsToSync() {
        return this.itemsToSync;
    }
}

