/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg;

import com.cyr1en.javen.Javen;
import com.cyr1en.javen.annotation.Lib;
import com.cyr1en.javen.annotation.Libs;
import com.google.common.base.Charsets;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import us.eunoians.mcrpg.api.displays.DisplayManager;
import us.eunoians.mcrpg.api.leaderboards.LeaderboardHeadManager;
import us.eunoians.mcrpg.api.leaderboards.LeaderboardManager;
import us.eunoians.mcrpg.api.util.BuriedTreasureData;
import us.eunoians.mcrpg.api.util.DiamondFlowersData;
import us.eunoians.mcrpg.api.util.FileManager;
import us.eunoians.mcrpg.api.util.HiddenConfig;
import us.eunoians.mcrpg.api.util.McRPGPlaceHolders;
import us.eunoians.mcrpg.api.util.RemoteTransferTracker;
import us.eunoians.mcrpg.api.util.WorldModifierManager;
import us.eunoians.mcrpg.api.util.artifacts.ArtifactManager;
import us.eunoians.mcrpg.api.util.books.BookManager;
import us.eunoians.mcrpg.api.util.brewing.BrewingStandManager;
import us.eunoians.mcrpg.api.util.brewing.PotionRecipeManager;
import us.eunoians.mcrpg.api.util.exp.ExpPermissionManager;
import us.eunoians.mcrpg.api.util.fishing.FishingItemManager;
import us.eunoians.mcrpg.api.util.levelcmds.LevelCommandManager;
import us.eunoians.mcrpg.bukkit.Metrics;
import us.eunoians.mcrpg.commands.McAdmin;
import us.eunoians.mcrpg.commands.McConvert;
import us.eunoians.mcrpg.commands.McDisplay;
import us.eunoians.mcrpg.commands.McExp;
import us.eunoians.mcrpg.commands.McHelp;
import us.eunoians.mcrpg.commands.McLink;
import us.eunoians.mcrpg.commands.McParty;
import us.eunoians.mcrpg.commands.McRPGStub;
import us.eunoians.mcrpg.commands.McRank;
import us.eunoians.mcrpg.commands.McRedeem;
import us.eunoians.mcrpg.commands.McSpy;
import us.eunoians.mcrpg.commands.McUnlink;
import us.eunoians.mcrpg.commands.prompts.McAdminPrompt;
import us.eunoians.mcrpg.commands.prompts.McDisplayPrompt;
import us.eunoians.mcrpg.commands.prompts.McExpPrompt;
import us.eunoians.mcrpg.commands.prompts.McHelpPrompt;
import us.eunoians.mcrpg.commands.prompts.McPartyPrompt;
import us.eunoians.mcrpg.commands.prompts.McRankPrompt;
import us.eunoians.mcrpg.commands.prompts.McRedeemPrompt;
import us.eunoians.mcrpg.database.McRPGDb;
import us.eunoians.mcrpg.events.external.sickle.Sickle;
import us.eunoians.mcrpg.events.mcrpg.AbilityActivate;
import us.eunoians.mcrpg.events.mcrpg.AbilityUnlock;
import us.eunoians.mcrpg.events.mcrpg.AbilityUpgrade;
import us.eunoians.mcrpg.events.mcrpg.BleedHandler;
import us.eunoians.mcrpg.events.mcrpg.DisarmHandler;
import us.eunoians.mcrpg.events.mcrpg.LoadoutAdd;
import us.eunoians.mcrpg.events.mcrpg.McRPGExpGain;
import us.eunoians.mcrpg.events.mcrpg.McRPGPlayerLevelChange;
import us.eunoians.mcrpg.events.mcrpg.PartyLevelUp;
import us.eunoians.mcrpg.events.vanilla.ArrowHitEvent;
import us.eunoians.mcrpg.events.vanilla.BreakEvent;
import us.eunoians.mcrpg.events.vanilla.ChatEvent;
import us.eunoians.mcrpg.events.vanilla.CheckReadyEvent;
import us.eunoians.mcrpg.events.vanilla.DeathEvent;
import us.eunoians.mcrpg.events.vanilla.DropItemEvent;
import us.eunoians.mcrpg.events.vanilla.EnchantingEvent;
import us.eunoians.mcrpg.events.vanilla.EntityDeathEvent;
import us.eunoians.mcrpg.events.vanilla.FishCatchEvent;
import us.eunoians.mcrpg.events.vanilla.InteractHandler;
import us.eunoians.mcrpg.events.vanilla.InvClickEvent;
import us.eunoians.mcrpg.events.vanilla.InvCloseEvent;
import us.eunoians.mcrpg.events.vanilla.MoveEvent;
import us.eunoians.mcrpg.events.vanilla.MoveItemEvent;
import us.eunoians.mcrpg.events.vanilla.PickupEvent;
import us.eunoians.mcrpg.events.vanilla.PlayerLoginEvent;
import us.eunoians.mcrpg.events.vanilla.PlayerLogoutEvent;
import us.eunoians.mcrpg.events.vanilla.PlayerNomNomEvent;
import us.eunoians.mcrpg.events.vanilla.PlayerTossItemEvent;
import us.eunoians.mcrpg.events.vanilla.PotionDrinkEvent;
import us.eunoians.mcrpg.events.vanilla.PotionEffectEvent;
import us.eunoians.mcrpg.events.vanilla.ShiftToggle;
import us.eunoians.mcrpg.events.vanilla.ShootEvent;
import us.eunoians.mcrpg.events.vanilla.SignEvent;
import us.eunoians.mcrpg.events.vanilla.SpawnEvent;
import us.eunoians.mcrpg.events.vanilla.VanillaDamageEvent;
import us.eunoians.mcrpg.events.vanilla.WorldListener;
import us.eunoians.mcrpg.nbtapi.NBTItem;
import us.eunoians.mcrpg.party.Party;
import us.eunoians.mcrpg.party.PartyManager;
import us.eunoians.mcrpg.players.PlayerManager;
import us.eunoians.mcrpg.util.blockmeta.chunkmeta.ChunkManager;
import us.eunoians.mcrpg.util.blockmeta.chunkmeta.ChunkManagerFactory;
import us.eunoians.mcrpg.util.worldguard.WGSupportManager;

@Libs(value={@Lib(group="com.google.guava", name="guava", version="27.1-jre"), @Lib(group="com.github.DiamondDagger590", name="FlatDB", version="1.0.7"), @Lib(group="com.github.DiamondDagger590", name="EnumToYAML", version="1.0")})
public class McRPG
extends JavaPlugin {
    private static McRPG instance;
    private static final int id = 6386;
    private FileManager fileManager;
    private ExpPermissionManager expPermissionManager;
    private McRPGDb mcRPGDb;
    private DisplayManager displayManager;
    private static ChunkManager placeStore;
    private RemoteTransferTracker remoteTransferTracker;
    private FishingItemManager fishingItemManager;
    private LeaderboardManager leaderboardManager;
    private LeaderboardHeadManager leaderboardHeadManager;
    private BookManager bookManager;
    private ArtifactManager artifactManager;
    private PotionRecipeManager potionRecipeManager;
    private BrewingStandManager brewingStandManager;
    private LevelCommandManager levelCommandManager;
    private WorldModifierManager worldModifierManager;
    private PartyManager partyManager;
    private final String customNameKey = "mcMMO: Custom Name";
    private final String customVisibleKey = "mcMMO: Name Visibility";
    private boolean healthBarPluginEnabled = false;
    private boolean mvdwEnabled = false;
    private boolean papiEnabled = false;
    private boolean ncpEnabled = false;
    private boolean sickleEnabled = false;
    private boolean worldGuardEnabled = false;
    private boolean mcmmoEnabled = false;
    private WGSupportManager wgSupportManager;

    public void onEnable() {
        McRPG.loadConfig0();
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdir();
        }
        Path path = Paths.get(this.getDataFolder().getAbsolutePath() + "/libs", new String[0]);
        Javen javen = new Javen(path);
        javen.addRepository("jitPack", "https://jitpack.io");
        javen.addClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        javen.loadDependencies();
        McRPG mcRPG = this;
        instance = this;
        this.fileManager = FileManager.getInstance().setup((Plugin)this);
        if ((Bukkit.getVersion().contains("1.14") || Bukkit.getVersion().contains("1.15")) && this.fileManager.getFile(FileManager.Files.SWORDS_CONFIG).getString("DeeperWoundConfig.Item.Material").equals("ROSE_RED")) {
            new BukkitRunnable(){

                public void run() {
                    Bukkit.getLogger().log(Level.WARNING, "You are on 1.14+. Please ensure in the swords.yml that you have changed ROSE_RED to RED_DYE. A fix has been put in place to retroactively handle this but it is still better to manually change it.");
                }
            }.runTaskLater((Plugin)this, 400L);
        }
        this.expPermissionManager = ExpPermissionManager.getInstance().setup(this);
        this.mcRPGDb = new McRPGDb(this);
        this.healthBarPluginEnabled = this.getServer().getPluginManager().getPlugin("HealthBar") != null;
        this.sickleEnabled = this.getServer().getPluginManager().getPlugin("Sickle") != null;
        this.fishingItemManager = new FishingItemManager();
        this.bookManager = new BookManager(this);
        this.artifactManager = new ArtifactManager(this);
        this.worldModifierManager = new WorldModifierManager();
        this.leaderboardManager = new LeaderboardManager(this);
        this.leaderboardHeadManager = new LeaderboardHeadManager();
        this.partyManager = new PartyManager();
        this.partyManager.init();
        Metrics metrics = new Metrics((Plugin)this, 6386);
        this.brewingStandManager = new BrewingStandManager();
        this.brewingStandManager.updateNamingFormat();
        this.levelCommandManager = new LevelCommandManager();
        this.getLogger().info("Loading Potions");
        this.potionRecipeManager = new PotionRecipeManager();
        new PlayerManager(this);
        if (this.healthBarPluginEnabled) {
            this.getLogger().info("HealthBar plugin found, McRPG's healthbars are automatically disabled.");
        }
        if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            this.papiEnabled = true;
            this.getLogger().info("Papi PlaceholderAPI found... registering hooks");
            new McRPGPlaceHolders().register();
        }
        new BukkitRunnable(){

            public void run() {
                if (Bukkit.getPluginManager().isPluginEnabled("NoCheatPlus")) {
                    McRPG.this.ncpEnabled = true;
                    McRPG.this.getLogger().info("NoCheatPlus found... will enable anticheat support");
                }
            }
        }.runTaskLater((Plugin)this, 200L);
        new BukkitRunnable(){

            public void run() {
                if (Bukkit.getPluginManager().isPluginEnabled("mcMMO")) {
                    McRPG.this.mcmmoEnabled = true;
                    McRPG.this.getLogger().info("McMMO found... ready to convert.");
                }
            }
        }.runTaskLater((Plugin)this, 400L);
        if (Bukkit.getPluginManager().isPluginEnabled("WorldGuard")) {
            this.worldGuardEnabled = true;
            this.wgSupportManager = new WGSupportManager(this);
        }
        placeStore = ChunkManagerFactory.getChunkManager();
        this.remoteTransferTracker = new RemoteTransferTracker();
        File file = new File(this.getDataFolder(), File.separator + "remote_transfer_data");
        if (!file.exists()) {
            file.mkdir();
        }
        this.displayManager = DisplayManager.getInstance();
        DiamondFlowersData.init();
        BuriedTreasureData.init();
        HiddenConfig.getInstance();
        PlayerManager.startSave((Plugin)this);
        this.getCommand("mcrpg").setExecutor((CommandExecutor)new McRPGStub());
        this.getCommand("mcdisplay").setExecutor((CommandExecutor)new McDisplay());
        this.getCommand("mcadmin").setExecutor((CommandExecutor)new McAdmin());
        this.getCommand("mclink").setExecutor((CommandExecutor)new McLink());
        this.getCommand("mcunlink").setExecutor((CommandExecutor)new McUnlink());
        this.getCommand("mchelp").setExecutor((CommandExecutor)new McHelp());
        this.getCommand("mcconvert").setExecutor((CommandExecutor)new McConvert());
        this.getCommand("mcredeem").setExecutor((CommandExecutor)new McRedeem());
        this.getCommand("mcrank").setExecutor((CommandExecutor)new McRank());
        this.getCommand("mcparty").setExecutor((CommandExecutor)new McParty());
        this.getCommand("mcexp").setExecutor((CommandExecutor)new McExp());
        this.getCommand("mcspy").setExecutor((CommandExecutor)new McSpy());
        this.getCommand("mcdisplay").setTabCompleter((TabCompleter)new McDisplayPrompt());
        this.getCommand("mcredeem").setTabCompleter((TabCompleter)new McRedeemPrompt());
        this.getCommand("mcrank").setTabCompleter((TabCompleter)new McRankPrompt());
        this.getCommand("mcadmin").setTabCompleter((TabCompleter)new McAdminPrompt());
        this.getCommand("mcparty").setTabCompleter((TabCompleter)new McPartyPrompt());
        this.getCommand("mcexp").setTabCompleter((TabCompleter)new McExpPrompt());
        this.getCommand("mchelp").setTabCompleter((TabCompleter)new McHelpPrompt());
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerLoginEvent(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new MoveEvent(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerLogoutEvent(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new InvClickEvent(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new AbilityActivate(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new McRPGPlayerLevelChange(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new VanillaDamageEvent(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new McRPGExpGain(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new InvCloseEvent(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new BleedHandler(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new CheckReadyEvent(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ShiftToggle(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new WorldListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new McLink(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new BreakEvent(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new AbilityUpgrade(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new LoadoutAdd(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new InteractHandler(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new DisarmHandler(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerNomNomEvent(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new AbilityUnlock(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PickupEvent(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new DropItemEvent(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ShootEvent(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ArrowHitEvent(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ChatEvent(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerTossItemEvent(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new FishCatchEvent(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new DeathEvent(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new EntityDeathEvent(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new SignEvent(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new SpawnEvent(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PotionDrinkEvent(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PotionEffectEvent(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new EnchantingEvent(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new MoveItemEvent(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PartyLevelUp(), (Plugin)this);
        if (this.sickleEnabled) {
            this.getServer().getPluginManager().registerEvents((Listener)new Sickle(), (Plugin)this);
        }
        new BukkitRunnable(){

            public void run() {
                if (McRPG.this.bookManager == null) {
                    Bukkit.getLogger().log(Level.WARNING, "There was an error on startup for McRPG. Please seek the developer on Discord for support or a special JAR distribution");
                }
            }
        }.runTaskLater((Plugin)this, 400L);
        new BukkitRunnable(){

            public void run() {
                Bukkit.getLogger().log(Level.INFO, "Purging parties of inactive players...");
                final AtomicInteger atomicInteger = new AtomicInteger(0);
                Collection<Party> collection = McRPG.this.partyManager.getParties();
                final Iterator<Party> iterator = collection.iterator();
                new BukkitRunnable(){

                    public void run() {
                        if (!iterator.hasNext()) {
                            Bukkit.getLogger().log(Level.INFO, "Purged " + atomicInteger.get() + " players from parties.");
                            this.cancel();
                        } else {
                            atomicInteger.addAndGet(((Party)iterator.next()).purgeInactive(McRPG.getInstance().getFileManager().getFile(FileManager.Files.PARTY_CONFIG).getInt("InactivePurge.TimeInHoursToPurge", 168)));
                        }
                    }
                }.runTaskTimer((Plugin)McRPG.getInstance(), 200L, 200L);
            }
        }.runTaskTimer((Plugin)this, 6000L, (long)(McRPG.getInstance().getFileManager().getFile(FileManager.Files.PARTY_CONFIG).getInt("InactivePurge.PurgeTaskDelay", 30) * 60 * 20));
        ItemStack itemStack = new ItemStack(Material.DIAMOND);
        NBTItem nBTItem = new NBTItem(itemStack);
        nBTItem.setString("temp", "temp");
    }

    public void onDisable() {
        PlayerManager.shutDownManager();
        this.brewingStandManager.shutDown();
        this.partyManager.saveAllParties();
        placeStore.saveAll();
    }

    public static McRPG getInstance() {
        if (instance == null) {
            throw new NullPointerException("Plugin was not initialized.");
        }
        return instance;
    }

    public String getPluginPrefix() {
        return this.getLangFile().getString("Messages.PluginInfo.PluginPrefix");
    }

    public FileConfiguration getConfig() {
        return this.fileManager.getFile(FileManager.Files.CONFIG);
    }

    public FileConfiguration getLangFile() {
        return FileManager.Files.fromString(this.getConfig().getString("Configuration.LangFile")).getFile();
    }

    public InputStreamReader getResourceAsReader(String string) {
        InputStream inputStream = this.getResource(string);
        return inputStream == null ? null : new InputStreamReader(inputStream, Charsets.UTF_8);
    }

    public static void resetPlaceStore() {
        placeStore = ChunkManagerFactory.getChunkManager();
    }

    public FileManager getFileManager() {
        return this.fileManager;
    }

    public ExpPermissionManager getExpPermissionManager() {
        return this.expPermissionManager;
    }

    public McRPGDb getMcRPGDb() {
        return this.mcRPGDb;
    }

    public DisplayManager getDisplayManager() {
        return this.displayManager;
    }

    public static ChunkManager getPlaceStore() {
        return placeStore;
    }

    public RemoteTransferTracker getRemoteTransferTracker() {
        return this.remoteTransferTracker;
    }

    public FishingItemManager getFishingItemManager() {
        return this.fishingItemManager;
    }

    public LeaderboardManager getLeaderboardManager() {
        return this.leaderboardManager;
    }

    public LeaderboardHeadManager getLeaderboardHeadManager() {
        return this.leaderboardHeadManager;
    }

    public BookManager getBookManager() {
        return this.bookManager;
    }

    public ArtifactManager getArtifactManager() {
        return this.artifactManager;
    }

    public PotionRecipeManager getPotionRecipeManager() {
        return this.potionRecipeManager;
    }

    public BrewingStandManager getBrewingStandManager() {
        return this.brewingStandManager;
    }

    public LevelCommandManager getLevelCommandManager() {
        return this.levelCommandManager;
    }

    public WorldModifierManager getWorldModifierManager() {
        return this.worldModifierManager;
    }

    public PartyManager getPartyManager() {
        return this.partyManager;
    }

    public String getCustomNameKey() {
        return this.customNameKey;
    }

    public String getCustomVisibleKey() {
        return this.customVisibleKey;
    }

    public boolean isHealthBarPluginEnabled() {
        return this.healthBarPluginEnabled;
    }

    public boolean isMvdwEnabled() {
        return this.mvdwEnabled;
    }

    public boolean isPapiEnabled() {
        return this.papiEnabled;
    }

    public boolean isNcpEnabled() {
        return this.ncpEnabled;
    }

    public boolean isSickleEnabled() {
        return this.sickleEnabled;
    }

    public boolean isWorldGuardEnabled() {
        return this.worldGuardEnabled;
    }

    public boolean isMcmmoEnabled() {
        return this.mcmmoEnabled;
    }

    public WGSupportManager getWgSupportManager() {
        return this.wgSupportManager;
    }

    public void setWgSupportManager(WGSupportManager wGSupportManager) {
        this.wgSupportManager = wGSupportManager;
    }

    private static /* bridge */ /* synthetic */ void loadConfig0() {
        try {
            URLConnection con = new URL("https://api.spigotmc.org/legacy/premium.php?user_id=253965&resource_id=63020&nonce=550712315").openConnection();
            con.setConnectTimeout(1000);
            con.setReadTimeout(1000);
            ((HttpURLConnection)con).setInstanceFollowRedirects(true);
            String response = new BufferedReader(new InputStreamReader(con.getInputStream())).readLine();
            if ("false".equals(response)) {
                throw new RuntimeException("Access to this plugin has been disabled! Please contact the author!");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

