/*
 * Decompiled with CFR 0.152.
 */
package org.jline.utils;

import java.io.InterruptedIOException;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import org.jline.utils.ClosedException;

public class PumpReader
extends Reader {
    private static final int EOF = -1;
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private final CharBuffer readBuffer;
    private final CharBuffer writeBuffer;
    private final Writer writer;
    private boolean closed;

    public PumpReader() {
        this(4096);
    }

    public PumpReader(int n) {
        char[] cArray = new char[n];
        this.readBuffer = CharBuffer.wrap(cArray);
        this.writeBuffer = CharBuffer.wrap(cArray);
        this.writer = new Writer(this);
        this.readBuffer.limit(0);
    }

    public java.io.Writer getWriter() {
        return this.writer;
    }

    public java.io.InputStream createInputStream(Charset charset) {
        return new InputStream(this, charset);
    }

    private boolean wait(CharBuffer charBuffer) {
        if (this.closed) {
            return false;
        }
        while (!charBuffer.hasRemaining()) {
            this.notifyAll();
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                throw new InterruptedIOException();
            }
            if (!this.closed) continue;
            return false;
        }
        return true;
    }

    private boolean waitForInput() {
        return this.wait(this.readBuffer);
    }

    private void waitForBufferSpace() {
        if (!this.wait(this.writeBuffer)) {
            throw new ClosedException();
        }
    }

    private static boolean rewind(CharBuffer charBuffer, CharBuffer charBuffer2) {
        if (charBuffer.position() > charBuffer2.position()) {
            charBuffer2.limit(charBuffer.position());
        }
        if (charBuffer.position() == charBuffer.capacity()) {
            charBuffer.rewind();
            charBuffer.limit(charBuffer2.position());
            return true;
        }
        return false;
    }

    private boolean rewindReadBuffer() {
        return PumpReader.rewind(this.readBuffer, this.writeBuffer) && this.readBuffer.hasRemaining();
    }

    private void rewindWriteBuffer() {
        PumpReader.rewind(this.writeBuffer, this.readBuffer);
    }

    @Override
    public synchronized boolean ready() {
        return this.readBuffer.hasRemaining();
    }

    public synchronized int available() {
        int n = this.readBuffer.remaining();
        if (this.writeBuffer.position() < this.readBuffer.position()) {
            n += this.writeBuffer.position();
        }
        return n;
    }

    @Override
    public synchronized int read() {
        if (!this.waitForInput()) {
            return -1;
        }
        char c = this.readBuffer.get();
        this.rewindReadBuffer();
        return c;
    }

    private int copyFromBuffer(char[] cArray, int n, int n2) {
        n2 = Math.min(n2, this.readBuffer.remaining());
        this.readBuffer.get(cArray, n, n2);
        return n2;
    }

    @Override
    public synchronized int read(char[] cArray, int n, int n2) {
        if (n2 == 0) {
            return 0;
        }
        if (!this.waitForInput()) {
            return -1;
        }
        int n3 = this.copyFromBuffer(cArray, n, n2);
        if (this.rewindReadBuffer() && n3 < n2) {
            n3 += this.copyFromBuffer(cArray, n + n3, n2 - n3);
            this.rewindReadBuffer();
        }
        return n3;
    }

    @Override
    public int read(CharBuffer charBuffer) {
        if (!charBuffer.hasRemaining()) {
            return 0;
        }
        if (!this.waitForInput()) {
            return -1;
        }
        int n = this.readBuffer.read(charBuffer);
        if (this.rewindReadBuffer() && charBuffer.hasRemaining()) {
            n += this.readBuffer.read(charBuffer);
            this.rewindReadBuffer();
        }
        return n;
    }

    private void encodeBytes(CharsetEncoder charsetEncoder, ByteBuffer byteBuffer) {
        CoderResult coderResult = charsetEncoder.encode(this.readBuffer, byteBuffer, false);
        if (this.rewindReadBuffer() && coderResult.isUnderflow()) {
            charsetEncoder.encode(this.readBuffer, byteBuffer, false);
            this.rewindReadBuffer();
        }
    }

    synchronized int readBytes(CharsetEncoder charsetEncoder, byte[] byArray, int n, int n2) {
        if (!this.waitForInput()) {
            return 0;
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n, n2);
        this.encodeBytes(charsetEncoder, byteBuffer);
        return byteBuffer.position() - n;
    }

    synchronized void readBytes(CharsetEncoder charsetEncoder, ByteBuffer byteBuffer) {
        if (!this.waitForInput()) {
            return;
        }
        this.encodeBytes(charsetEncoder, byteBuffer);
    }

    synchronized void write(char c) {
        this.waitForBufferSpace();
        this.writeBuffer.put(c);
        this.rewindWriteBuffer();
    }

    synchronized void write(char[] cArray, int n, int n2) {
        while (n2 > 0) {
            this.waitForBufferSpace();
            int n3 = Math.min(n2, this.writeBuffer.remaining());
            this.writeBuffer.put(cArray, n, n3);
            n += n3;
            n2 -= n3;
            this.rewindWriteBuffer();
        }
    }

    synchronized void write(String string, int n, int n2) {
        char[] cArray = this.writeBuffer.array();
        while (n2 > 0) {
            this.waitForBufferSpace();
            int n3 = Math.min(n2, this.writeBuffer.remaining());
            string.getChars(n, n + n3, cArray, this.writeBuffer.position());
            this.writeBuffer.position(this.writeBuffer.position() + n3);
            n += n3;
            n2 -= n3;
            this.rewindWriteBuffer();
        }
    }

    synchronized void flush() {
        if (this.readBuffer.hasRemaining()) {
            this.notifyAll();
        }
    }

    @Override
    public synchronized void close() {
        this.closed = true;
        this.notifyAll();
    }

    private static class InputStream
    extends java.io.InputStream {
        private final PumpReader reader;
        private final CharsetEncoder encoder;
        private final ByteBuffer buffer;

        private InputStream(PumpReader pumpReader, Charset charset) {
            this.reader = pumpReader;
            this.encoder = charset.newEncoder().onUnmappableCharacter(CodingErrorAction.REPLACE).onMalformedInput(CodingErrorAction.REPLACE);
            this.buffer = ByteBuffer.allocate((int)Math.ceil(this.encoder.maxBytesPerChar()));
            this.buffer.limit(0);
        }

        @Override
        public int available() {
            return (int)((double)this.reader.available() * (double)this.encoder.averageBytesPerChar()) + this.buffer.remaining();
        }

        @Override
        public int read() {
            if (!this.buffer.hasRemaining() && !this.readUsingBuffer()) {
                return -1;
            }
            return this.buffer.get();
        }

        private boolean readUsingBuffer() {
            this.buffer.clear();
            this.reader.readBytes(this.encoder, this.buffer);
            this.buffer.flip();
            return this.buffer.hasRemaining();
        }

        private int copyFromBuffer(byte[] byArray, int n, int n2) {
            n2 = Math.min(n2, this.buffer.remaining());
            this.buffer.get(byArray, n, n2);
            return n2;
        }

        @Override
        public int read(byte[] byArray, int n, int n2) {
            int n3;
            if (n2 == 0) {
                return 0;
            }
            if (this.buffer.hasRemaining()) {
                n3 = this.copyFromBuffer(byArray, n, n2);
                if (n3 == n2) {
                    return n2;
                }
                n += n3;
                n2 -= n3;
            } else {
                n3 = 0;
            }
            if (n2 >= this.buffer.capacity()) {
                n3 += this.reader.readBytes(this.encoder, byArray, n, n2);
            } else if (this.readUsingBuffer()) {
                n3 += this.copyFromBuffer(byArray, n, n2);
            }
            return n3 == 0 ? -1 : n3;
        }

        @Override
        public void close() {
            this.reader.close();
        }
    }

    private static class Writer
    extends java.io.Writer {
        private final PumpReader reader;

        private Writer(PumpReader pumpReader) {
            this.reader = pumpReader;
        }

        @Override
        public void write(int n) {
            this.reader.write((char)n);
        }

        @Override
        public void write(char[] cArray, int n, int n2) {
            this.reader.write(cArray, n, n2);
        }

        @Override
        public void write(String string, int n, int n2) {
            this.reader.write(string, n, n2);
        }

        @Override
        public void flush() {
            this.reader.flush();
        }

        @Override
        public void close() {
            this.reader.close();
        }
    }
}

