/*
 * Decompiled with CFR 0.152.
 */
package org.jline.utils;

import java.io.InterruptedIOException;
import java.io.Writer;
import java.nio.CharBuffer;
import org.jline.utils.ClosedException;
import org.jline.utils.NonBlockingReader;

public class NonBlockingPumpReader
extends NonBlockingReader {
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private final CharBuffer readBuffer;
    private final CharBuffer writeBuffer;
    private final Writer writer;
    private boolean closed;

    public NonBlockingPumpReader() {
        this(4096);
    }

    public NonBlockingPumpReader(int n) {
        char[] cArray = new char[n];
        this.readBuffer = CharBuffer.wrap(cArray);
        this.writeBuffer = CharBuffer.wrap(cArray);
        this.writer = new NbpWriter();
        this.readBuffer.limit(0);
    }

    public Writer getWriter() {
        return this.writer;
    }

    private int wait(CharBuffer charBuffer, long l) {
        boolean bl = l <= 0L;
        long l2 = 0L;
        if (!bl) {
            l2 = System.currentTimeMillis() + l;
        }
        while (!(this.closed || charBuffer.hasRemaining() || !bl && l <= 0L)) {
            this.notifyAll();
            try {
                this.wait(l);
            }
            catch (InterruptedException interruptedException) {
                throw new InterruptedIOException();
            }
            if (bl) continue;
            l = l2 - System.currentTimeMillis();
        }
        return this.closed ? -1 : (charBuffer.hasRemaining() ? 0 : -2);
    }

    private static boolean rewind(CharBuffer charBuffer, CharBuffer charBuffer2) {
        if (charBuffer.position() > charBuffer2.position()) {
            charBuffer2.limit(charBuffer.position());
        }
        if (charBuffer.position() == charBuffer.capacity()) {
            charBuffer.rewind();
            charBuffer.limit(charBuffer2.position());
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean ready() {
        return this.readBuffer.hasRemaining();
    }

    @Override
    public synchronized int available() {
        int n = this.readBuffer.remaining();
        if (this.writeBuffer.position() < this.readBuffer.position()) {
            n += this.writeBuffer.position();
        }
        return n;
    }

    @Override
    protected synchronized int read(long l, boolean bl) {
        int n = this.wait(this.readBuffer, l);
        if (n >= 0) {
            n = bl ? this.readBuffer.get(this.readBuffer.position()) : this.readBuffer.get();
        }
        NonBlockingPumpReader.rewind(this.readBuffer, this.writeBuffer);
        return n;
    }

    synchronized void write(char[] cArray, int n, int n2) {
        while (n2 > 0) {
            if (this.wait(this.writeBuffer, 0L) == -1) {
                throw new ClosedException();
            }
            int n3 = Math.min(n2, this.writeBuffer.remaining());
            this.writeBuffer.put(cArray, n, n3);
            n += n3;
            n2 -= n3;
            NonBlockingPumpReader.rewind(this.writeBuffer, this.readBuffer);
        }
    }

    synchronized void flush() {
        if (this.readBuffer.hasRemaining()) {
            this.notifyAll();
        }
    }

    @Override
    public synchronized void close() {
        this.closed = true;
        this.notifyAll();
    }

    private class NbpWriter
    extends Writer {
        private NbpWriter() {
        }

        @Override
        public void write(char[] cArray, int n, int n2) {
            NonBlockingPumpReader.this.write(cArray, n, n2);
        }

        @Override
        public void flush() {
            NonBlockingPumpReader.this.flush();
        }

        @Override
        public void close() {
            NonBlockingPumpReader.this.close();
        }
    }
}

