/*
 * Decompiled with CFR 0.152.
 */
package org.jline.utils;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public final class Log {
    public static void trace(Object ... objectArray) {
        Log.log(Level.FINEST, objectArray);
    }

    public static void trace(Supplier<String> supplier) {
        Log.log(Level.FINEST, supplier);
    }

    public static void debug(Supplier<String> supplier) {
        Log.log(Level.FINE, supplier);
    }

    public static void debug(Object ... objectArray) {
        Log.log(Level.FINE, objectArray);
    }

    public static void info(Object ... objectArray) {
        Log.log(Level.INFO, objectArray);
    }

    public static void warn(Object ... objectArray) {
        Log.log(Level.WARNING, objectArray);
    }

    public static void error(Object ... objectArray) {
        Log.log(Level.SEVERE, objectArray);
    }

    public static boolean isDebugEnabled() {
        return Log.isEnabled(Level.FINE);
    }

    static void render(PrintStream printStream, Object object) {
        if (object != null && object.getClass().isArray()) {
            Object[] objectArray = (Object[])object;
            printStream.print("[");
            for (int i = 0; i < objectArray.length; ++i) {
                printStream.print(objectArray[i]);
                if (i + 1 >= objectArray.length) continue;
                printStream.print(",");
            }
            printStream.print("]");
        } else {
            printStream.print(object);
        }
    }

    static LogRecord createRecord(Level level, Object ... objectArray) {
        Throwable throwable = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        for (int i = 0; i < objectArray.length; ++i) {
            if (i + 1 == objectArray.length && objectArray[i] instanceof Throwable) {
                throwable = (Throwable)objectArray[i];
                continue;
            }
            Log.render(printStream, objectArray[i]);
        }
        printStream.close();
        LogRecord logRecord = new LogRecord(level, byteArrayOutputStream.toString());
        logRecord.setThrown(throwable);
        return logRecord;
    }

    static LogRecord createRecord(Level level, Supplier<String> supplier) {
        return new LogRecord(level, supplier.get());
    }

    static void log(Level level, Supplier<String> supplier) {
        Log.logr(level, () -> Log.createRecord(level, supplier));
    }

    static void log(Level level, Object ... objectArray) {
        Log.logr(level, () -> Log.createRecord(level, objectArray));
    }

    static void logr(Level level, Supplier<LogRecord> supplier) {
        Logger logger = Logger.getLogger("org.jline");
        if (logger.isLoggable(level)) {
            LogRecord logRecord = supplier.get();
            logRecord.setLoggerName(logger.getName());
            logger.log(logRecord);
        }
    }

    static boolean isEnabled(Level level) {
        Logger logger = Logger.getLogger("org.jline");
        return logger.isLoggable(level);
    }
}

