/*
 * Decompiled with CFR 0.152.
 */
package org.jline.utils;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jline.terminal.Terminal;
import org.jline.utils.AttributedCharSequence;
import org.jline.utils.AttributedString;
import org.jline.utils.Curses;
import org.jline.utils.DiffHelper;
import org.jline.utils.InfoCmp;

public class Display {
    protected final Terminal terminal;
    protected final boolean fullScreen;
    protected List<AttributedString> oldLines = Collections.emptyList();
    protected int cursorPos;
    private int columns;
    private int columns1;
    protected int rows;
    protected boolean reset;
    protected boolean delayLineWrap;
    protected final Map<InfoCmp.Capability, Integer> cost = new HashMap<InfoCmp.Capability, Integer>();
    protected final boolean canScroll;
    protected final boolean wrapAtEol;
    protected final boolean delayedWrapAtEol;
    protected final boolean cursorDownIsNewLine;

    public Display(Terminal terminal, boolean bl) {
        this.terminal = terminal;
        this.fullScreen = bl;
        this.canScroll = this.can(InfoCmp.Capability.insert_line, InfoCmp.Capability.parm_insert_line) && this.can(InfoCmp.Capability.delete_line, InfoCmp.Capability.parm_delete_line);
        this.wrapAtEol = terminal.getBooleanCapability(InfoCmp.Capability.auto_right_margin);
        this.delayedWrapAtEol = this.wrapAtEol && terminal.getBooleanCapability(InfoCmp.Capability.eat_newline_glitch);
        this.cursorDownIsNewLine = "\n".equals(Curses.tputs(terminal.getStringCapability(InfoCmp.Capability.cursor_down), new Object[0]));
    }

    public boolean delayLineWrap() {
        return this.delayLineWrap;
    }

    public void setDelayLineWrap(boolean bl) {
        this.delayLineWrap = bl;
    }

    public void resize(int n, int n2) {
        if (this.rows != n || this.columns != n2) {
            this.rows = n;
            this.columns = n2;
            this.columns1 = n2 + 1;
            this.oldLines = AttributedString.join(AttributedString.EMPTY, this.oldLines).columnSplitLength(n2, true, this.delayLineWrap());
        }
    }

    public void reset() {
        this.oldLines = Collections.emptyList();
    }

    public void clear() {
        if (this.fullScreen) {
            this.reset = true;
        }
    }

    public void updateAnsi(List<String> list, int n) {
        this.update(list.stream().map(AttributedString::fromAnsi).collect(Collectors.toList()), n);
    }

    public void update(List<AttributedString> list, int n) {
        this.update(list, n, true);
    }

    public void update(List<AttributedString> list, int n, boolean bl) {
        int n2;
        int n3;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        int n4;
        int n5;
        int n6;
        Integer n7;
        if (this.reset) {
            this.terminal.puts(InfoCmp.Capability.clear_screen, new Object[0]);
            this.oldLines.clear();
            this.cursorPos = 0;
            this.reset = false;
        }
        if ((n7 = this.terminal.getNumericCapability(InfoCmp.Capability.max_colors)) == null || n7 < 8) {
            list = list.stream().map(attributedString -> new AttributedString(attributedString.toString())).collect(Collectors.toList());
        }
        if ((this.fullScreen || list.size() >= this.rows) && list.size() == this.oldLines.size() && this.canScroll) {
            n6 = 0;
            n5 = list.size();
            for (n4 = 0; n4 < n5 && Objects.equals(list.get(n4), this.oldLines.get(n4)); ++n4) {
            }
            while (n6 < n5 - n4 - 1 && Objects.equals(list.get(list.size() - n6 - 1), this.oldLines.get(this.oldLines.size() - n6 - 1))) {
                ++n6;
            }
            List<AttributedString> list2 = list.subList(n4, list.size() - n6);
            object4 = Display.longestCommon(list2, (List<AttributedString>)(object5 = this.oldLines.subList(n4, this.oldLines.size() - n6)));
            if (object4 != null) {
                object3 = object4[0];
                object2 = object4[1];
                object = object4[2];
                if (object > 1 && object3 < object2) {
                    this.moveVisualCursorTo((n4 + object3) * this.columns1);
                    n3 = object2 - object3;
                    this.deleteLines(n3);
                    for (n2 = 0; n2 < n3; ++n2) {
                        this.oldLines.remove(n4 + object3);
                    }
                    if (n6 > 0) {
                        this.moveVisualCursorTo((n4 + object3 + object) * this.columns1);
                        this.insertLines(n3);
                        for (n2 = 0; n2 < n3; ++n2) {
                            this.oldLines.add(n4 + object3 + object, new AttributedString(""));
                        }
                    }
                } else if (object > 1 && object3 > object2) {
                    n3 = object3 - object2;
                    if (n6 > 0) {
                        this.moveVisualCursorTo((n4 + object2 + object) * this.columns1);
                        this.deleteLines(n3);
                        for (n2 = 0; n2 < n3; ++n2) {
                            this.oldLines.remove(n4 + object2 + object);
                        }
                    }
                    this.moveVisualCursorTo((n4 + object2) * this.columns1);
                    this.insertLines(n3);
                    for (n2 = 0; n2 < n3; ++n2) {
                        this.oldLines.add(n4 + object2, new AttributedString(""));
                    }
                }
            }
        }
        n4 = 0;
        n6 = 0;
        n5 = Math.max(this.oldLines.size(), list.size());
        boolean bl2 = false;
        while (n4 < n5) {
            int n8;
            int n9;
            int n10;
            Object object6;
            object5 = n4 < this.oldLines.size() ? this.oldLines.get(n4) : AttributedString.NEWLINE;
            object4 = n4 < list.size() ? list.get(n4) : AttributedString.NEWLINE;
            object3 = n6 = n4 * this.columns1;
            object2 = ((AttributedString)object5).length();
            object = ((AttributedString)object4).length();
            n3 = object2 > 0 && ((AttributedCharSequence)object5).charAt(object2 - 1) == '\n' ? 1 : 0;
            int n11 = n2 = object > 0 && ((AttributedCharSequence)object4).charAt(object - 1) == '\n' ? 1 : 0;
            if (n3 != 0) {
                object5 = ((AttributedCharSequence)object5).substring(0, (int)(--object2));
            }
            if (n2 != 0) {
                object4 = ((AttributedCharSequence)object4).substring(0, (int)(--object));
            }
            if (bl2 && n4 == (this.cursorPos + 1) / this.columns1 && n4 < list.size()) {
                ++this.cursorPos;
                if (object == 0 || ((AttributedCharSequence)object4).isHidden(0)) {
                    this.rawPrint(new AttributedString(" \b"));
                } else {
                    object6 = ((AttributedCharSequence)object4).columnSubSequence(0, 1);
                    this.rawPrint((AttributedString)object6);
                    ++this.cursorPos;
                    n10 = ((AttributedString)object6).length();
                    object4 = ((AttributedCharSequence)object4).substring(n10, (int)object);
                    object -= n10;
                    if (object2 >= n10) {
                        object5 = ((AttributedCharSequence)object5).substring(n10, (int)object2);
                        object2 -= n10;
                    }
                    n6 = this.cursorPos;
                }
            }
            object6 = DiffHelper.diff((AttributedString)object5, (AttributedString)object4);
            n10 = 1;
            boolean bl3 = false;
            block12: for (n9 = 0; n9 < object6.size(); ++n9) {
                DiffHelper.Diff diff = object6.get(n9);
                n8 = diff.text.columnLength();
                switch (diff.operation) {
                    case EQUAL: {
                        if (n10 == 0) {
                            this.cursorPos = this.moveVisualCursorTo(n6);
                            this.rawPrint(diff.text);
                            this.cursorPos += n8;
                            n6 = this.cursorPos;
                            continue block12;
                        }
                        n6 += n8;
                        continue block12;
                    }
                    case INSERT: {
                        if (n9 <= object6.size() - 2 && ((DiffHelper.Diff)object6.get((int)(n9 + 1))).operation == DiffHelper.Operation.EQUAL) {
                            this.cursorPos = this.moveVisualCursorTo(n6);
                            if (this.insertChars(n8)) {
                                this.rawPrint(diff.text);
                                this.cursorPos += n8;
                                n6 = this.cursorPos;
                                continue block12;
                            }
                        } else if (n9 <= object6.size() - 2 && ((DiffHelper.Diff)object6.get((int)(n9 + 1))).operation == DiffHelper.Operation.DELETE && n8 == ((DiffHelper.Diff)object6.get((int)(n9 + 1))).text.columnLength()) {
                            this.moveVisualCursorTo(n6);
                            this.rawPrint(diff.text);
                            this.cursorPos += n8;
                            n6 = this.cursorPos;
                            ++n9;
                            continue block12;
                        }
                        this.moveVisualCursorTo(n6);
                        this.rawPrint(diff.text);
                        this.cursorPos += n8;
                        n6 = this.cursorPos;
                        n10 = 0;
                        continue block12;
                    }
                    case DELETE: {
                        if (bl3 || n6 - object3 >= this.columns) continue block12;
                        if (n9 <= object6.size() - 2 && ((DiffHelper.Diff)object6.get((int)(n9 + 1))).operation == DiffHelper.Operation.EQUAL && n6 + ((DiffHelper.Diff)object6.get((int)(n9 + 1))).text.columnLength() < this.columns) {
                            this.moveVisualCursorTo(n6);
                            if (this.deleteChars(n8)) continue block12;
                        }
                        int n12 = ((AttributedCharSequence)object5).columnLength();
                        int n13 = ((AttributedCharSequence)object4).columnLength();
                        int n14 = Math.max(n12, n13) - (n6 - object3);
                        this.moveVisualCursorTo(n6);
                        if (!this.terminal.puts(InfoCmp.Capability.clr_eol, new Object[0])) {
                            this.rawPrint(' ', n14);
                            this.cursorPos += n14;
                        }
                        bl3 = true;
                        n10 = 0;
                    }
                }
            }
            int n15 = n9 = n2 == 0 && ++n4 < list.size() ? 1 : 0;
            if (!(n + 1 != n4 * this.columns1 || n9 == 0 && this.delayLineWrap)) {
                ++n;
            }
            boolean bl4 = (this.cursorPos - object3) % this.columns1 == this.columns;
            bl2 = false;
            if (this.delayedWrapAtEol) {
                n8 = n3 == 0 && n4 < this.oldLines.size() ? 1 : 0;
                if (n9 == n8 || n8 != 0 && bl3) continue;
                this.moveVisualCursorTo(n4 * this.columns1 - 1, list);
                if (n9 != 0) {
                    bl2 = true;
                    continue;
                }
                this.terminal.puts(InfoCmp.Capability.clr_eol, new Object[0]);
                continue;
            }
            if (!bl4) continue;
            if (this.wrapAtEol) {
                this.terminal.writer().write(" \b");
                ++this.cursorPos;
            } else {
                this.terminal.puts(InfoCmp.Capability.carriage_return, new Object[0]);
                this.cursorPos = object3;
            }
            n6 = this.cursorPos;
        }
        int n16 = this.cursorPos;
        if (this.cursorPos != n) {
            this.moveVisualCursorTo(n < 0 ? n6 : n, list);
        }
        this.oldLines = list;
        if (bl) {
            this.terminal.flush();
        }
    }

    protected boolean deleteLines(int n) {
        return this.perform(InfoCmp.Capability.delete_line, InfoCmp.Capability.parm_delete_line, n);
    }

    protected boolean insertLines(int n) {
        return this.perform(InfoCmp.Capability.insert_line, InfoCmp.Capability.parm_insert_line, n);
    }

    protected boolean insertChars(int n) {
        return this.perform(InfoCmp.Capability.insert_character, InfoCmp.Capability.parm_ich, n);
    }

    protected boolean deleteChars(int n) {
        return this.perform(InfoCmp.Capability.delete_character, InfoCmp.Capability.parm_dch, n);
    }

    protected boolean can(InfoCmp.Capability capability, InfoCmp.Capability capability2) {
        return this.terminal.getStringCapability(capability) != null || this.terminal.getStringCapability(capability2) != null;
    }

    protected boolean perform(InfoCmp.Capability capability, InfoCmp.Capability capability2, int n) {
        boolean bl;
        boolean bl2 = this.terminal.getStringCapability(capability2) != null;
        boolean bl3 = bl = this.terminal.getStringCapability(capability) != null;
        if (bl2 && (!bl || this.cost(capability) * n > this.cost(capability2))) {
            this.terminal.puts(capability2, n);
            return true;
        }
        if (bl) {
            for (int i = 0; i < n; ++i) {
                this.terminal.puts(capability, new Object[0]);
            }
            return true;
        }
        return false;
    }

    private int cost(InfoCmp.Capability capability) {
        return this.cost.computeIfAbsent(capability, this::computeCost);
    }

    private int computeCost(InfoCmp.Capability capability) {
        String string = Curses.tputs(this.terminal.getStringCapability(capability), 0);
        return string != null ? string.length() : Integer.MAX_VALUE;
    }

    private static int[] longestCommon(List<AttributedString> list, List<AttributedString> list2) {
        int[] nArray;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < list.size(); ++i) {
            for (int j = 0; j < list2.size(); ++j) {
                int n4 = 0;
                while (Objects.equals(list.get(i + n4), list2.get(j + n4)) && i + ++n4 < list.size() && j + n4 < list2.size()) {
                }
                if (n4 <= n3) continue;
                n3 = n4;
                n = i;
                n2 = j;
            }
        }
        if (n3 != 0) {
            int[] nArray2 = new int[3];
            nArray2[0] = n;
            nArray2[1] = n2;
            nArray = nArray2;
            nArray2[2] = n3;
        } else {
            nArray = null;
        }
        return nArray;
    }

    protected void moveVisualCursorTo(int n, List<AttributedString> list) {
        if (this.cursorPos != n) {
            boolean bl = n % this.columns1 == this.columns;
            this.moveVisualCursorTo(n - (bl ? 1 : 0));
            if (bl) {
                AttributedString attributedString;
                int n2 = n / this.columns1;
                AttributedString attributedString2 = attributedString = n2 >= list.size() ? AttributedString.EMPTY : list.get(n2).columnSubSequence(this.columns - 1, this.columns);
                if (attributedString.length() == 0) {
                    this.rawPrint(32);
                } else {
                    this.rawPrint(attributedString);
                }
                ++this.cursorPos;
            }
        }
    }

    protected int moveVisualCursorTo(int n) {
        int n2 = this.cursorPos;
        if (n2 == n) {
            return n;
        }
        int n3 = this.columns1;
        int n4 = n2 / n3;
        int n5 = n2 % n3;
        int n6 = n / n3;
        int n7 = n % n3;
        if (n5 == this.columns) {
            this.terminal.puts(InfoCmp.Capability.carriage_return, new Object[0]);
            n5 = 0;
        }
        if (n4 > n6) {
            this.perform(InfoCmp.Capability.cursor_up, InfoCmp.Capability.parm_up_cursor, n4 - n6);
        } else if (n4 < n6) {
            if (this.fullScreen) {
                if (!this.terminal.puts(InfoCmp.Capability.parm_down_cursor, n6 - n4)) {
                    for (int i = n4; i < n6; ++i) {
                        this.terminal.puts(InfoCmp.Capability.cursor_down, new Object[0]);
                    }
                    if (this.cursorDownIsNewLine) {
                        n5 = 0;
                    }
                }
            } else {
                this.terminal.puts(InfoCmp.Capability.carriage_return, new Object[0]);
                this.rawPrint('\n', n6 - n4);
                n5 = 0;
            }
        }
        if (n5 != 0 && n7 == 0) {
            this.terminal.puts(InfoCmp.Capability.carriage_return, new Object[0]);
        } else if (n5 < n7) {
            this.perform(InfoCmp.Capability.cursor_right, InfoCmp.Capability.parm_right_cursor, n7 - n5);
        } else if (n5 > n7) {
            this.perform(InfoCmp.Capability.cursor_left, InfoCmp.Capability.parm_left_cursor, n5 - n7);
        }
        this.cursorPos = n;
        return n;
    }

    void rawPrint(char c, int n) {
        for (int i = 0; i < n; ++i) {
            this.rawPrint(c);
        }
    }

    void rawPrint(int n) {
        this.terminal.writer().write(n);
    }

    void rawPrint(AttributedString attributedString) {
        this.terminal.writer().write(attributedString.toAnsi(this.terminal));
    }

    public int wcwidth(String string) {
        return AttributedString.fromAnsi(string).columnLength();
    }
}

