/*
 * Decompiled with CFR 0.152.
 */
package org.jline.utils;

import java.io.BufferedReader;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.jline.utils.InfoCmp;
import org.jline.utils.InputStreamReader;

public class Colors {
    public static final int[] DEFAULT_COLORS_256 = new int[]{0, 0x800000, 32768, 0x808000, 128, 0x800080, 32896, 0xC0C0C0, 0x808080, 0xFF0000, 65280, 0xFFFF00, 255, 0xFF00FF, 65535, 0xFFFFFF, 0, 95, 135, 175, 215, 255, 24320, 24415, 24455, 24495, 24535, 24575, 34560, 34655, 34695, 34735, 34775, 34815, 44800, 44895, 44935, 44975, 45015, 45055, 55040, 55135, 55175, 55215, 55255, 55295, 65280, 65375, 65415, 65455, 65495, 65535, 0x5F0000, 0x5F005F, 6226055, 6226095, 6226135, 0x5F00FF, 0x5F5F00, 0x5F5F5F, 6250375, 0x5F5FAF, 6250455, 0x5F5FFF, 6260480, 6260575, 6260615, 6260655, 6260695, 6260735, 6270720, 0x5FAF5F, 6270855, 0x5FAFAF, 6270935, 0x5FAFFF, 6280960, 6281055, 6281095, 6281135, 6281175, 6281215, 0x5FFF00, 0x5FFF5F, 6291335, 0x5FFFAF, 6291415, 0x5FFFFF, 0x870000, 8847455, 0x870087, 8847535, 8847575, 8847615, 8871680, 8871775, 8871815, 8871855, 8871895, 8871935, 0x878700, 8882015, 0x878787, 8882095, 0x8787D7, 0x8787FF, 8892160, 8892255, 8892295, 8892335, 8892375, 8892415, 8902400, 8902495, 0x87D787, 8902575, 0x87D7D7, 8902655, 8912640, 8912735, 0x87FF87, 8912815, 8912855, 0x87FFFF, 0xAF0000, 11468895, 11468935, 0xAF00AF, 11469015, 0xAF00FF, 11493120, 0xAF5F5F, 11493255, 0xAF5FAF, 11493335, 0xAF5FFF, 11503360, 11503455, 11503495, 11503535, 11503575, 11503615, 0xAFAF00, 0xAFAF5F, 11513735, 0xAFAFAF, 11513815, 0xAFAFFF, 11523840, 11523935, 11523975, 11524015, 11524055, 11524095, 0xAFFF00, 0xAFFF5F, 11534215, 0xAFFFAF, 11534295, 0xAFFFFF, 0xD70000, 14090335, 14090375, 14090415, 0xD700D7, 14090495, 14114560, 14114655, 14114695, 14114735, 14114775, 14114815, 14124800, 14124895, 0xD78787, 14124975, 0xD787D7, 14125055, 14135040, 14135135, 14135175, 14135215, 14135255, 14135295, 0xD7D700, 14145375, 0xD7D787, 14145455, 0xD7D7D7, 0xD7D7FF, 14155520, 14155615, 14155655, 14155695, 0xD7FFD7, 0xD7FFFF, 0xFF0000, 0xFF005F, 16711815, 0xFF00AF, 16711895, 0xFF00FF, 0xFF5F00, 0xFF5F5F, 16736135, 0xFF5FAF, 16736215, 0xFF5FFF, 16746240, 16746335, 0xFF8787, 16746415, 16746455, 0xFF87FF, 0xFFAF00, 0xFFAF5F, 16756615, 0xFFAFAF, 16756695, 0xFFAFFF, 16766720, 16766815, 16766855, 16766895, 0xFFD7D7, 0xFFD7FF, 0xFFFF00, 0xFFFF5F, 0xFFFF87, 0xFFFFAF, 0xFFFFD7, 0xFFFFFF, 526344, 0x121212, 0x1C1C1C, 0x262626, 0x303030, 0x3A3A3A, 0x444444, 0x4E4E4E, 0x585858, 0x626262, 0x6C6C6C, 0x767676, 0x808080, 0x8A8A8A, 0x949494, 0x9E9E9E, 0xA8A8A8, 0xB2B2B2, 0xBCBCBC, 0xC6C6C6, 0xD0D0D0, 0xDADADA, 0xE4E4E4, 0xEEEEEE};
    public static final double[] D50 = new double[]{96.422f, 100.0, 82.521f};
    public static final double[] D65 = new double[]{95.047, 100.0, 108.883};
    public static final double[] averageSurrounding = new double[]{1.0, 0.69, 1.0};
    public static final double[] dimSurrounding = new double[]{0.9, 0.59, 0.9};
    public static final double[] darkSurrounding = new double[]{0.8, 0.525, 0.8};
    public static final double[] sRGB_encoding_environment = Colors.vc(D50, 64.0, 12.0, dimSurrounding);
    public static final double[] sRGB_typical_environment = Colors.vc(D50, 200.0, 40.0, averageSurrounding);
    public static final double[] AdobeRGB_environment = Colors.vc(D65, 160.0, 32.0, averageSurrounding);
    private static int[] COLORS_256 = DEFAULT_COLORS_256;
    private static Map<String, Integer> COLOR_NAMES;
    private static final int L = 0;
    private static final int A = 1;
    private static final int B = 2;
    private static final int X = 0;
    private static final int Y = 1;
    private static final int Z = 2;
    private static final double kl = 2.0;
    private static final double kc = 1.0;
    private static final double kh = 1.0;
    private static final double k1 = 0.045;
    private static final double k2 = 0.015;
    public static final int J = 0;
    public static final int Q = 1;
    public static final int C = 2;
    public static final int M = 3;
    public static final int s = 4;
    public static final int H = 5;
    public static final int h = 6;
    static final int SUR_F = 0;
    static final int SUR_C = 1;
    static final int SUR_N_C = 2;
    static final int VC_X_W = 0;
    static final int VC_Y_W = 1;
    static final int VC_Z_W = 2;
    static final int VC_L_A = 3;
    static final int VC_Y_B = 4;
    static final int VC_F = 5;
    static final int VC_C = 6;
    static final int VC_N_C = 7;
    static final int VC_Z = 8;
    static final int VC_N = 9;
    static final int VC_N_BB = 10;
    static final int VC_N_CB = 11;
    static final int VC_A_W = 12;
    static final int VC_F_L = 13;
    static final int VC_D_RGB_R = 14;
    static final int VC_D_RGB_G = 15;
    static final int VC_D_RGB_B = 16;
    private static final double epsilon = 0.008856451679035631;
    private static final double kappa = 903.2962962962963;

    public static void setRgbColors(int[] nArray) {
        if (nArray == null || nArray.length != 256) {
            throw new IllegalArgumentException();
        }
        COLORS_256 = nArray;
    }

    public static int rgbColor(int n) {
        return COLORS_256[n];
    }

    public static Integer rgbColor(String string2) {
        if (COLOR_NAMES == null) {
            LinkedHashMap<String, Integer> linkedHashMap = new LinkedHashMap<String, Integer>();
            try (InputStream inputStream = InfoCmp.class.getResourceAsStream("colors.txt");
                 BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
                bufferedReader.lines().map(String::trim).filter(string -> !string.startsWith("#")).filter(string -> !string.isEmpty()).forEachOrdered(string -> linkedHashMap.put((String)string, linkedHashMap.size()));
                COLOR_NAMES = linkedHashMap;
            }
            catch (IOException iOException) {
                throw new IOError(iOException);
            }
        }
        return COLOR_NAMES.get(string2);
    }

    public static int roundColor(int n, int n2) {
        return Colors.roundColor(n, n2, null);
    }

    public static int roundColor(int n, int n2, String string) {
        if (n >= n2) {
            int n3 = COLORS_256[n];
            n = Colors.roundColor(n3, COLORS_256, n2, string);
        }
        return n;
    }

    public static int roundRgbColor(int n, int n2, int n3, int n4) {
        return Colors.roundColor((n << 16) + (n2 << 8) + n3, COLORS_256, n4, (String)null);
    }

    private static int roundColor(int n, int[] nArray, int n2, String string) {
        return Colors.roundColor(n, nArray, n2, Colors.getDistance(string));
    }

    private static int roundColor(int n, int[] nArray, int n2, Distance distance) {
        double d = 2.147483647E9;
        int n3 = Integer.MAX_VALUE;
        for (int i = 0; i < n2; ++i) {
            double d2 = distance.compute(n, nArray[i]);
            if (!(d2 <= d)) continue;
            n3 = i;
            d = d2;
        }
        return n3;
    }

    private static Distance getDistance(String string) {
        if (string == null) {
            string = System.getProperty("org.jline.utils.colorDistance", "cie76");
        }
        return Colors.doGetDistance(string);
    }

    private static Distance doGetDistance(String string) {
        if (string.equals("rgb")) {
            return (n, n2) -> {
                double[] dArray = Colors.rgb(n);
                double[] dArray2 = Colors.rgb(n2);
                double d = (dArray[0] + dArray2[0]) / 2.0;
                double[] dArray3 = new double[]{2.0 + d, 4.0, 3.0 - d};
                return Colors.scalar(dArray, dArray2, dArray3);
            };
        }
        if (string.matches("rgb\\(([0-9]+(\\.[0-9]+)?),([0-9]+(\\.[0-9]+)?),([0-9]+(\\.[0-9]+)?)\\)")) {
            return (n, n2) -> Colors.scalar(Colors.rgb(n), Colors.rgb(n2), Colors.getWeights(string));
        }
        if (string.equals("lab") || string.equals("cie76")) {
            return (n, n2) -> Colors.scalar(Colors.rgb2cielab(n), Colors.rgb2cielab(n2));
        }
        if (string.matches("lab\\(([0-9]+(\\.[0-9]+)?),([0-9]+(\\.[0-9]+)?)\\)")) {
            double[] dArray = Colors.getWeights(string);
            return (n, n2) -> Colors.scalar(Colors.rgb2cielab(n), Colors.rgb2cielab(n2), new double[]{dArray[0], dArray[1], dArray[1]});
        }
        if (string.equals("cie94")) {
            return (n, n2) -> Colors.cie94(Colors.rgb2cielab(n), Colors.rgb2cielab(n2));
        }
        if (string.equals("cie00") || string.equals("cie2000")) {
            return (n, n2) -> Colors.cie00(Colors.rgb2cielab(n), Colors.rgb2cielab(n2));
        }
        if (string.equals("cam02")) {
            return (n, n2) -> Colors.cam02(n, n2, sRGB_typical_environment);
        }
        if (string.equals("camlab")) {
            return (n, n2) -> {
                double[] dArray = Colors.camlab(n, sRGB_typical_environment);
                double[] dArray2 = Colors.camlab(n2, sRGB_typical_environment);
                return Colors.scalar(dArray, dArray2);
            };
        }
        if (string.matches("camlab\\(([0-9]+(\\.[0-9]+)?),([0-9]+(\\.[0-9]+)?)\\)")) {
            return (n, n2) -> {
                double[] dArray = Colors.camlab(n, sRGB_typical_environment);
                double[] dArray2 = Colors.camlab(n2, sRGB_typical_environment);
                double[] dArray3 = Colors.getWeights(string);
                return Colors.scalar(dArray, dArray2, new double[]{dArray3[0], dArray3[1], dArray3[1]});
            };
        }
        if (string.matches("camlch")) {
            return (n, n2) -> {
                double[] dArray = Colors.camlch(n, sRGB_typical_environment);
                double[] dArray2 = Colors.camlch(n2, sRGB_typical_environment);
                return Colors.camlch(dArray, dArray2);
            };
        }
        if (string.matches("camlch\\(([0-9]+(\\.[0-9]+)?),([0-9]+(\\.[0-9]+)?),([0-9]+(\\.[0-9]+)?)\\)")) {
            return (n, n2) -> {
                double[] dArray = Colors.camlch(n, sRGB_typical_environment);
                double[] dArray2 = Colors.camlch(n2, sRGB_typical_environment);
                double[] dArray3 = Colors.getWeights(string);
                return Colors.camlch(dArray, dArray2, dArray3);
            };
        }
        throw new IllegalArgumentException("Unsupported distance function: " + string);
    }

    private static double[] getWeights(String string) {
        String[] stringArray = string.substring(string.indexOf(40) + 1, string.length() - 1).split(",");
        return Stream.of(stringArray).mapToDouble(Double::parseDouble).toArray();
    }

    private static double scalar(double[] dArray, double[] dArray2, double[] dArray3) {
        return Colors.sqr((dArray[0] - dArray2[0]) * dArray3[0]) + Colors.sqr((dArray[1] - dArray2[1]) * dArray3[1]) + Colors.sqr((dArray[2] - dArray2[2]) * dArray3[2]);
    }

    private static double scalar(double[] dArray, double[] dArray2) {
        return Colors.sqr(dArray[0] - dArray2[0]) + Colors.sqr(dArray[1] - dArray2[1]) + Colors.sqr(dArray[2] - dArray2[2]);
    }

    private static double cie94(double[] dArray, double[] dArray2) {
        double d;
        double d2 = dArray[0] - dArray2[0];
        double d3 = dArray[1] - dArray2[1];
        double d4 = dArray[2] - dArray2[2];
        double d5 = Math.sqrt(dArray[1] * dArray[1] + dArray[2] * dArray[2]);
        double d6 = d5 - (d = Math.sqrt(dArray2[1] * dArray2[1] + dArray2[2] * dArray2[2]));
        double d7 = d3 * d3 + d4 * d4 - d6 * d6;
        d7 = d7 < 0.0 ? 0.0 : Math.sqrt(d7);
        double d8 = 1.0;
        double d9 = 1.0 + 0.045 * d5;
        double d10 = 1.0 + 0.015 * d5;
        double d11 = d2 / (2.0 * d8);
        double d12 = d6 / (1.0 * d9);
        double d13 = d7 / (1.0 * d10);
        return d11 * d11 + d12 * d12 + d13 * d13;
    }

    private static double cie00(double[] dArray, double[] dArray2) {
        double d = Math.sqrt(dArray[1] * dArray[1] + dArray[2] * dArray[2]);
        double d2 = Math.sqrt(dArray2[1] * dArray2[1] + dArray2[2] * dArray2[2]);
        double d3 = (d + d2) / 2.0;
        double d4 = d3 * d3 * d3;
        double d5 = d4 * d4 * d3;
        double d6 = 0.5 * (1.0 - Math.sqrt(d5 / (d5 + 6.103515625E9)));
        double d7 = (1.0 + d6) * dArray[1];
        double d8 = (1.0 + d6) * dArray2[1];
        double d9 = Math.sqrt(d7 * d7 + dArray[2] * dArray[2]);
        double d10 = Math.sqrt(d8 * d8 + dArray2[2] * dArray2[2]);
        double d11 = (Math.toDegrees(Math.atan2(dArray[2], d7)) + 360.0) % 360.0;
        double d12 = (Math.toDegrees(Math.atan2(dArray2[2], d8)) + 360.0) % 360.0;
        double d13 = dArray2[0] - dArray[0];
        double d14 = d10 - d9;
        double d15 = Math.abs(d11 - d12);
        double d16 = d9 * d10 == 0.0 ? 0.0 : (d15 <= 180.0 ? d12 - d11 : (d12 <= d11 ? d12 - d11 + 360.0 : d12 - d11 - 360.0));
        double d17 = 2.0 * Math.sqrt(d9 * d10) * Math.sin(Math.toRadians(d16 / 2.0));
        double d18 = (dArray[0] + dArray2[0]) / 2.0;
        double d19 = (d9 + d10) / 2.0;
        double d20 = d9 * d10 == 0.0 ? 0.0 : (d15 <= 180.0 ? (d11 + d12) / 2.0 : (d11 + d12 < 360.0 ? (d11 + d12 + 360.0) / 2.0 : (d11 + d12 - 360.0) / 2.0));
        double d21 = d18 - 50.0;
        double d22 = d21 * d21;
        double d23 = 1.0 - 0.17 * Math.cos(Math.toRadians(d20 - 30.0)) + 0.24 * Math.cos(Math.toRadians(d20 * 2.0)) + 0.32 * Math.cos(Math.toRadians(d20 * 3.0 + 6.0)) - 0.2 * Math.cos(Math.toRadians(d20 * 4.0 - 63.0));
        double d24 = 1.0 + 0.015 * d22 / Math.sqrt(20.0 + d22);
        double d25 = 1.0 + 0.045 * d19;
        double d26 = 1.0 + 0.015 * d23 * d19;
        double d27 = (d20 - 275.0) / 25.0;
        double d28 = d27 * d27;
        double d29 = 30.0 * Math.exp(-d28);
        double d30 = d19 * d19 * d19;
        double d31 = d30 * d30 * d19;
        double d32 = 2.0 * Math.sqrt(d31 / (d31 + 6.103515625E9));
        double d33 = -Math.sin(Math.toRadians(2.0 * d29)) * d32;
        double d34 = d13 / (2.0 * d24);
        double d35 = d14 / (1.0 * d25);
        double d36 = d17 / (1.0 * d26);
        return d34 * d34 + d35 * d35 + d36 * d36 + d33 * d35 * d36;
    }

    private static double cam02(int n, int n2, double[] dArray) {
        double[] dArray2 = Colors.jmh2ucs(Colors.camlch(n, dArray));
        double[] dArray3 = Colors.jmh2ucs(Colors.camlch(n2, dArray));
        return Colors.scalar(dArray2, dArray3);
    }

    private static double[] jmh2ucs(double[] dArray) {
        double d = 1.7000000000000002 * dArray[0] / (1.0 + 0.007 * dArray[0]);
        double d2 = 43.859649122807014 * Math.log(1.0 + 0.0228 * dArray[1]);
        double d3 = d2 * Math.cos(Math.toRadians(dArray[2]));
        double d4 = d2 * Math.sin(Math.toRadians(dArray[2]));
        return new double[]{d, d3, d4};
    }

    static double camlch(double[] dArray, double[] dArray2) {
        return Colors.camlch(dArray, dArray2, new double[]{1.0, 1.0, 1.0});
    }

    static double camlch(double[] dArray, double[] dArray2, double[] dArray3) {
        double d = dArray3[0] / 100.0;
        double d2 = dArray3[1] / 120.0;
        double d3 = dArray3[2] / 360.0;
        double d4 = (dArray[0] - dArray2[0]) * d;
        double d5 = (dArray[1] - dArray2[1]) * d2;
        double d6 = Colors.hueDifference(dArray[2], dArray2[2], 360.0) * d3;
        return d4 * d4 + d5 * d5 + d6 * d6;
    }

    private static double hueDifference(double d, double d2, double d3) {
        double d4 = (d2 - d) % d3;
        double d5 = d3 / 2.0;
        if (d4 > d5) {
            d4 -= d3;
        }
        if (d4 < -d5) {
            d4 += d3;
        }
        return d4;
    }

    private static double[] rgb(int n) {
        int n2 = n >> 16 & 0xFF;
        int n3 = n >> 8 & 0xFF;
        int n4 = n >> 0 & 0xFF;
        return new double[]{(double)n2 / 255.0, (double)n3 / 255.0, (double)n4 / 255.0};
    }

    static double[] rgb2xyz(int n) {
        return Colors.rgb2xyz(Colors.rgb(n));
    }

    static double[] rgb2cielab(int n) {
        return Colors.rgb2cielab(Colors.rgb(n));
    }

    static double[] camlch(int n) {
        return Colors.camlch(n, sRGB_typical_environment);
    }

    static double[] camlch(int n, double[] dArray) {
        return Colors.xyz2camlch(Colors.rgb2xyz(n), dArray);
    }

    static double[] camlab(int n) {
        return Colors.camlab(n, sRGB_typical_environment);
    }

    static double[] camlab(int n, double[] dArray) {
        return Colors.lch2lab(Colors.camlch(n, dArray));
    }

    static double[] lch2lab(double[] dArray) {
        double d = Math.PI / 180;
        return new double[]{dArray[0], dArray[1] * Math.cos(dArray[2] * d), dArray[1] * Math.sin(dArray[2] * d)};
    }

    private static double[] xyz2camlch(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[]{dArray[0] * 100.0, dArray[1] * 100.0, dArray[2] * 100.0};
        double[] dArray4 = Colors.forwardTransform(dArray3, dArray2);
        return new double[]{dArray4[0], dArray4[3], dArray4[6]};
    }

    private static double[] forwardTransform(double[] dArray, double[] dArray2) {
        double[] dArray3 = Colors.forwardPreAdaptationConeResponse(dArray);
        double[] dArray4 = Colors.forwardPostAdaptationConeResponse(dArray3, dArray2);
        double[] dArray5 = Colors.CAT02toHPE(dArray4);
        double[] dArray6 = Colors.forwardResponseCompression(dArray5, dArray2);
        double d = (2.0 * dArray6[0] + dArray6[1] + dArray6[2] / 20.0 - 0.305) * dArray2[10];
        double d2 = 100.0 * Math.pow(d / dArray2[12], dArray2[8] * dArray2[6]);
        double d3 = dArray6[0] + (-12.0 * dArray6[1] + dArray6[2]) / 11.0;
        double d4 = (dArray6[0] + dArray6[1] - 2.0 * dArray6[2]) / 9.0;
        double d5 = (Math.toDegrees(Math.atan2(d4, d3)) + 360.0) % 360.0;
        double d6 = 961.5384615384615 * dArray2[7] * dArray2[11] * (Math.cos(Math.toRadians(d5) + 2.0) + 3.8);
        double d7 = d6 * Math.sqrt(Math.pow(d3, 2.0) + Math.pow(d4, 2.0)) / (dArray6[0] + dArray6[1] + 1.05 * dArray6[2]);
        double d8 = 4.0 / dArray2[6] * Math.sqrt(d2 / 100.0) * (dArray2[12] + 4.0) * Math.pow(dArray2[13], 0.25);
        double d9 = Math.signum(d7) * Math.pow(Math.abs(d7), 0.9) * Math.sqrt(d2 / 100.0) * Math.pow(1.64 - Math.pow(0.29, dArray2[9]), 0.73);
        double d10 = d9 * Math.pow(dArray2[13], 0.25);
        double d11 = 100.0 * Math.sqrt(d10 / d8);
        double d12 = Colors.calculateH(d5);
        return new double[]{d2, d8, d9, d10, d11, d12, d5};
    }

    private static double calculateH(double d) {
        if (d < 20.14) {
            d += 360.0;
        }
        if (d >= 20.14 && d < 90.0) {
            double d2 = (d - 20.14) / 0.8;
            return 100.0 * d2 / (d2 + (90.0 - d) / 0.7);
        }
        if (d < 164.25) {
            double d3 = (d - 90.0) / 0.7;
            return 100.0 + 100.0 * d3 / (d3 + (164.25 - d) / 1.0);
        }
        if (d < 237.53) {
            double d4 = (d - 164.25) / 1.0;
            return 200.0 + 100.0 * d4 / (d4 + (237.53 - d) / 1.2);
        }
        if (d <= 380.14) {
            double d5 = (d - 237.53) / 1.2;
            double d6 = 300.0 + 100.0 * d5 / (d5 + (380.14 - d) / 0.8);
            if (d6 <= 400.0 && d6 >= 399.999) {
                d6 = 0.0;
            }
            return d6;
        }
        throw new IllegalArgumentException("h outside assumed range 0..360: " + Double.toString(d));
    }

    private static double[] forwardResponseCompression(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[3];
        for (int i = 0; i < dArray.length; ++i) {
            double d;
            if (dArray[i] >= 0.0) {
                d = Math.pow(dArray2[13] * dArray[i] / 100.0, 0.42);
                dArray3[i] = 400.0 * d / (d + 27.13) + 0.1;
                continue;
            }
            d = Math.pow(-1.0 * dArray2[13] * dArray[i] / 100.0, 0.42);
            dArray3[i] = -400.0 * d / (d + 27.13) + 0.1;
        }
        return dArray3;
    }

    private static double[] forwardPostAdaptationConeResponse(double[] dArray, double[] dArray2) {
        return new double[]{dArray2[14] * dArray[0], dArray2[15] * dArray[1], dArray2[16] * dArray[2]};
    }

    public static double[] CAT02toHPE(double[] dArray) {
        double[] dArray2 = new double[]{0.7409792 * dArray[0] + 0.218025 * dArray[1] + 0.0410058 * dArray[2], 0.2853532 * dArray[0] + 0.6242014 * dArray[1] + 0.0904454 * dArray[2], -0.009628 * dArray[0] - 0.005698 * dArray[1] + 1.015326 * dArray[2]};
        return dArray2;
    }

    private static double[] forwardPreAdaptationConeResponse(double[] dArray) {
        double[] dArray2 = new double[]{0.7328 * dArray[0] + 0.4296 * dArray[1] - 0.1624 * dArray[2], -0.7036 * dArray[0] + 1.6975 * dArray[1] + 0.0061 * dArray[2], 0.003 * dArray[0] + 0.0136 * dArray[1] + 0.9834 * dArray[2]};
        return dArray2;
    }

    static double[] vc(double[] dArray, double d, double d2, double[] dArray2) {
        double[] dArray3 = new double[17];
        dArray3[0] = dArray[0];
        dArray3[1] = dArray[1];
        dArray3[2] = dArray[2];
        dArray3[3] = d;
        dArray3[4] = d2;
        dArray3[5] = dArray2[0];
        dArray3[6] = dArray2[1];
        dArray3[7] = dArray2[2];
        double[] dArray4 = Colors.forwardPreAdaptationConeResponse(dArray);
        double d3 = Math.max(0.0, Math.min(1.0, dArray3[5] * (1.0 - 0.2777777777777778 * Math.pow(Math.E, (-d - 42.0) / 92.0))));
        double d4 = dArray[1];
        double[] dArray5 = new double[]{d3 * d4 / dArray4[0] + (1.0 - d3), d3 * d4 / dArray4[1] + (1.0 - d3), d3 * d4 / dArray4[2] + (1.0 - d3)};
        double d5 = 5.0 * d;
        double d6 = 1.0 / (d5 + 1.0);
        double d7 = Math.pow(d6, 4.0);
        dArray3[13] = 0.2 * d7 * d5 + 0.1 * Math.pow(1.0 - d7, 2.0) * Math.pow(d5, 0.3333333333333333);
        dArray3[9] = d2 / d4;
        dArray3[8] = 1.48 + Math.sqrt(dArray3[9]);
        dArray3[10] = 0.725 * Math.pow(1.0 / dArray3[9], 0.2);
        dArray3[11] = dArray3[10];
        double[] dArray6 = new double[]{dArray5[0] * dArray4[0], dArray5[1] * dArray4[1], dArray5[2] * dArray4[2]};
        double[] dArray7 = Colors.CAT02toHPE(dArray6);
        double[] dArray8 = new double[3];
        for (int i = 0; i < dArray7.length; ++i) {
            double d8;
            if (dArray7[i] >= 0.0) {
                d8 = Math.pow(dArray3[13] * dArray7[i] / 100.0, 0.42);
                dArray8[i] = 400.0 * d8 / (d8 + 27.13) + 0.1;
                continue;
            }
            d8 = Math.pow(-1.0 * dArray3[13] * dArray7[i] / 100.0, 0.42);
            dArray8[i] = -400.0 * d8 / (d8 + 27.13) + 0.1;
        }
        dArray3[12] = (2.0 * dArray8[0] + dArray8[1] + dArray8[2] / 20.0 - 0.305) * dArray3[10];
        dArray3[14] = dArray5[0];
        dArray3[15] = dArray5[1];
        dArray3[16] = dArray5[2];
        return dArray3;
    }

    public static double[] rgb2cielab(double[] dArray) {
        return Colors.xyz2lab(Colors.rgb2xyz(dArray));
    }

    private static double[] rgb2xyz(double[] dArray) {
        double d = Colors.pivotRgb(dArray[0]);
        double d2 = Colors.pivotRgb(dArray[1]);
        double d3 = Colors.pivotRgb(dArray[2]);
        double d4 = d * 0.4124564 + d2 * 0.3575761 + d3 * 0.1804375;
        double d5 = d * 0.2126729 + d2 * 0.7151522 + d3 * 0.072175;
        double d6 = d * 0.0193339 + d2 * 0.119192 + d3 * 0.9503041;
        return new double[]{d4, d5, d6};
    }

    private static double pivotRgb(double d) {
        return d > 0.04045 ? Math.pow((d + 0.055) / 1.055, 2.4) : d / 12.92;
    }

    private static double[] xyz2lab(double[] dArray) {
        double d = Colors.pivotXyz(dArray[0]);
        double d2 = Colors.pivotXyz(dArray[1]);
        double d3 = Colors.pivotXyz(dArray[2]);
        double d4 = 116.0 * d2 - 16.0;
        double d5 = 500.0 * (d - d2);
        double d6 = 200.0 * (d2 - d3);
        return new double[]{d4, d5, d6};
    }

    private static double pivotXyz(double d) {
        return d > 0.008856451679035631 ? Math.cbrt(d) : (903.2962962962963 * d + 16.0) / 116.0;
    }

    private static double sqr(double d) {
        return d * d;
    }

    private static interface Distance {
        public double compute(int var1, int var2);
    }
}

