/*
 * Decompiled with CFR 0.152.
 */
package org.jline.utils;

import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jline.utils.AttributedCharSequence;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStyle;

public class AttributedStringBuilder
extends AttributedCharSequence
implements Appendable {
    private char[] buffer;
    private int[] style;
    private int length;
    private int tabs = 0;
    private int lastLineLength = 0;
    private AttributedStyle current = AttributedStyle.DEFAULT;

    public static AttributedString append(CharSequence ... charSequenceArray) {
        AttributedStringBuilder attributedStringBuilder = new AttributedStringBuilder();
        for (CharSequence charSequence : charSequenceArray) {
            attributedStringBuilder.append(charSequence);
        }
        return attributedStringBuilder.toAttributedString();
    }

    public AttributedStringBuilder() {
        this(64);
    }

    public AttributedStringBuilder(int n) {
        this.buffer = new char[n];
        this.style = new int[n];
        this.length = 0;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public char charAt(int n) {
        return this.buffer[n];
    }

    @Override
    public AttributedStyle styleAt(int n) {
        return new AttributedStyle(this.style[n], this.style[n]);
    }

    @Override
    int styleCodeAt(int n) {
        return this.style[n];
    }

    @Override
    protected char[] buffer() {
        return this.buffer;
    }

    @Override
    protected int offset() {
        return 0;
    }

    @Override
    public AttributedString subSequence(int n, int n2) {
        return new AttributedString(Arrays.copyOfRange(this.buffer, n, n2), Arrays.copyOfRange(this.style, n, n2), 0, n2 - n);
    }

    @Override
    public AttributedStringBuilder append(CharSequence charSequence) {
        return this.append(new AttributedString(charSequence, this.current));
    }

    @Override
    public AttributedStringBuilder append(CharSequence charSequence, int n, int n2) {
        return this.append(charSequence.subSequence(n, n2));
    }

    @Override
    public AttributedStringBuilder append(char c) {
        return this.append(Character.toString(c));
    }

    public AttributedStringBuilder append(CharSequence charSequence, AttributedStyle attributedStyle) {
        return this.append(new AttributedString(charSequence, attributedStyle));
    }

    public AttributedStringBuilder style(AttributedStyle attributedStyle) {
        this.current = attributedStyle;
        return this;
    }

    public AttributedStringBuilder style(Function<AttributedStyle, AttributedStyle> function) {
        this.current = function.apply(this.current);
        return this;
    }

    public AttributedStringBuilder styled(Function<AttributedStyle, AttributedStyle> function, CharSequence charSequence) {
        return this.styled(function, (AttributedStringBuilder attributedStringBuilder) -> attributedStringBuilder.append(charSequence));
    }

    public AttributedStringBuilder styled(AttributedStyle attributedStyle, CharSequence charSequence) {
        return this.styled((AttributedStyle attributedStyle2) -> attributedStyle, (AttributedStringBuilder attributedStringBuilder) -> attributedStringBuilder.append(charSequence));
    }

    public AttributedStringBuilder styled(Function<AttributedStyle, AttributedStyle> function, Consumer<AttributedStringBuilder> consumer) {
        AttributedStyle attributedStyle = this.current;
        this.current = function.apply(attributedStyle);
        consumer.accept(this);
        this.current = attributedStyle;
        return this;
    }

    public AttributedStyle style() {
        return this.current;
    }

    public AttributedStringBuilder append(AttributedString attributedString) {
        return this.append((AttributedCharSequence)attributedString, 0, attributedString.length());
    }

    public AttributedStringBuilder append(AttributedString attributedString, int n, int n2) {
        return this.append((AttributedCharSequence)attributedString, n, n2);
    }

    public AttributedStringBuilder append(AttributedCharSequence attributedCharSequence) {
        return this.append(attributedCharSequence, 0, attributedCharSequence.length());
    }

    public AttributedStringBuilder append(AttributedCharSequence attributedCharSequence, int n, int n2) {
        this.ensureCapacity(this.length + n2 - n);
        for (int i = n; i < n2; ++i) {
            char c = attributedCharSequence.charAt(i);
            int n3 = attributedCharSequence.styleCodeAt(i) & ~this.current.getMask() | this.current.getStyle();
            if (this.tabs > 0 && c == '\t') {
                this.insertTab(new AttributedStyle(n3, 0));
                continue;
            }
            this.ensureCapacity(this.length + 1);
            this.buffer[this.length] = c;
            this.style[this.length] = n3;
            this.lastLineLength = c == '\n' ? 0 : ++this.lastLineLength;
            ++this.length;
        }
        return this;
    }

    protected void ensureCapacity(int n) {
        if (n > this.buffer.length) {
            int n2;
            for (n2 = Math.max(this.buffer.length, 1); n2 <= n; n2 *= 2) {
            }
            this.buffer = Arrays.copyOf(this.buffer, n2);
            this.style = Arrays.copyOf(this.style, n2);
        }
    }

    public void appendAnsi(String string) {
        this.ansiAppend(string);
    }

    public AttributedStringBuilder ansiAppend(String string) {
        int n = 0;
        int n2 = 0;
        this.ensureCapacity(this.length + string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (n2 == 0 && c == '\u001b') {
                ++n2;
                continue;
            }
            if (n2 == 1 && c == '[') {
                ++n2;
                n = i + 1;
                continue;
            }
            if (n2 == 2) {
                if (c == 'm') {
                    String[] stringArray = string.substring(n, i).split(";");
                    block26: for (int j = 0; j < stringArray.length; ++j) {
                        int n3 = stringArray[j].isEmpty() ? 0 : Integer.parseInt(stringArray[j]);
                        switch (n3) {
                            case 0: {
                                this.current = AttributedStyle.DEFAULT;
                                continue block26;
                            }
                            case 1: {
                                this.current = this.current.bold();
                                continue block26;
                            }
                            case 2: {
                                this.current = this.current.faint();
                                continue block26;
                            }
                            case 3: {
                                this.current = this.current.italic();
                                continue block26;
                            }
                            case 4: {
                                this.current = this.current.underline();
                                continue block26;
                            }
                            case 5: {
                                this.current = this.current.blink();
                                continue block26;
                            }
                            case 7: {
                                this.current = this.current.inverse();
                                continue block26;
                            }
                            case 8: {
                                this.current = this.current.conceal();
                                continue block26;
                            }
                            case 9: {
                                this.current = this.current.crossedOut();
                                continue block26;
                            }
                            case 22: {
                                this.current = this.current.boldOff().faintOff();
                                continue block26;
                            }
                            case 23: {
                                this.current = this.current.italicOff();
                                continue block26;
                            }
                            case 24: {
                                this.current = this.current.underlineOff();
                                continue block26;
                            }
                            case 25: {
                                this.current = this.current.blinkOff();
                                continue block26;
                            }
                            case 27: {
                                this.current = this.current.inverseOff();
                                continue block26;
                            }
                            case 28: {
                                this.current = this.current.concealOff();
                                continue block26;
                            }
                            case 29: {
                                this.current = this.current.crossedOutOff();
                                continue block26;
                            }
                            case 30: 
                            case 31: 
                            case 32: 
                            case 33: 
                            case 34: 
                            case 35: 
                            case 36: 
                            case 37: {
                                this.current = this.current.foreground(n3 - 30);
                                continue block26;
                            }
                            case 39: {
                                this.current = this.current.foregroundOff();
                                continue block26;
                            }
                            case 40: 
                            case 41: 
                            case 42: 
                            case 43: 
                            case 44: 
                            case 45: 
                            case 46: 
                            case 47: {
                                this.current = this.current.background(n3 - 40);
                                continue block26;
                            }
                            case 49: {
                                this.current = this.current.backgroundOff();
                                continue block26;
                            }
                            case 38: 
                            case 48: {
                                int n4;
                                int n5;
                                if (j + 1 >= stringArray.length) continue block26;
                                if ((n5 = Integer.parseInt(stringArray[++j])) == 2) {
                                    if (j + 3 >= stringArray.length) continue block26;
                                    n4 = Integer.parseInt(stringArray[++j]);
                                    int n6 = Integer.parseInt(stringArray[++j]);
                                    int n7 = Integer.parseInt(stringArray[++j]);
                                    int n8 = 16 + (n4 >> 3) * 36 + (n6 >> 3) * 6 + (n7 >> 3);
                                    if (n3 == 38) {
                                        this.current = this.current.foreground(n8);
                                        continue block26;
                                    }
                                    this.current = this.current.background(n8);
                                    continue block26;
                                }
                                if (n5 != 5 || j + 1 >= stringArray.length) continue block26;
                                n4 = Integer.parseInt(stringArray[++j]);
                                if (n3 == 38) {
                                    this.current = this.current.foreground(n4);
                                    continue block26;
                                }
                                this.current = this.current.background(n4);
                                continue block26;
                            }
                            case 90: 
                            case 91: 
                            case 92: 
                            case 93: 
                            case 94: 
                            case 95: 
                            case 96: 
                            case 97: {
                                this.current = this.current.foreground(n3 - 90 + 8);
                                continue block26;
                            }
                            case 100: 
                            case 101: 
                            case 102: 
                            case 103: 
                            case 104: 
                            case 105: 
                            case 106: 
                            case 107: {
                                this.current = this.current.background(n3 - 100 + 8);
                            }
                        }
                    }
                    n2 = 0;
                    continue;
                }
                if (c >= '0' && c <= '9' || c == ';') continue;
                n2 = 0;
                continue;
            }
            if (c == '\t' && this.tabs > 0) {
                this.insertTab(this.current);
                continue;
            }
            this.ensureCapacity(this.length + 1);
            this.buffer[this.length] = c;
            this.style[this.length] = this.current.getStyle();
            this.lastLineLength = c == '\n' ? 0 : ++this.lastLineLength;
            ++this.length;
        }
        return this;
    }

    protected void insertTab(AttributedStyle attributedStyle) {
        int n = this.tabs - this.lastLineLength % this.tabs;
        this.ensureCapacity(this.length + n);
        for (int i = 0; i < n; ++i) {
            this.buffer[this.length] = 32;
            this.style[this.length] = attributedStyle.getStyle();
            ++this.length;
        }
        this.lastLineLength += n;
    }

    public void setLength(int n) {
        this.length = n;
    }

    public AttributedStringBuilder tabs(int n) {
        if (this.length > 0) {
            throw new IllegalStateException("Cannot change tab size after appending text");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Tab size must be non negative");
        }
        this.tabs = n;
        return this;
    }

    public AttributedStringBuilder styleMatches(Pattern pattern, AttributedStyle attributedStyle) {
        Matcher matcher = pattern.matcher(this);
        while (matcher.find()) {
            for (int i = matcher.start(); i < matcher.end(); ++i) {
                this.style[i] = this.style[i] & ~attributedStyle.getMask() | attributedStyle.getStyle();
            }
        }
        return this;
    }
}

