/*
 * Decompiled with CFR 0.152.
 */
package org.jline.utils;

import java.security.InvalidParameterException;
import java.util.Arrays;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jline.utils.AttributedCharSequence;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;

public class AttributedString
extends AttributedCharSequence {
    final char[] buffer;
    final int[] style;
    final int start;
    final int end;
    public static final AttributedString EMPTY = new AttributedString("");
    public static final AttributedString NEWLINE = new AttributedString("\n");

    public AttributedString(CharSequence charSequence) {
        this(charSequence, 0, charSequence.length(), null);
    }

    public AttributedString(CharSequence charSequence, int n, int n2) {
        this(charSequence, n, n2, null);
    }

    public AttributedString(CharSequence charSequence, AttributedStyle attributedStyle) {
        this(charSequence, 0, charSequence.length(), attributedStyle);
    }

    public AttributedString(CharSequence charSequence, int n, int n2, AttributedStyle attributedStyle) {
        if (n2 < n) {
            throw new InvalidParameterException();
        }
        if (charSequence instanceof AttributedString) {
            AttributedString attributedString = (AttributedString)charSequence;
            this.buffer = attributedString.buffer;
            if (attributedStyle != null) {
                this.style = (int[])attributedString.style.clone();
                for (int i = 0; i < this.style.length; ++i) {
                    this.style[i] = this.style[i] & ~attributedStyle.getMask() | attributedStyle.getStyle();
                }
            } else {
                this.style = attributedString.style;
            }
            this.start = attributedString.start + n;
            this.end = attributedString.start + n2;
        } else if (charSequence instanceof AttributedStringBuilder) {
            AttributedStringBuilder attributedStringBuilder = (AttributedStringBuilder)charSequence;
            AttributedString attributedString = attributedStringBuilder.subSequence(n, n2);
            this.buffer = attributedString.buffer;
            this.style = attributedString.style;
            if (attributedStyle != null) {
                for (int i = 0; i < this.style.length; ++i) {
                    this.style[i] = this.style[i] & ~attributedStyle.getMask() | attributedStyle.getStyle();
                }
            }
            this.start = attributedString.start;
            this.end = attributedString.end;
        } else {
            int n3 = n2 - n;
            this.buffer = new char[n3];
            for (int i = 0; i < n3; ++i) {
                this.buffer[i] = charSequence.charAt(n + i);
            }
            this.style = new int[n3];
            if (attributedStyle != null) {
                Arrays.fill(this.style, attributedStyle.getStyle());
            }
            this.start = 0;
            this.end = n3;
        }
    }

    AttributedString(char[] cArray, int[] nArray, int n, int n2) {
        this.buffer = cArray;
        this.style = nArray;
        this.start = n;
        this.end = n2;
    }

    public static AttributedString fromAnsi(String string) {
        return AttributedString.fromAnsi(string, 0);
    }

    public static AttributedString fromAnsi(String string, int n) {
        if (string == null) {
            return null;
        }
        return new AttributedStringBuilder(string.length()).tabs(n).ansiAppend(string).toAttributedString();
    }

    public static String stripAnsi(String string) {
        if (string == null) {
            return null;
        }
        return new AttributedStringBuilder(string.length()).ansiAppend(string).toString();
    }

    @Override
    protected char[] buffer() {
        return this.buffer;
    }

    @Override
    protected int offset() {
        return this.start;
    }

    @Override
    public int length() {
        return this.end - this.start;
    }

    @Override
    public AttributedStyle styleAt(int n) {
        return new AttributedStyle(this.style[this.start + n], this.style[this.start + n]);
    }

    @Override
    int styleCodeAt(int n) {
        return this.style[this.start + n];
    }

    @Override
    public AttributedString subSequence(int n, int n2) {
        return new AttributedString(this, n, n2);
    }

    public AttributedString styleMatches(Pattern pattern, AttributedStyle attributedStyle) {
        Matcher matcher = pattern.matcher(this);
        boolean bl = matcher.find();
        if (bl) {
            int[] nArray = (int[])this.style.clone();
            do {
                for (int i = matcher.start(); i < matcher.end(); ++i) {
                    nArray[this.start + i] = nArray[this.start + i] & ~attributedStyle.getMask() | attributedStyle.getStyle();
                }
            } while (bl = matcher.find());
            return new AttributedString(this.buffer, nArray, this.start, this.end);
        }
        return this;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        AttributedString attributedString = (AttributedString)object;
        return this.end - this.start == attributedString.end - attributedString.start && this.arrEq(this.buffer, attributedString.buffer, this.start, attributedString.start, this.end - this.start) && this.arrEq(this.style, attributedString.style, this.start, attributedString.start, this.end - this.start);
    }

    private boolean arrEq(char[] cArray, char[] cArray2, int n, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            if (cArray[n + i] == cArray2[n2 + i]) continue;
            return false;
        }
        return true;
    }

    private boolean arrEq(int[] nArray, int[] nArray2, int n, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            if (nArray[n + i] == nArray2[n2 + i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = Arrays.hashCode(this.buffer);
        n = 31 * n + Arrays.hashCode(this.style);
        n = 31 * n + this.start;
        n = 31 * n + this.end;
        return n;
    }

    public static AttributedString join(AttributedString attributedString, AttributedString ... attributedStringArray) {
        Objects.requireNonNull(attributedString);
        Objects.requireNonNull(attributedStringArray);
        return AttributedString.join(attributedString, Arrays.asList(attributedStringArray));
    }

    public static AttributedString join(AttributedString attributedString, Iterable<AttributedString> iterable) {
        Objects.requireNonNull(iterable);
        AttributedStringBuilder attributedStringBuilder = new AttributedStringBuilder();
        int n = 0;
        for (AttributedString attributedString2 : iterable) {
            if (n++ > 0 && attributedString != null) {
                attributedStringBuilder.append(attributedString);
            }
            attributedStringBuilder.append(attributedString2);
        }
        return attributedStringBuilder.toAttributedString();
    }
}

