/*
 * Decompiled with CFR 0.152.
 */
package org.jline.utils;

import java.io.FilterWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import org.jline.utils.Colors;

public class AnsiWriter
extends FilterWriter {
    private static final char[] RESET_CODE = "\u001b[0m".toCharArray();
    private static final int MAX_ESCAPE_SEQUENCE_LENGTH = 100;
    private final char[] buffer = new char[100];
    private int pos = 0;
    private int startOfValue;
    private final ArrayList<Object> options = new ArrayList();
    private static final int LOOKING_FOR_FIRST_ESC_CHAR = 0;
    private static final int LOOKING_FOR_SECOND_ESC_CHAR = 1;
    private static final int LOOKING_FOR_NEXT_ARG = 2;
    private static final int LOOKING_FOR_STR_ARG_END = 3;
    private static final int LOOKING_FOR_INT_ARG_END = 4;
    private static final int LOOKING_FOR_OSC_COMMAND = 5;
    private static final int LOOKING_FOR_OSC_COMMAND_END = 6;
    private static final int LOOKING_FOR_OSC_PARAM = 7;
    private static final int LOOKING_FOR_ST = 8;
    private static final int LOOKING_FOR_CHARSET = 9;
    int state = 0;
    private static final int FIRST_ESC_CHAR = 27;
    private static final int SECOND_ESC_CHAR = 91;
    private static final int SECOND_OSC_CHAR = 93;
    private static final int BEL = 7;
    private static final int SECOND_ST_CHAR = 92;
    private static final int SECOND_CHARSET0_CHAR = 40;
    private static final int SECOND_CHARSET1_CHAR = 41;
    protected static final int ERASE_SCREEN_TO_END = 0;
    protected static final int ERASE_SCREEN_TO_BEGINING = 1;
    protected static final int ERASE_SCREEN = 2;
    protected static final int ERASE_LINE_TO_END = 0;
    protected static final int ERASE_LINE_TO_BEGINING = 1;
    protected static final int ERASE_LINE = 2;
    protected static final int ATTRIBUTE_INTENSITY_BOLD = 1;
    protected static final int ATTRIBUTE_INTENSITY_FAINT = 2;
    protected static final int ATTRIBUTE_ITALIC = 3;
    protected static final int ATTRIBUTE_UNDERLINE = 4;
    protected static final int ATTRIBUTE_BLINK_SLOW = 5;
    protected static final int ATTRIBUTE_BLINK_FAST = 6;
    protected static final int ATTRIBUTE_NEGATIVE_ON = 7;
    protected static final int ATTRIBUTE_CONCEAL_ON = 8;
    protected static final int ATTRIBUTE_UNDERLINE_DOUBLE = 21;
    protected static final int ATTRIBUTE_INTENSITY_NORMAL = 22;
    protected static final int ATTRIBUTE_UNDERLINE_OFF = 24;
    protected static final int ATTRIBUTE_BLINK_OFF = 25;
    @Deprecated
    protected static final int ATTRIBUTE_NEGATIVE_Off = 27;
    protected static final int ATTRIBUTE_NEGATIVE_OFF = 27;
    protected static final int ATTRIBUTE_CONCEAL_OFF = 28;
    protected static final int BLACK = 0;
    protected static final int RED = 1;
    protected static final int GREEN = 2;
    protected static final int YELLOW = 3;
    protected static final int BLUE = 4;
    protected static final int MAGENTA = 5;
    protected static final int CYAN = 6;
    protected static final int WHITE = 7;

    public AnsiWriter(Writer writer) {
        super(writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void write(int n) {
        switch (this.state) {
            case 0: {
                if (n == 27) {
                    this.buffer[this.pos++] = (char)n;
                    this.state = 1;
                    break;
                }
                this.out.write(n);
                break;
            }
            case 1: {
                this.buffer[this.pos++] = (char)n;
                if (n == 91) {
                    this.state = 2;
                    break;
                }
                if (n == 93) {
                    this.state = 5;
                    break;
                }
                if (n == 40) {
                    this.options.add(48);
                    this.state = 9;
                    break;
                }
                if (n == 41) {
                    this.options.add(49);
                    this.state = 9;
                    break;
                }
                this.reset(false);
                break;
            }
            case 2: {
                this.buffer[this.pos++] = (char)n;
                if (34 == n) {
                    this.startOfValue = this.pos - 1;
                    this.state = 3;
                    break;
                }
                if (48 <= n && n <= 57) {
                    this.startOfValue = this.pos - 1;
                    this.state = 4;
                    break;
                }
                if (59 == n) {
                    this.options.add(null);
                    break;
                }
                if (63 == n) {
                    this.options.add(Character.valueOf('?'));
                    break;
                }
                if (61 == n) {
                    this.options.add(Character.valueOf('='));
                    break;
                }
                boolean bl = true;
                try {
                    bl = this.processEscapeCommand(this.options, n);
                    break;
                }
                finally {
                    this.reset(bl);
                }
            }
            default: {
                break;
            }
            case 4: {
                this.buffer[this.pos++] = (char)n;
                if (48 <= n && n <= 57) break;
                String string = new String(this.buffer, this.startOfValue, this.pos - 1 - this.startOfValue);
                Integer n2 = new Integer(string);
                this.options.add(n2);
                if (n == 59) {
                    this.state = 2;
                    break;
                }
                boolean bl = true;
                try {
                    bl = this.processEscapeCommand(this.options, n);
                    break;
                }
                finally {
                    this.reset(bl);
                }
            }
            case 3: {
                this.buffer[this.pos++] = (char)n;
                if (34 == n) break;
                String string = new String(this.buffer, this.startOfValue, this.pos - 1 - this.startOfValue);
                this.options.add(string);
                if (n == 59) {
                    this.state = 2;
                    break;
                }
                this.reset(this.processEscapeCommand(this.options, n));
                break;
            }
            case 5: {
                this.buffer[this.pos++] = (char)n;
                if (48 <= n && n <= 57) {
                    this.startOfValue = this.pos - 1;
                    this.state = 6;
                    break;
                }
                this.reset(false);
                break;
            }
            case 6: {
                this.buffer[this.pos++] = (char)n;
                if (59 == n) {
                    String string = new String(this.buffer, this.startOfValue, this.pos - 1 - this.startOfValue);
                    Integer n3 = new Integer(string);
                    this.options.add(n3);
                    this.startOfValue = this.pos;
                    this.state = 7;
                    break;
                }
                if (48 <= n && n <= 57) break;
                this.reset(false);
                break;
            }
            case 7: {
                this.buffer[this.pos++] = (char)n;
                if (7 == n) {
                    String string = new String(this.buffer, this.startOfValue, this.pos - 1 - this.startOfValue);
                    this.options.add(string);
                    boolean bl = true;
                    try {
                        bl = this.processOperatingSystemCommand(this.options);
                        break;
                    }
                    finally {
                        this.reset(bl);
                    }
                }
                if (27 != n) break;
                this.state = 8;
                break;
            }
            case 8: {
                this.buffer[this.pos++] = (char)n;
                if (92 == n) {
                    String string = new String(this.buffer, this.startOfValue, this.pos - 2 - this.startOfValue);
                    this.options.add(string);
                    boolean bl = true;
                    try {
                        bl = this.processOperatingSystemCommand(this.options);
                        break;
                    }
                    finally {
                        this.reset(bl);
                    }
                }
                this.state = 7;
                break;
            }
            case 9: {
                this.options.add(Character.valueOf((char)n));
                this.reset(this.processCharsetSelect(this.options));
            }
        }
        if (this.pos >= this.buffer.length) {
            this.reset(false);
        }
    }

    private void reset(boolean bl) {
        if (!bl) {
            this.out.write(this.buffer, 0, this.pos);
        }
        this.pos = 0;
        this.startOfValue = 0;
        this.options.clear();
        this.state = 0;
    }

    private int getNextOptionInt(Iterator<Object> iterator) {
        Object object;
        do {
            if (iterator.hasNext()) continue;
            throw new IllegalArgumentException();
        } while ((object = iterator.next()) == null);
        return (Integer)object;
    }

    private boolean processEscapeCommand(ArrayList<Object> arrayList, int n) {
        try {
            switch (n) {
                case 65: {
                    this.processCursorUp(this.optionInt(arrayList, 0, 1));
                    return true;
                }
                case 66: {
                    this.processCursorDown(this.optionInt(arrayList, 0, 1));
                    return true;
                }
                case 67: {
                    this.processCursorRight(this.optionInt(arrayList, 0, 1));
                    return true;
                }
                case 68: {
                    this.processCursorLeft(this.optionInt(arrayList, 0, 1));
                    return true;
                }
                case 69: {
                    this.processCursorDownLine(this.optionInt(arrayList, 0, 1));
                    return true;
                }
                case 70: {
                    this.processCursorUpLine(this.optionInt(arrayList, 0, 1));
                    return true;
                }
                case 71: {
                    this.processCursorToColumn(this.optionInt(arrayList, 0));
                    return true;
                }
                case 72: 
                case 102: {
                    this.processCursorTo(this.optionInt(arrayList, 0, 1), this.optionInt(arrayList, 1, 1));
                    return true;
                }
                case 74: {
                    this.processEraseScreen(this.optionInt(arrayList, 0, 0));
                    return true;
                }
                case 75: {
                    this.processEraseLine(this.optionInt(arrayList, 0, 0));
                    return true;
                }
                case 76: {
                    this.processInsertLine(this.optionInt(arrayList, 0, 1));
                    return true;
                }
                case 77: {
                    this.processDeleteLine(this.optionInt(arrayList, 0, 1));
                    return true;
                }
                case 83: {
                    this.processScrollUp(this.optionInt(arrayList, 0, 1));
                    return true;
                }
                case 84: {
                    this.processScrollDown(this.optionInt(arrayList, 0, 1));
                    return true;
                }
                case 109: {
                    for (Object iterator2 : arrayList) {
                        if (iterator2 == null || iterator2.getClass() == Integer.class) continue;
                        throw new IllegalArgumentException();
                    }
                    int n2 = 0;
                    Iterator<Object> iterator = arrayList.iterator();
                    block27: while (iterator.hasNext()) {
                        Object object = iterator.next();
                        if (object == null) continue;
                        ++n2;
                        int n3 = (Integer)object;
                        if (30 <= n3 && n3 <= 37) {
                            this.processSetForegroundColor(n3 - 30);
                            continue;
                        }
                        if (40 <= n3 && n3 <= 47) {
                            this.processSetBackgroundColor(n3 - 40);
                            continue;
                        }
                        if (90 <= n3 && n3 <= 97) {
                            this.processSetForegroundColor(n3 - 90, true);
                            continue;
                        }
                        if (100 <= n3 && n3 <= 107) {
                            this.processSetBackgroundColor(n3 - 100, true);
                            continue;
                        }
                        if (n3 == 38 || n3 == 48) {
                            int n4;
                            int n5 = this.getNextOptionInt(iterator);
                            if (n5 == 2) {
                                n4 = this.getNextOptionInt(iterator);
                                int n6 = this.getNextOptionInt(iterator);
                                int n7 = this.getNextOptionInt(iterator);
                                if (n4 >= 0 && n4 <= 255 && n6 >= 0 && n6 <= 255 && n7 >= 0 && n7 <= 255) {
                                    if (n3 == 38) {
                                        this.processSetForegroundColorExt(n4, n6, n7);
                                        continue;
                                    }
                                    this.processSetBackgroundColorExt(n4, n6, n7);
                                    continue;
                                }
                                throw new IllegalArgumentException();
                            }
                            if (n5 == 5) {
                                n4 = this.getNextOptionInt(iterator);
                                if (n4 >= 0 && n4 <= 255) {
                                    if (n3 == 38) {
                                        this.processSetForegroundColorExt(n4);
                                        continue;
                                    }
                                    this.processSetBackgroundColorExt(n4);
                                    continue;
                                }
                                throw new IllegalArgumentException();
                            }
                            throw new IllegalArgumentException();
                        }
                        switch (n3) {
                            case 39: {
                                this.processDefaultTextColor();
                                continue block27;
                            }
                            case 49: {
                                this.processDefaultBackgroundColor();
                                continue block27;
                            }
                            case 0: {
                                this.processAttributeRest();
                                continue block27;
                            }
                        }
                        this.processSetAttribute(n3);
                    }
                    if (n2 == 0) {
                        this.processAttributeRest();
                    }
                    return true;
                }
                case 115: {
                    this.processSaveCursorPosition();
                    return true;
                }
                case 117: {
                    this.processRestoreCursorPosition();
                    return true;
                }
            }
            if (97 <= n && 122 <= n) {
                this.processUnknownExtension(arrayList, n);
                return true;
            }
            if (65 <= n && 90 <= n) {
                this.processUnknownExtension(arrayList, n);
                return true;
            }
            return false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    private boolean processOperatingSystemCommand(ArrayList<Object> arrayList) {
        int n = this.optionInt(arrayList, 0);
        String string = (String)arrayList.get(1);
        try {
            switch (n) {
                case 0: {
                    this.processChangeIconNameAndWindowTitle(string);
                    return true;
                }
                case 1: {
                    this.processChangeIconName(string);
                    return true;
                }
                case 2: {
                    this.processChangeWindowTitle(string);
                    return true;
                }
            }
            this.processUnknownOperatingSystemCommand(n, string);
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    protected void processRestoreCursorPosition() {
    }

    protected void processSaveCursorPosition() {
    }

    protected void processInsertLine(int n) {
    }

    protected void processDeleteLine(int n) {
    }

    protected void processScrollDown(int n) {
    }

    protected void processScrollUp(int n) {
    }

    protected void processEraseScreen(int n) {
    }

    protected void processEraseLine(int n) {
    }

    protected void processSetAttribute(int n) {
    }

    protected void processSetForegroundColor(int n) {
        this.processSetForegroundColor(n, false);
    }

    protected void processSetForegroundColor(int n, boolean bl) {
        this.processSetForegroundColorExt(bl ? n + 8 : n);
    }

    protected void processSetForegroundColorExt(int n) {
    }

    protected void processSetForegroundColorExt(int n, int n2, int n3) {
        this.processSetForegroundColorExt(Colors.roundRgbColor(n, n2, n3, 16));
    }

    protected void processSetBackgroundColor(int n) {
        this.processSetBackgroundColor(n, false);
    }

    protected void processSetBackgroundColor(int n, boolean bl) {
        this.processSetBackgroundColorExt(bl ? n + 8 : n);
    }

    protected void processSetBackgroundColorExt(int n) {
    }

    protected void processSetBackgroundColorExt(int n, int n2, int n3) {
        this.processSetBackgroundColorExt(Colors.roundRgbColor(n, n2, n3, 16));
    }

    protected void processDefaultTextColor() {
    }

    protected void processDefaultBackgroundColor() {
    }

    protected void processAttributeRest() {
    }

    protected void processCursorTo(int n, int n2) {
    }

    protected void processCursorToColumn(int n) {
    }

    protected void processCursorUpLine(int n) {
    }

    protected void processCursorDownLine(int n) {
        for (int i = 0; i < n; ++i) {
            this.out.write(10);
        }
    }

    protected void processCursorLeft(int n) {
    }

    protected void processCursorRight(int n) {
        for (int i = 0; i < n; ++i) {
            this.out.write(32);
        }
    }

    protected void processCursorDown(int n) {
    }

    protected void processCursorUp(int n) {
    }

    protected void processUnknownExtension(ArrayList<Object> arrayList, int n) {
    }

    protected void processChangeIconNameAndWindowTitle(String string) {
        this.processChangeIconName(string);
        this.processChangeWindowTitle(string);
    }

    protected void processChangeIconName(String string) {
    }

    protected void processChangeWindowTitle(String string) {
    }

    protected void processUnknownOperatingSystemCommand(int n, String string) {
    }

    private boolean processCharsetSelect(ArrayList<Object> arrayList) {
        int n = this.optionInt(arrayList, 0);
        char c = ((Character)arrayList.get(1)).charValue();
        this.processCharsetSelect(n, c);
        return true;
    }

    protected void processCharsetSelect(int n, char c) {
    }

    private int optionInt(ArrayList<Object> arrayList, int n) {
        if (arrayList.size() <= n) {
            throw new IllegalArgumentException();
        }
        Object object = arrayList.get(n);
        if (object == null) {
            throw new IllegalArgumentException();
        }
        if (!object.getClass().equals(Integer.class)) {
            throw new IllegalArgumentException();
        }
        return (Integer)object;
    }

    private int optionInt(ArrayList<Object> arrayList, int n, int n2) {
        if (arrayList.size() > n) {
            Object object = arrayList.get(n);
            if (object == null) {
                return n2;
            }
            return (Integer)object;
        }
        return n2;
    }

    @Override
    public void write(char[] cArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.write(cArray[n + i]);
        }
    }

    @Override
    public void write(String string, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.write(string.charAt(n + i));
        }
    }

    @Override
    public void close() {
        this.write(RESET_CODE);
        this.flush();
        super.close();
    }
}

