/*
 * Decompiled with CFR 0.152.
 */
package org.jline.terminal.impl.jna.win;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import java.io.Writer;
import org.jline.terminal.impl.jna.win.Kernel32;
import org.jline.utils.AnsiWriter;
import org.jline.utils.Colors;

public final class WindowsAnsiWriter
extends AnsiWriter {
    private static final short FOREGROUND_BLACK = 0;
    private static final short FOREGROUND_YELLOW = 6;
    private static final short FOREGROUND_MAGENTA = 5;
    private static final short FOREGROUND_CYAN = 3;
    private static final short FOREGROUND_WHITE = 7;
    private static final short BACKGROUND_BLACK = 0;
    private static final short BACKGROUND_YELLOW = 96;
    private static final short BACKGROUND_MAGENTA = 80;
    private static final short BACKGROUND_CYAN = 48;
    private static final short BACKGROUND_WHITE = 112;
    private static final short[] ANSI_FOREGROUND_COLOR_MAP = new short[]{0, 4, 2, 6, 1, 5, 3, 7};
    private static final short[] ANSI_BACKGROUND_COLOR_MAP = new short[]{0, 64, 32, 96, 16, 80, 48, 112};
    private static final int MAX_ESCAPE_SEQUENCE_LENGTH = 100;
    private final Pointer console;
    private final Kernel32.CONSOLE_SCREEN_BUFFER_INFO info = new Kernel32.CONSOLE_SCREEN_BUFFER_INFO();
    private final short originalColors;
    private boolean negative;
    private boolean bold;
    private boolean underline;
    private short savedX = (short)-1;
    private short savedY = (short)-1;

    public WindowsAnsiWriter(Writer writer, Pointer pointer) {
        super(writer);
        this.console = pointer;
        this.getConsoleInfo();
        this.originalColors = this.info.wAttributes;
    }

    private void getConsoleInfo() {
        this.out.flush();
        Kernel32.INSTANCE.GetConsoleScreenBufferInfo(this.console, this.info);
        if (this.negative) {
            this.info.wAttributes = this.invertAttributeColors(this.info.wAttributes);
        }
    }

    private void applyAttribute() {
        this.out.flush();
        short s = this.info.wAttributes;
        if (this.bold) {
            s = (short)(s | 8);
        }
        if (this.underline) {
            s = (short)(s | 0x80);
        }
        if (this.negative) {
            s = this.invertAttributeColors(s);
        }
        Kernel32.INSTANCE.SetConsoleTextAttribute(this.console, s);
    }

    private short invertAttributeColors(short s) {
        int n = 0xF & s;
        int n2 = 0xF0 & s;
        s = (short)(s & 0xFF00 | (n <<= 4) | (n2 >>= 4));
        return s;
    }

    private void applyCursorPosition() {
        this.info.dwCursorPosition.X = (short)Math.max(0, Math.min(this.info.dwSize.X - 1, this.info.dwCursorPosition.X));
        this.info.dwCursorPosition.Y = (short)Math.max(0, Math.min(this.info.dwSize.Y - 1, this.info.dwCursorPosition.Y));
        Kernel32.INSTANCE.SetConsoleCursorPosition(this.console, this.info.dwCursorPosition);
    }

    @Override
    protected void processEraseScreen(int n) {
        this.getConsoleInfo();
        IntByReference intByReference = new IntByReference();
        switch (n) {
            case 2: {
                Kernel32.COORD cOORD = new Kernel32.COORD();
                cOORD.X = 0;
                cOORD.Y = this.info.srWindow.Top;
                int n2 = this.info.srWindow.height() * this.info.dwSize.X;
                Kernel32.INSTANCE.FillConsoleOutputCharacter(this.console, ' ', n2, cOORD, intByReference);
                Kernel32.INSTANCE.FillConsoleOutputAttribute(this.console, this.info.wAttributes, n2, cOORD, intByReference);
                break;
            }
            case 1: {
                Kernel32.COORD cOORD = new Kernel32.COORD();
                cOORD.X = 0;
                cOORD.Y = this.info.srWindow.Top;
                int n3 = (this.info.dwCursorPosition.Y - this.info.srWindow.Top) * this.info.dwSize.X + this.info.dwCursorPosition.X;
                Kernel32.INSTANCE.FillConsoleOutputCharacter(this.console, ' ', n3, cOORD, intByReference);
                Kernel32.INSTANCE.FillConsoleOutputAttribute(this.console, this.info.wAttributes, n3, cOORD, intByReference);
                break;
            }
            case 0: {
                int n4 = (this.info.srWindow.Bottom - this.info.dwCursorPosition.Y) * this.info.dwSize.X + (this.info.dwSize.X - this.info.dwCursorPosition.X);
                Kernel32.INSTANCE.FillConsoleOutputCharacter(this.console, ' ', n4, this.info.dwCursorPosition, intByReference);
                Kernel32.INSTANCE.FillConsoleOutputAttribute(this.console, this.info.wAttributes, n4, this.info.dwCursorPosition, intByReference);
            }
        }
    }

    @Override
    protected void processEraseLine(int n) {
        this.getConsoleInfo();
        IntByReference intByReference = new IntByReference();
        switch (n) {
            case 2: {
                Kernel32.COORD cOORD = new Kernel32.COORD(0, this.info.dwCursorPosition.Y);
                Kernel32.INSTANCE.FillConsoleOutputCharacter(this.console, ' ', this.info.dwSize.X, cOORD, intByReference);
                Kernel32.INSTANCE.FillConsoleOutputAttribute(this.console, this.info.wAttributes, this.info.dwSize.X, cOORD, intByReference);
                break;
            }
            case 1: {
                Kernel32.COORD cOORD = new Kernel32.COORD(0, this.info.dwCursorPosition.Y);
                Kernel32.INSTANCE.FillConsoleOutputCharacter(this.console, ' ', this.info.dwCursorPosition.X, cOORD, intByReference);
                Kernel32.INSTANCE.FillConsoleOutputAttribute(this.console, this.info.wAttributes, this.info.dwCursorPosition.X, cOORD, intByReference);
                break;
            }
            case 0: {
                int n2 = this.info.dwSize.X - this.info.dwCursorPosition.X;
                Kernel32.INSTANCE.FillConsoleOutputCharacter(this.console, ' ', n2, this.info.dwCursorPosition, intByReference);
                Kernel32.INSTANCE.FillConsoleOutputAttribute(this.console, this.info.wAttributes, n2, this.info.dwCursorPosition, intByReference);
            }
        }
    }

    @Override
    protected void processCursorUpLine(int n) {
        this.getConsoleInfo();
        this.info.dwCursorPosition.X = 0;
        this.info.dwCursorPosition.Y = (short)(this.info.dwCursorPosition.Y - n);
        this.applyCursorPosition();
    }

    @Override
    protected void processCursorDownLine(int n) {
        this.getConsoleInfo();
        this.info.dwCursorPosition.X = 0;
        this.info.dwCursorPosition.Y = (short)(this.info.dwCursorPosition.Y + n);
        this.applyCursorPosition();
    }

    @Override
    protected void processCursorLeft(int n) {
        this.getConsoleInfo();
        this.info.dwCursorPosition.X = (short)(this.info.dwCursorPosition.X - n);
        this.applyCursorPosition();
    }

    @Override
    protected void processCursorRight(int n) {
        this.getConsoleInfo();
        this.info.dwCursorPosition.X = (short)(this.info.dwCursorPosition.X + n);
        this.applyCursorPosition();
    }

    @Override
    protected void processCursorDown(int n) {
        this.getConsoleInfo();
        int n2 = Math.max(0, this.info.dwCursorPosition.Y + n - this.info.dwSize.Y + 1);
        if (n2 != n) {
            this.info.dwCursorPosition.Y = (short)(this.info.dwCursorPosition.Y + n);
            this.applyCursorPosition();
        }
        if (n2 > 0) {
            Kernel32.SMALL_RECT sMALL_RECT = new Kernel32.SMALL_RECT(this.info.srWindow);
            sMALL_RECT.Top = 0;
            Kernel32.COORD cOORD = new Kernel32.COORD();
            cOORD.X = 0;
            cOORD.Y = (short)(-n2);
            Kernel32.CHAR_INFO cHAR_INFO = new Kernel32.CHAR_INFO(' ', this.originalColors);
            Kernel32.INSTANCE.ScrollConsoleScreenBuffer(this.console, sMALL_RECT, sMALL_RECT, cOORD, cHAR_INFO);
        }
    }

    @Override
    protected void processCursorUp(int n) {
        this.getConsoleInfo();
        this.info.dwCursorPosition.Y = (short)(this.info.dwCursorPosition.Y - n);
        this.applyCursorPosition();
    }

    @Override
    protected void processCursorTo(int n, int n2) {
        this.getConsoleInfo();
        this.info.dwCursorPosition.Y = (short)(this.info.srWindow.Top + n - 1);
        this.info.dwCursorPosition.X = (short)(n2 - 1);
        this.applyCursorPosition();
    }

    @Override
    protected void processCursorToColumn(int n) {
        this.getConsoleInfo();
        this.info.dwCursorPosition.X = (short)(n - 1);
        this.applyCursorPosition();
    }

    @Override
    protected void processSetForegroundColorExt(int n) {
        int n2 = Colors.roundColor(n, 16);
        this.info.wAttributes = (short)(this.info.wAttributes & 0xFFFFFFF8 | ANSI_FOREGROUND_COLOR_MAP[n2 & 7]);
        this.info.wAttributes = (short)(this.info.wAttributes & 0xFFFFFFF7 | (n2 > 8 ? 8 : 0));
        this.applyAttribute();
    }

    @Override
    protected void processSetBackgroundColorExt(int n) {
        int n2 = Colors.roundColor(n, 16);
        this.info.wAttributes = (short)(this.info.wAttributes & 0xFFFFFF8F | ANSI_BACKGROUND_COLOR_MAP[n2 & 7]);
        this.info.wAttributes = (short)(this.info.wAttributes & 0xFFFFFF7F | (n2 > 8 ? 128 : 0));
        this.applyAttribute();
    }

    @Override
    protected void processDefaultTextColor() {
        this.info.wAttributes = (short)(this.info.wAttributes & 0xFFFFFFF0 | this.originalColors & 0xF);
        this.applyAttribute();
    }

    @Override
    protected void processDefaultBackgroundColor() {
        this.info.wAttributes = (short)(this.info.wAttributes & 0xFFFFFF0F | this.originalColors & 0xF0);
        this.applyAttribute();
    }

    @Override
    protected void processAttributeRest() {
        this.info.wAttributes = (short)(this.info.wAttributes & 0xFFFFFF00 | this.originalColors);
        this.negative = false;
        this.bold = false;
        this.underline = false;
        this.applyAttribute();
    }

    @Override
    protected void processSetAttribute(int n) {
        switch (n) {
            case 1: {
                this.bold = true;
                this.applyAttribute();
                break;
            }
            case 22: {
                this.bold = false;
                this.applyAttribute();
                break;
            }
            case 4: {
                this.underline = true;
                this.applyAttribute();
                break;
            }
            case 24: {
                this.underline = false;
                this.applyAttribute();
                break;
            }
            case 7: {
                this.negative = true;
                this.applyAttribute();
                break;
            }
            case 27: {
                this.negative = false;
                this.applyAttribute();
            }
        }
    }

    @Override
    protected void processSaveCursorPosition() {
        this.getConsoleInfo();
        this.savedX = this.info.dwCursorPosition.X;
        this.savedY = this.info.dwCursorPosition.Y;
    }

    @Override
    protected void processRestoreCursorPosition() {
        if (this.savedX != -1 && this.savedY != -1) {
            this.out.flush();
            this.info.dwCursorPosition.X = this.savedX;
            this.info.dwCursorPosition.Y = this.savedY;
            this.applyCursorPosition();
        }
    }

    @Override
    protected void processInsertLine(int n) {
        this.getConsoleInfo();
        Kernel32.SMALL_RECT sMALL_RECT = new Kernel32.SMALL_RECT(this.info.srWindow);
        sMALL_RECT.Top = this.info.dwCursorPosition.Y;
        Kernel32.COORD cOORD = new Kernel32.COORD();
        cOORD.X = 0;
        cOORD.Y = (short)(this.info.dwCursorPosition.Y + n);
        Kernel32.CHAR_INFO cHAR_INFO = new Kernel32.CHAR_INFO(' ', this.originalColors);
        Kernel32.INSTANCE.ScrollConsoleScreenBuffer(this.console, sMALL_RECT, sMALL_RECT, cOORD, cHAR_INFO);
    }

    @Override
    protected void processDeleteLine(int n) {
        this.getConsoleInfo();
        Kernel32.SMALL_RECT sMALL_RECT = new Kernel32.SMALL_RECT(this.info.srWindow);
        sMALL_RECT.Top = this.info.dwCursorPosition.Y;
        Kernel32.COORD cOORD = new Kernel32.COORD();
        cOORD.X = 0;
        cOORD.Y = (short)(this.info.dwCursorPosition.Y - n);
        Kernel32.CHAR_INFO cHAR_INFO = new Kernel32.CHAR_INFO(' ', this.originalColors);
        Kernel32.INSTANCE.ScrollConsoleScreenBuffer(this.console, sMALL_RECT, sMALL_RECT, cOORD, cHAR_INFO);
    }

    @Override
    protected void processChangeWindowTitle(String string) {
        Kernel32.INSTANCE.SetConsoleTitle(string);
    }
}

