/*
 * Decompiled with CFR 0.152.
 */
package org.jline.terminal.impl.jna.win;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import java.io.BufferedWriter;
import java.nio.charset.Charset;
import java.util.function.IntConsumer;
import org.jline.terminal.Cursor;
import org.jline.terminal.Size;
import org.jline.terminal.Terminal;
import org.jline.terminal.impl.AbstractWindowsTerminal;
import org.jline.terminal.impl.jna.win.JnaWinConsoleWriter;
import org.jline.terminal.impl.jna.win.Kernel32;
import org.jline.terminal.impl.jna.win.WindowsAnsiWriter;
import org.jline.utils.InfoCmp;

public class JnaWinSysTerminal
extends AbstractWindowsTerminal {
    private static final Pointer consoleIn = Kernel32.INSTANCE.GetStdHandle(-10);
    private static final Pointer consoleOut = Kernel32.INSTANCE.GetStdHandle(-11);
    private char[] focus = new char[]{'\u001b', '[', ' '};
    private char[] mouse = new char[]{'\u001b', '[', 'M', ' ', ' ', ' '};
    private final Kernel32.INPUT_RECORD[] inputEvents = new Kernel32.INPUT_RECORD[1];
    private final IntByReference eventsRead = new IntByReference();

    public JnaWinSysTerminal(String string, boolean bl) {
        this(string, "windows", false, null, 0, bl, Terminal.SignalHandler.SIG_DFL);
    }

    public JnaWinSysTerminal(String string, String string2, boolean bl, Charset charset, int n, boolean bl2, Terminal.SignalHandler signalHandler) {
        super(bl ? new JnaWinConsoleWriter(consoleOut) : new WindowsAnsiWriter(new BufferedWriter(new JnaWinConsoleWriter(consoleOut)), consoleOut), string, string2, charset, n, bl2, signalHandler);
        this.strings.put(InfoCmp.Capability.key_mouse, "\\E[M");
        this.resume();
    }

    @Override
    protected int getConsoleOutputCP() {
        return Kernel32.INSTANCE.GetConsoleOutputCP();
    }

    @Override
    protected int getConsoleMode() {
        IntByReference intByReference = new IntByReference();
        Kernel32.INSTANCE.GetConsoleMode(consoleIn, intByReference);
        return intByReference.getValue();
    }

    @Override
    protected void setConsoleMode(int n) {
        Kernel32.INSTANCE.SetConsoleMode(consoleIn, n);
    }

    @Override
    public Size getSize() {
        Kernel32.CONSOLE_SCREEN_BUFFER_INFO cONSOLE_SCREEN_BUFFER_INFO = new Kernel32.CONSOLE_SCREEN_BUFFER_INFO();
        Kernel32.INSTANCE.GetConsoleScreenBufferInfo(consoleOut, cONSOLE_SCREEN_BUFFER_INFO);
        return new Size(cONSOLE_SCREEN_BUFFER_INFO.windowWidth(), cONSOLE_SCREEN_BUFFER_INFO.windowHeight());
    }

    @Override
    protected boolean processConsoleInput() {
        Kernel32.INPUT_RECORD iNPUT_RECORD = this.readConsoleInput(100);
        if (iNPUT_RECORD == null) {
            return false;
        }
        switch (iNPUT_RECORD.EventType) {
            case 1: {
                this.processKeyEvent(iNPUT_RECORD.Event.KeyEvent);
                return true;
            }
            case 4: {
                this.raise(Terminal.Signal.WINCH);
                return false;
            }
            case 2: {
                this.processMouseEvent(iNPUT_RECORD.Event.MouseEvent);
                return true;
            }
            case 16: {
                this.processFocusEvent(iNPUT_RECORD.Event.FocusEvent.bSetFocus);
                return true;
            }
        }
        return false;
    }

    private void processKeyEvent(Kernel32.KEY_EVENT_RECORD kEY_EVENT_RECORD) {
        this.processKeyEvent(kEY_EVENT_RECORD.bKeyDown, kEY_EVENT_RECORD.wVirtualKeyCode, kEY_EVENT_RECORD.uChar.UnicodeChar, kEY_EVENT_RECORD.dwControlKeyState);
    }

    private void processFocusEvent(boolean bl) {
        if (this.focusTracking) {
            this.focus[2] = bl ? 73 : 79;
            this.slaveInputPipe.write(this.focus);
        }
    }

    private void processMouseEvent(Kernel32.MOUSE_EVENT_RECORD mOUSE_EVENT_RECORD) {
        int n = mOUSE_EVENT_RECORD.dwEventFlags;
        int n2 = mOUSE_EVENT_RECORD.dwButtonState;
        if (this.tracking == Terminal.MouseTracking.Off || this.tracking == Terminal.MouseTracking.Normal && n == 1 || this.tracking == Terminal.MouseTracking.Button && n == 1 && n2 == 0) {
            return;
        }
        int n3 = 0;
        if ((n &= 0xFFFFFFFD) == 4) {
            n3 |= 0x40;
            if (n2 >> 16 < 0) {
                n3 |= 1;
            }
        } else {
            if (n == 8) {
                return;
            }
            n3 = (n2 & 1) != 0 ? (n3 |= 0) : ((n2 & 2) != 0 ? (n3 |= 1) : ((n2 & 4) != 0 ? (n3 |= 2) : (n3 |= 3)));
        }
        short s = mOUSE_EVENT_RECORD.dwMousePosition.X;
        short s2 = mOUSE_EVENT_RECORD.dwMousePosition.Y;
        this.mouse[3] = (char)(32 + n3);
        this.mouse[4] = (char)(32 + s + 1);
        this.mouse[5] = (char)(32 + s2 + 1);
        this.slaveInputPipe.write(this.mouse);
    }

    private Kernel32.INPUT_RECORD readConsoleInput(int n) {
        if (Kernel32.INSTANCE.WaitForSingleObject(consoleIn, n) != 0) {
            return null;
        }
        Kernel32.INSTANCE.ReadConsoleInput(consoleIn, this.inputEvents, 1, this.eventsRead);
        if (this.eventsRead.getValue() == 1) {
            return this.inputEvents[0];
        }
        return null;
    }

    @Override
    public Cursor getCursorPosition(IntConsumer intConsumer) {
        Kernel32.CONSOLE_SCREEN_BUFFER_INFO cONSOLE_SCREEN_BUFFER_INFO = new Kernel32.CONSOLE_SCREEN_BUFFER_INFO();
        Kernel32.INSTANCE.GetConsoleScreenBufferInfo(consoleOut, cONSOLE_SCREEN_BUFFER_INFO);
        return new Cursor(cONSOLE_SCREEN_BUFFER_INFO.dwCursorPosition.X, cONSOLE_SCREEN_BUFFER_INFO.dwCursorPosition.Y);
    }
}

