/*
 * Decompiled with CFR 0.152.
 */
package org.jline.terminal.impl.jna.osx;

import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Platform;
import java.io.FileDescriptor;
import org.jline.terminal.Attributes;
import org.jline.terminal.Size;
import org.jline.terminal.impl.jna.JnaNativePty;
import org.jline.terminal.impl.jna.osx.CLibrary;

public class OsXNativePty
extends JnaNativePty {
    private static final CLibrary C_LIBRARY = (CLibrary)Native.loadLibrary((String)Platform.C_LIBRARY_NAME, CLibrary.class);

    public static OsXNativePty current() {
        int n = 0;
        byte[] byArray = new byte[64];
        C_LIBRARY.ttyname_r(n, byArray, byArray.length);
        int n2 = 0;
        while (byArray[n2] != 0) {
            ++n2;
        }
        String string = new String(byArray, 0, n2);
        return new OsXNativePty(-1, null, n, FileDescriptor.in, 1, FileDescriptor.out, string);
    }

    public static OsXNativePty open(Attributes attributes, Size size) {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        byte[] byArray = new byte[64];
        C_LIBRARY.openpty(nArray, nArray2, byArray, attributes != null ? new CLibrary.termios(attributes) : null, size != null ? new CLibrary.winsize(size) : null);
        int n = 0;
        while (byArray[n] != 0) {
            ++n;
        }
        String string = new String(byArray, 0, n);
        return new OsXNativePty(nArray[0], OsXNativePty.newDescriptor(nArray[0]), nArray2[0], OsXNativePty.newDescriptor(nArray2[0]), string);
    }

    public OsXNativePty(int n, FileDescriptor fileDescriptor, int n2, FileDescriptor fileDescriptor2, String string) {
        super(n, fileDescriptor, n2, fileDescriptor2, string);
    }

    public OsXNativePty(int n, FileDescriptor fileDescriptor, int n2, FileDescriptor fileDescriptor2, int n3, FileDescriptor fileDescriptor3, String string) {
        super(n, fileDescriptor, n2, fileDescriptor2, n3, fileDescriptor3, string);
    }

    @Override
    public Attributes getAttr() {
        CLibrary.termios termios2 = new CLibrary.termios();
        C_LIBRARY.tcgetattr(this.getSlave(), termios2);
        return termios2.toAttributes();
    }

    @Override
    protected void doSetAttr(Attributes attributes) {
        CLibrary.termios termios2 = new CLibrary.termios(attributes);
        C_LIBRARY.tcsetattr(this.getSlave(), 0, termios2);
    }

    @Override
    public Size getSize() {
        CLibrary.winsize winsize2 = new CLibrary.winsize();
        C_LIBRARY.ioctl(this.getSlave(), new NativeLong(1074295912L), winsize2);
        return winsize2.toSize();
    }

    @Override
    public void setSize(Size size) {
        CLibrary.winsize winsize2 = new CLibrary.winsize(size);
        C_LIBRARY.ioctl(this.getSlave(), new NativeLong(2148037735L), winsize2);
    }
}

