/*
 * Decompiled with CFR 0.152.
 */
package org.jline.terminal.impl.jna.linux;

import com.sun.jna.LastErrorException;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import java.io.FileDescriptor;
import org.jline.terminal.Attributes;
import org.jline.terminal.Size;
import org.jline.terminal.impl.jna.JnaNativePty;
import org.jline.terminal.impl.jna.linux.CLibrary;

public class LinuxNativePty
extends JnaNativePty {
    private static final CLibrary C_LIBRARY = (CLibrary)Native.loadLibrary((String)Platform.C_LIBRARY_NAME, CLibrary.class);

    public static LinuxNativePty current() {
        int n = 0;
        byte[] byArray = new byte[64];
        C_LIBRARY.ttyname_r(n, byArray, byArray.length);
        int n2 = 0;
        while (byArray[n2] != 0) {
            ++n2;
        }
        String string = new String(byArray, 0, n2);
        return new LinuxNativePty(-1, null, n, FileDescriptor.in, 1, FileDescriptor.out, string);
    }

    public static LinuxNativePty open(Attributes attributes, Size size) {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        byte[] byArray = new byte[64];
        UtilLibrary.INSTANCE.openpty(nArray, nArray2, byArray, attributes != null ? new CLibrary.termios(attributes) : null, size != null ? new CLibrary.winsize(size) : null);
        int n = 0;
        while (byArray[n] != 0) {
            ++n;
        }
        String string = new String(byArray, 0, n);
        return new LinuxNativePty(nArray[0], LinuxNativePty.newDescriptor(nArray[0]), nArray2[0], LinuxNativePty.newDescriptor(nArray2[0]), string);
    }

    public LinuxNativePty(int n, FileDescriptor fileDescriptor, int n2, FileDescriptor fileDescriptor2, String string) {
        super(n, fileDescriptor, n2, fileDescriptor2, string);
    }

    public LinuxNativePty(int n, FileDescriptor fileDescriptor, int n2, FileDescriptor fileDescriptor2, int n3, FileDescriptor fileDescriptor3, String string) {
        super(n, fileDescriptor, n2, fileDescriptor2, n3, fileDescriptor3, string);
    }

    @Override
    public Attributes getAttr() {
        CLibrary.termios termios2 = new CLibrary.termios();
        C_LIBRARY.tcgetattr(this.getSlave(), termios2);
        return termios2.toAttributes();
    }

    @Override
    protected void doSetAttr(Attributes attributes) {
        CLibrary.termios termios2 = new CLibrary.termios(attributes);
        CLibrary.termios termios3 = new CLibrary.termios();
        C_LIBRARY.tcgetattr(this.getSlave(), termios3);
        termios3.c_iflag = termios2.c_iflag;
        termios3.c_oflag = termios2.c_oflag;
        termios3.c_lflag = termios2.c_lflag;
        System.arraycopy(termios2.c_cc, 0, termios3.c_cc, 0, termios2.c_cc.length);
        C_LIBRARY.tcsetattr(this.getSlave(), 1, termios3);
    }

    @Override
    public Size getSize() {
        CLibrary.winsize winsize2 = new CLibrary.winsize();
        C_LIBRARY.ioctl(this.getSlave(), 21523, winsize2);
        return winsize2.toSize();
    }

    @Override
    public void setSize(Size size) {
        CLibrary.winsize winsize2 = new CLibrary.winsize(size);
        C_LIBRARY.ioctl(this.getSlave(), 21524, winsize2);
    }

    public static interface UtilLibrary
    extends Library {
        public static final UtilLibrary INSTANCE = (UtilLibrary)Native.loadLibrary((String)"util", UtilLibrary.class);

        public void openpty(int[] var1, int[] var2, byte[] var3, CLibrary.termios var4, CLibrary.winsize var5) throws LastErrorException;
    }
}

