/*
 * Decompiled with CFR 0.152.
 */
package org.jline.terminal.impl.jna;

import com.sun.jna.Platform;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import org.jline.terminal.Attributes;
import org.jline.terminal.Size;
import org.jline.terminal.impl.AbstractPty;
import org.jline.terminal.impl.jna.freebsd.FreeBsdNativePty;
import org.jline.terminal.impl.jna.linux.LinuxNativePty;
import org.jline.terminal.impl.jna.osx.OsXNativePty;
import org.jline.terminal.impl.jna.solaris.SolarisNativePty;
import org.jline.terminal.spi.Pty;

public abstract class JnaNativePty
extends AbstractPty
implements Pty {
    private final int master;
    private final int slave;
    private final int slaveOut;
    private final String name;
    private final FileDescriptor masterFD;
    private final FileDescriptor slaveFD;
    private final FileDescriptor slaveOutFD;

    public static JnaNativePty current() {
        if (Platform.isMac()) {
            return OsXNativePty.current();
        }
        if (Platform.isLinux()) {
            return LinuxNativePty.current();
        }
        if (Platform.isSolaris()) {
            return SolarisNativePty.current();
        }
        if (Platform.isFreeBSD()) {
            return FreeBsdNativePty.current();
        }
        throw new UnsupportedOperationException();
    }

    public static JnaNativePty open(Attributes attributes, Size size) {
        if (Platform.isMac()) {
            return OsXNativePty.open(attributes, size);
        }
        if (Platform.isLinux()) {
            return LinuxNativePty.open(attributes, size);
        }
        if (Platform.isSolaris()) {
            return SolarisNativePty.open(attributes, size);
        }
        if (Platform.isFreeBSD()) {
            return FreeBsdNativePty.open(attributes, size);
        }
        throw new UnsupportedOperationException();
    }

    protected JnaNativePty(int n, FileDescriptor fileDescriptor, int n2, FileDescriptor fileDescriptor2, String string) {
        this(n, fileDescriptor, n2, fileDescriptor2, n2, fileDescriptor2, string);
    }

    protected JnaNativePty(int n, FileDescriptor fileDescriptor, int n2, FileDescriptor fileDescriptor2, int n3, FileDescriptor fileDescriptor3, String string) {
        this.master = n;
        this.slave = n2;
        this.slaveOut = n3;
        this.name = string;
        this.masterFD = fileDescriptor;
        this.slaveFD = fileDescriptor2;
        this.slaveOutFD = fileDescriptor3;
    }

    @Override
    public void close() {
        if (this.master > 0) {
            this.getMasterInput().close();
        }
        if (this.slave > 0) {
            this.getSlaveInput().close();
        }
    }

    public int getMaster() {
        return this.master;
    }

    public int getSlave() {
        return this.slave;
    }

    public int getSlaveOut() {
        return this.slaveOut;
    }

    public String getName() {
        return this.name;
    }

    public FileDescriptor getMasterFD() {
        return this.masterFD;
    }

    public FileDescriptor getSlaveFD() {
        return this.slaveFD;
    }

    public FileDescriptor getSlaveOutFD() {
        return this.slaveOutFD;
    }

    @Override
    public InputStream getMasterInput() {
        return new FileInputStream(this.getMasterFD());
    }

    @Override
    public OutputStream getMasterOutput() {
        return new FileOutputStream(this.getMasterFD());
    }

    @Override
    protected InputStream doGetSlaveInput() {
        return new FileInputStream(this.getSlaveFD());
    }

    @Override
    public OutputStream getSlaveOutput() {
        return new FileOutputStream(this.getSlaveOutFD());
    }

    protected static FileDescriptor newDescriptor(int n) {
        try {
            Constructor constructor = FileDescriptor.class.getDeclaredConstructor(Integer.TYPE);
            constructor.setAccessible(true);
            return (FileDescriptor)constructor.newInstance(n);
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Unable to create FileDescriptor", throwable);
        }
    }

    public String toString() {
        return "JnaNativePty[" + this.getName() + "]";
    }
}

