/*
 * Decompiled with CFR 0.152.
 */
package org.jline.terminal.impl.jansi.win;

import java.io.IOException;
import java.io.Writer;
import org.fusesource.jansi.internal.Kernel32;
import org.fusesource.jansi.internal.WindowsSupport;
import org.jline.utils.AnsiWriter;
import org.jline.utils.Colors;

public final class WindowsAnsiWriter
extends AnsiWriter {
    private static final long console = Kernel32.GetStdHandle((int)Kernel32.STD_OUTPUT_HANDLE);
    private static final short FOREGROUND_BLACK = 0;
    private static final short FOREGROUND_YELLOW = (short)(Kernel32.FOREGROUND_RED | Kernel32.FOREGROUND_GREEN);
    private static final short FOREGROUND_MAGENTA = (short)(Kernel32.FOREGROUND_BLUE | Kernel32.FOREGROUND_RED);
    private static final short FOREGROUND_CYAN = (short)(Kernel32.FOREGROUND_BLUE | Kernel32.FOREGROUND_GREEN);
    private static final short FOREGROUND_WHITE = (short)(Kernel32.FOREGROUND_RED | Kernel32.FOREGROUND_GREEN | Kernel32.FOREGROUND_BLUE);
    private static final short BACKGROUND_BLACK = 0;
    private static final short BACKGROUND_YELLOW = (short)(Kernel32.BACKGROUND_RED | Kernel32.BACKGROUND_GREEN);
    private static final short BACKGROUND_MAGENTA = (short)(Kernel32.BACKGROUND_BLUE | Kernel32.BACKGROUND_RED);
    private static final short BACKGROUND_CYAN = (short)(Kernel32.BACKGROUND_BLUE | Kernel32.BACKGROUND_GREEN);
    private static final short BACKGROUND_WHITE = (short)(Kernel32.BACKGROUND_RED | Kernel32.BACKGROUND_GREEN | Kernel32.BACKGROUND_BLUE);
    private static final short[] ANSI_FOREGROUND_COLOR_MAP = new short[]{0, Kernel32.FOREGROUND_RED, Kernel32.FOREGROUND_GREEN, FOREGROUND_YELLOW, Kernel32.FOREGROUND_BLUE, FOREGROUND_MAGENTA, FOREGROUND_CYAN, FOREGROUND_WHITE};
    private static final short[] ANSI_BACKGROUND_COLOR_MAP = new short[]{0, Kernel32.BACKGROUND_RED, Kernel32.BACKGROUND_GREEN, BACKGROUND_YELLOW, Kernel32.BACKGROUND_BLUE, BACKGROUND_MAGENTA, BACKGROUND_CYAN, BACKGROUND_WHITE};
    private final Kernel32.CONSOLE_SCREEN_BUFFER_INFO info = new Kernel32.CONSOLE_SCREEN_BUFFER_INFO();
    private final short originalColors;
    private boolean negative;
    private boolean bold;
    private boolean underline;
    private short savedX = (short)-1;
    private short savedY = (short)-1;

    public WindowsAnsiWriter(Writer writer) {
        super(writer);
        this.getConsoleInfo();
        this.originalColors = this.info.attributes;
    }

    private void getConsoleInfo() {
        this.out.flush();
        if (Kernel32.GetConsoleScreenBufferInfo((long)console, (Kernel32.CONSOLE_SCREEN_BUFFER_INFO)this.info) == 0) {
            throw new IOException("Could not get the screen info: " + WindowsSupport.getLastErrorMessage());
        }
        if (this.negative) {
            this.info.attributes = this.invertAttributeColors(this.info.attributes);
        }
    }

    private void applyAttribute() {
        this.out.flush();
        short s = this.info.attributes;
        if (this.bold) {
            s = (short)(s | Kernel32.FOREGROUND_INTENSITY);
        }
        if (this.underline) {
            s = (short)(s | Kernel32.BACKGROUND_INTENSITY);
        }
        if (this.negative) {
            s = this.invertAttributeColors(s);
        }
        if (Kernel32.SetConsoleTextAttribute((long)console, (short)s) == 0) {
            throw new IOException(WindowsSupport.getLastErrorMessage());
        }
    }

    private short invertAttributeColors(short s) {
        int n = 0xF & s;
        int n2 = 0xF0 & s;
        s = (short)(s & 0xFF00 | (n <<= 4) | (n2 >>= 4));
        return s;
    }

    private void applyCursorPosition() {
        this.info.cursorPosition.x = (short)Math.max(0, Math.min(this.info.size.x - 1, this.info.cursorPosition.x));
        this.info.cursorPosition.y = (short)Math.max(0, Math.min(this.info.size.y - 1, this.info.cursorPosition.y));
        if (Kernel32.SetConsoleCursorPosition((long)console, (Kernel32.COORD)this.info.cursorPosition.copy()) == 0) {
            throw new IOException(WindowsSupport.getLastErrorMessage());
        }
    }

    @Override
    protected void processEraseScreen(int n) {
        this.getConsoleInfo();
        int[] nArray = new int[1];
        switch (n) {
            case 2: {
                Kernel32.COORD cOORD = new Kernel32.COORD();
                cOORD.x = 0;
                cOORD.y = this.info.window.top;
                int n2 = this.info.window.height() * this.info.size.x;
                Kernel32.FillConsoleOutputAttribute((long)console, (short)this.originalColors, (int)n2, (Kernel32.COORD)cOORD, (int[])nArray);
                Kernel32.FillConsoleOutputCharacterW((long)console, (char)' ', (int)n2, (Kernel32.COORD)cOORD, (int[])nArray);
                break;
            }
            case 1: {
                Kernel32.COORD cOORD = new Kernel32.COORD();
                cOORD.x = 0;
                cOORD.y = this.info.window.top;
                int n3 = (this.info.cursorPosition.y - this.info.window.top) * this.info.size.x + this.info.cursorPosition.x;
                Kernel32.FillConsoleOutputAttribute((long)console, (short)this.originalColors, (int)n3, (Kernel32.COORD)cOORD, (int[])nArray);
                Kernel32.FillConsoleOutputCharacterW((long)console, (char)' ', (int)n3, (Kernel32.COORD)cOORD, (int[])nArray);
                break;
            }
            case 0: {
                int n4 = (this.info.window.bottom - this.info.cursorPosition.y) * this.info.size.x + (this.info.size.x - this.info.cursorPosition.x);
                Kernel32.FillConsoleOutputAttribute((long)console, (short)this.originalColors, (int)n4, (Kernel32.COORD)this.info.cursorPosition.copy(), (int[])nArray);
                Kernel32.FillConsoleOutputCharacterW((long)console, (char)' ', (int)n4, (Kernel32.COORD)this.info.cursorPosition.copy(), (int[])nArray);
                break;
            }
        }
    }

    @Override
    protected void processEraseLine(int n) {
        this.getConsoleInfo();
        int[] nArray = new int[1];
        switch (n) {
            case 2: {
                Kernel32.COORD cOORD = this.info.cursorPosition.copy();
                cOORD.x = 0;
                Kernel32.FillConsoleOutputAttribute((long)console, (short)this.originalColors, (int)this.info.size.x, (Kernel32.COORD)cOORD, (int[])nArray);
                Kernel32.FillConsoleOutputCharacterW((long)console, (char)' ', (int)this.info.size.x, (Kernel32.COORD)cOORD, (int[])nArray);
                break;
            }
            case 1: {
                Kernel32.COORD cOORD = this.info.cursorPosition.copy();
                cOORD.x = 0;
                Kernel32.FillConsoleOutputAttribute((long)console, (short)this.originalColors, (int)this.info.cursorPosition.x, (Kernel32.COORD)cOORD, (int[])nArray);
                Kernel32.FillConsoleOutputCharacterW((long)console, (char)' ', (int)this.info.cursorPosition.x, (Kernel32.COORD)cOORD, (int[])nArray);
                break;
            }
            case 0: {
                int n2 = this.info.size.x - this.info.cursorPosition.x;
                Kernel32.FillConsoleOutputAttribute((long)console, (short)this.originalColors, (int)n2, (Kernel32.COORD)this.info.cursorPosition.copy(), (int[])nArray);
                Kernel32.FillConsoleOutputCharacterW((long)console, (char)' ', (int)n2, (Kernel32.COORD)this.info.cursorPosition.copy(), (int[])nArray);
                break;
            }
        }
    }

    @Override
    protected void processCursorUpLine(int n) {
        this.getConsoleInfo();
        this.info.cursorPosition.x = 0;
        this.info.cursorPosition.y = (short)(this.info.cursorPosition.y - n);
        this.applyCursorPosition();
    }

    @Override
    protected void processCursorDownLine(int n) {
        this.getConsoleInfo();
        this.info.cursorPosition.x = 0;
        this.info.cursorPosition.y = (short)(this.info.cursorPosition.y + n);
        this.applyCursorPosition();
    }

    @Override
    protected void processCursorLeft(int n) {
        this.getConsoleInfo();
        this.info.cursorPosition.x = (short)(this.info.cursorPosition.x - n);
        this.applyCursorPosition();
    }

    @Override
    protected void processCursorRight(int n) {
        this.getConsoleInfo();
        this.info.cursorPosition.x = (short)(this.info.cursorPosition.x + n);
        this.applyCursorPosition();
    }

    @Override
    protected void processCursorDown(int n) {
        this.getConsoleInfo();
        int n2 = Math.max(0, this.info.cursorPosition.y + n - this.info.size.y + 1);
        if (n2 != n) {
            this.info.cursorPosition.y = (short)(this.info.cursorPosition.y + n);
            this.applyCursorPosition();
        }
        if (n2 > 0) {
            Kernel32.SMALL_RECT sMALL_RECT = this.info.window.copy();
            sMALL_RECT.top = 0;
            Kernel32.COORD cOORD = new Kernel32.COORD();
            cOORD.x = 0;
            cOORD.y = (short)(-n2);
            Kernel32.CHAR_INFO cHAR_INFO = new Kernel32.CHAR_INFO();
            cHAR_INFO.unicodeChar = (char)32;
            cHAR_INFO.attributes = this.originalColors;
            Kernel32.ScrollConsoleScreenBuffer((long)console, (Kernel32.SMALL_RECT)sMALL_RECT, (Kernel32.SMALL_RECT)sMALL_RECT, (Kernel32.COORD)cOORD, (Kernel32.CHAR_INFO)cHAR_INFO);
        }
    }

    @Override
    protected void processCursorUp(int n) {
        this.getConsoleInfo();
        this.info.cursorPosition.y = (short)(this.info.cursorPosition.y - n);
        this.applyCursorPosition();
    }

    @Override
    protected void processCursorTo(int n, int n2) {
        this.getConsoleInfo();
        this.info.cursorPosition.y = (short)(this.info.window.top + n - 1);
        this.info.cursorPosition.x = (short)(n2 - 1);
        this.applyCursorPosition();
    }

    @Override
    protected void processCursorToColumn(int n) {
        this.getConsoleInfo();
        this.info.cursorPosition.x = (short)(n - 1);
        this.applyCursorPosition();
    }

    @Override
    protected void processSetForegroundColorExt(int n) {
        int n2 = Colors.roundColor(n, 16);
        this.info.attributes = (short)(this.info.attributes & 0xFFFFFFF8 | ANSI_FOREGROUND_COLOR_MAP[n2 & 7]);
        this.info.attributes = (short)(this.info.attributes & ~Kernel32.FOREGROUND_INTENSITY | (n2 > 8 ? Kernel32.FOREGROUND_INTENSITY : (short)0));
        this.applyAttribute();
    }

    @Override
    protected void processSetBackgroundColorExt(int n) {
        int n2 = Colors.roundColor(n, 16);
        this.info.attributes = (short)(this.info.attributes & 0xFFFFFF8F | ANSI_BACKGROUND_COLOR_MAP[n2 & 7]);
        this.info.attributes = (short)(this.info.attributes & ~Kernel32.BACKGROUND_INTENSITY | (n2 > 8 ? Kernel32.BACKGROUND_INTENSITY : (short)0));
        this.applyAttribute();
    }

    @Override
    protected void processDefaultTextColor() {
        this.info.attributes = (short)(this.info.attributes & 0xFFFFFFF0 | this.originalColors & 0xF);
        this.info.attributes = (short)(this.info.attributes & ~Kernel32.FOREGROUND_INTENSITY);
        this.applyAttribute();
    }

    @Override
    protected void processDefaultBackgroundColor() {
        this.info.attributes = (short)(this.info.attributes & 0xFFFFFF0F | this.originalColors & 0xF0);
        this.info.attributes = (short)(this.info.attributes & ~Kernel32.BACKGROUND_INTENSITY);
        this.applyAttribute();
    }

    @Override
    protected void processAttributeRest() {
        this.info.attributes = (short)(this.info.attributes & 0xFFFFFF00 | this.originalColors);
        this.negative = false;
        this.bold = false;
        this.underline = false;
        this.applyAttribute();
    }

    @Override
    protected void processSetAttribute(int n) {
        switch (n) {
            case 1: {
                this.bold = true;
                this.applyAttribute();
                break;
            }
            case 22: {
                this.bold = false;
                this.applyAttribute();
                break;
            }
            case 4: {
                this.underline = true;
                this.applyAttribute();
                break;
            }
            case 24: {
                this.underline = false;
                this.applyAttribute();
                break;
            }
            case 7: {
                this.negative = true;
                this.applyAttribute();
                break;
            }
            case 27: {
                this.negative = false;
                this.applyAttribute();
                break;
            }
        }
    }

    @Override
    protected void processSaveCursorPosition() {
        this.getConsoleInfo();
        this.savedX = this.info.cursorPosition.x;
        this.savedY = this.info.cursorPosition.y;
    }

    @Override
    protected void processRestoreCursorPosition() {
        if (this.savedX != -1 && this.savedY != -1) {
            this.out.flush();
            this.info.cursorPosition.x = this.savedX;
            this.info.cursorPosition.y = this.savedY;
            this.applyCursorPosition();
        }
    }

    @Override
    protected void processInsertLine(int n) {
        this.getConsoleInfo();
        Kernel32.SMALL_RECT sMALL_RECT = this.info.window.copy();
        sMALL_RECT.top = this.info.cursorPosition.y;
        Kernel32.COORD cOORD = new Kernel32.COORD();
        cOORD.x = 0;
        cOORD.y = (short)(this.info.cursorPosition.y + n);
        Kernel32.CHAR_INFO cHAR_INFO = new Kernel32.CHAR_INFO();
        cHAR_INFO.attributes = this.originalColors;
        cHAR_INFO.unicodeChar = (char)32;
        if (Kernel32.ScrollConsoleScreenBuffer((long)console, (Kernel32.SMALL_RECT)sMALL_RECT, (Kernel32.SMALL_RECT)sMALL_RECT, (Kernel32.COORD)cOORD, (Kernel32.CHAR_INFO)cHAR_INFO) == 0) {
            throw new IOException(WindowsSupport.getLastErrorMessage());
        }
    }

    @Override
    protected void processDeleteLine(int n) {
        this.getConsoleInfo();
        Kernel32.SMALL_RECT sMALL_RECT = this.info.window.copy();
        sMALL_RECT.top = this.info.cursorPosition.y;
        Kernel32.COORD cOORD = new Kernel32.COORD();
        cOORD.x = 0;
        cOORD.y = (short)(this.info.cursorPosition.y - n);
        Kernel32.CHAR_INFO cHAR_INFO = new Kernel32.CHAR_INFO();
        cHAR_INFO.attributes = this.originalColors;
        cHAR_INFO.unicodeChar = (char)32;
        if (Kernel32.ScrollConsoleScreenBuffer((long)console, (Kernel32.SMALL_RECT)sMALL_RECT, (Kernel32.SMALL_RECT)sMALL_RECT, (Kernel32.COORD)cOORD, (Kernel32.CHAR_INFO)cHAR_INFO) == 0) {
            throw new IOException(WindowsSupport.getLastErrorMessage());
        }
    }

    @Override
    protected void processChangeWindowTitle(String string) {
        Kernel32.SetConsoleTitle((String)string);
    }
}

