/*
 * Decompiled with CFR 0.152.
 */
package org.jline.terminal.impl.jansi.win;

import java.io.BufferedWriter;
import java.io.IOError;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.function.IntConsumer;
import org.fusesource.jansi.internal.Kernel32;
import org.fusesource.jansi.internal.WindowsSupport;
import org.jline.terminal.Cursor;
import org.jline.terminal.Size;
import org.jline.terminal.Terminal;
import org.jline.terminal.impl.AbstractWindowsTerminal;
import org.jline.terminal.impl.jansi.win.JansiWinConsoleWriter;
import org.jline.terminal.impl.jansi.win.WindowsAnsiWriter;
import org.jline.utils.InfoCmp;

public class JansiWinSysTerminal
extends AbstractWindowsTerminal {
    private char[] focus = new char[]{'\u001b', '[', ' '};
    private char[] mouse = new char[]{'\u001b', '[', 'M', ' ', ' ', ' '};

    public JansiWinSysTerminal(String string, boolean bl) {
        this(string, "windows", false, null, 0, bl, Terminal.SignalHandler.SIG_DFL);
    }

    public JansiWinSysTerminal(String string, String string2, boolean bl, Charset charset, int n, boolean bl2, Terminal.SignalHandler signalHandler) {
        super(bl ? new JansiWinConsoleWriter() : new WindowsAnsiWriter(new BufferedWriter(new JansiWinConsoleWriter())), string, string2, charset, n, bl2, signalHandler);
        this.resume();
    }

    @Override
    protected int getConsoleOutputCP() {
        return Kernel32.GetConsoleOutputCP();
    }

    @Override
    protected int getConsoleMode() {
        return WindowsSupport.getConsoleMode();
    }

    @Override
    protected void setConsoleMode(int n) {
        WindowsSupport.setConsoleMode((int)n);
    }

    @Override
    public Size getSize() {
        Size size = new Size();
        size.setColumns(WindowsSupport.getWindowsTerminalWidth());
        size.setRows(WindowsSupport.getWindowsTerminalHeight());
        return size;
    }

    @Override
    protected boolean processConsoleInput() {
        Kernel32.INPUT_RECORD[] iNPUT_RECORDArray = WindowsSupport.readConsoleInput((int)1, (int)100);
        if (iNPUT_RECORDArray == null) {
            return false;
        }
        boolean bl = false;
        for (Kernel32.INPUT_RECORD iNPUT_RECORD : iNPUT_RECORDArray) {
            if (iNPUT_RECORD.eventType == Kernel32.INPUT_RECORD.KEY_EVENT) {
                Kernel32.KEY_EVENT_RECORD kEY_EVENT_RECORD = iNPUT_RECORD.keyEvent;
                this.processKeyEvent(kEY_EVENT_RECORD.keyDown, kEY_EVENT_RECORD.keyCode, kEY_EVENT_RECORD.uchar, kEY_EVENT_RECORD.controlKeyState);
                bl = true;
                continue;
            }
            if (iNPUT_RECORD.eventType == Kernel32.INPUT_RECORD.WINDOW_BUFFER_SIZE_EVENT) {
                this.raise(Terminal.Signal.WINCH);
                continue;
            }
            if (iNPUT_RECORD.eventType == Kernel32.INPUT_RECORD.MOUSE_EVENT) {
                this.processMouseEvent(iNPUT_RECORD.mouseEvent);
                bl = true;
                continue;
            }
            if (iNPUT_RECORD.eventType != Kernel32.INPUT_RECORD.FOCUS_EVENT) continue;
            this.processFocusEvent(iNPUT_RECORD.focusEvent.setFocus);
        }
        return bl;
    }

    private void processFocusEvent(boolean bl) {
        if (this.focusTracking) {
            this.focus[2] = bl ? 73 : 79;
            this.slaveInputPipe.write(this.focus);
        }
    }

    private void processMouseEvent(Kernel32.MOUSE_EVENT_RECORD mOUSE_EVENT_RECORD) {
        int n = mOUSE_EVENT_RECORD.eventFlags;
        int n2 = mOUSE_EVENT_RECORD.buttonState;
        if (this.tracking == Terminal.MouseTracking.Off || this.tracking == Terminal.MouseTracking.Normal && n == Kernel32.MOUSE_EVENT_RECORD.MOUSE_MOVED || this.tracking == Terminal.MouseTracking.Button && n == Kernel32.MOUSE_EVENT_RECORD.MOUSE_MOVED && n2 == 0) {
            return;
        }
        int n3 = 0;
        if ((n &= ~Kernel32.MOUSE_EVENT_RECORD.DOUBLE_CLICK) == Kernel32.MOUSE_EVENT_RECORD.MOUSE_WHEELED) {
            n3 |= 0x40;
            if (n2 >> 16 < 0) {
                n3 |= 1;
            }
        } else {
            if (n == Kernel32.MOUSE_EVENT_RECORD.MOUSE_HWHEELED) {
                return;
            }
            n3 = (n2 & Kernel32.MOUSE_EVENT_RECORD.FROM_LEFT_1ST_BUTTON_PRESSED) != 0 ? (n3 |= 0) : ((n2 & Kernel32.MOUSE_EVENT_RECORD.RIGHTMOST_BUTTON_PRESSED) != 0 ? (n3 |= 1) : ((n2 & Kernel32.MOUSE_EVENT_RECORD.FROM_LEFT_2ND_BUTTON_PRESSED) != 0 ? (n3 |= 2) : (n3 |= 3)));
        }
        short s = mOUSE_EVENT_RECORD.mousePosition.x;
        short s2 = mOUSE_EVENT_RECORD.mousePosition.y;
        this.mouse[3] = (char)(32 + n3);
        this.mouse[4] = (char)(32 + s + 1);
        this.mouse[5] = (char)(32 + s2 + 1);
        this.slaveInputPipe.write(this.mouse);
    }

    @Override
    public Cursor getCursorPosition(IntConsumer intConsumer) {
        Kernel32.CONSOLE_SCREEN_BUFFER_INFO cONSOLE_SCREEN_BUFFER_INFO = new Kernel32.CONSOLE_SCREEN_BUFFER_INFO();
        long l = Kernel32.GetStdHandle((int)Kernel32.STD_OUTPUT_HANDLE);
        if (Kernel32.GetConsoleScreenBufferInfo((long)l, (Kernel32.CONSOLE_SCREEN_BUFFER_INFO)cONSOLE_SCREEN_BUFFER_INFO) == 0) {
            throw new IOError(new IOException("Could not get the cursor position: " + WindowsSupport.getLastErrorMessage()));
        }
        return new Cursor(cONSOLE_SCREEN_BUFFER_INFO.cursorPosition.x, cONSOLE_SCREEN_BUFFER_INFO.cursorPosition.y);
    }

    public void disableScrolling() {
        this.strings.remove((Object)InfoCmp.Capability.insert_line);
        this.strings.remove((Object)InfoCmp.Capability.parm_insert_line);
        this.strings.remove((Object)InfoCmp.Capability.delete_line);
        this.strings.remove((Object)InfoCmp.Capability.parm_delete_line);
    }
}

